/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FixedFluidInv;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.FluidInvUtil;
import alexiil.mc.lib.attributes.fluid.FluidTransferable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.AggregateFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Ref;
import alexiil.mc.lib.attributes.misc.Reference;
import java.math.RoundingMode;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public final class FluidVolumeUtil {
    public static final FluidVolume EMPTY = FluidKeys.EMPTY.withAmount(FluidAmount.ZERO);

    private FluidVolumeUtil() {
    }

    public static FluidVolume move(FluidExtractable from, FluidInsertable to) {
        return FluidVolumeUtil.move(from, to, null, FluidAmount.MAX_BUCKETS, Simulation.ACTION);
    }

    public static FluidVolume move(FluidExtractable from, FluidInsertable to, Simulation simulation) {
        return FluidVolumeUtil.move(from, to, null, FluidAmount.MAX_BUCKETS, simulation);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    public static FluidVolume move(FluidExtractable from, FluidInsertable to, int maximum) {
        return FluidVolumeUtil.move(from, to, null, FluidAmount.of1620(maximum), Simulation.ACTION);
    }

    public static FluidVolume move(FluidExtractable from, FluidInsertable to, FluidAmount maximum) {
        return FluidVolumeUtil.move(from, to, null, maximum, Simulation.ACTION);
    }

    public static FluidVolume move(FluidExtractable from, FluidInsertable to, FluidAmount maximum, Simulation simulation) {
        return FluidVolumeUtil.move(from, to, null, maximum, simulation);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    public static FluidVolume move(FluidExtractable from, FluidInsertable to, FluidFilter filter, int maximum) {
        return FluidVolumeUtil.move(from, to, filter, FluidAmount.of1620(maximum), Simulation.ACTION);
    }

    public static FluidVolume move(FluidExtractable from, FluidInsertable to, FluidFilter filter) {
        return FluidVolumeUtil.move(from, to, filter, null, Simulation.ACTION);
    }

    public static FluidVolume move(FluidExtractable from, FluidInsertable to, FluidFilter filter, Simulation simulation) {
        return FluidVolumeUtil.move(from, to, filter, null, simulation);
    }

    public static FluidVolume move(FluidExtractable from, FluidInsertable to, @Nullable FluidFilter filter, @Nullable FluidAmount maximum) {
        return FluidVolumeUtil.move(from, to, filter, maximum, Simulation.ACTION);
    }

    public static FluidVolume move(FluidExtractable from, FluidInsertable to, @Nullable FluidFilter filter, @Nullable FluidAmount maximum, Simulation simulation) {
        FluidVolume extracted;
        FluidFilter insertionFilter = to.getInsertionFilter();
        if (filter != null && filter != ConstantFluidFilter.ANYTHING) {
            insertionFilter = AggregateFluidFilter.and(insertionFilter, filter);
        }
        if (maximum == null) {
            maximum = FluidAmount.MAX_BUCKETS;
        }
        if ((extracted = from.attemptExtraction(insertionFilter, maximum, Simulation.SIMULATE)).isEmpty()) {
            return EMPTY;
        }
        FluidVolume firstLeftover = to.attemptInsertion(extracted, Simulation.SIMULATE);
        FluidAmount firstInserted = extracted.getAmount_F().roundedSub(firstLeftover.getAmount_F());
        if (!firstInserted.isPositive()) {
            return EMPTY;
        }
        ExactFluidFilter keyFilter = extracted.fluidKey.exactFilter;
        FluidVolume exactExtracted = from.attemptExtraction((FluidFilter)keyFilter, firstInserted, Simulation.SIMULATE);
        if (!exactExtracted.getAmount_F().equals(firstInserted)) {
            return EMPTY;
        }
        FluidVolume reallyExtracted = from.attemptExtraction((FluidFilter)keyFilter, firstInserted, simulation);
        if (!reallyExtracted.equals(exactExtracted)) {
            throw FluidVolumeUtil.throwBadImplException("A simulated extraction (returning A) didn't match the real extraction (returning B) from the fluid extractable C!", new String[]{"fluid A", "fluid B", "from C", "filter D"}, new Object[]{exactExtracted, reallyExtracted, from, insertionFilter});
        }
        FluidVolume leftover = to.attemptInsertion(reallyExtracted, simulation);
        if (leftover.isEmpty()) {
            return reallyExtracted;
        }
        throw FluidVolumeUtil.throwBadImplException("A simulated insertion (of A returning B) didn't match the real insertion (of C returning D) into the fluid insertable E!", new String[]{"inserted A", "result B", "inserted C", "result D", "insertable E"}, new Object[]{extracted, firstLeftover, reallyExtracted, leftover, to});
    }

    @Deprecated(since="0.5.0", forRemoval=true)
    public static FluidInsertable createItemInventoryInsertable(Ref<class_1799> stackRef, Consumer<class_1799> excessStacks) {
        return (FluidInsertable)FluidAttributes.INSERTABLE.get(stackRef, LimitedConsumer.fromConsumer(excessStacks));
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidExtractable createItemInventoryExtractable(Ref<class_1799> stackRef, Consumer<class_1799> excessStacks) {
        return (FluidExtractable)FluidAttributes.EXTRACTABLE.get(stackRef, LimitedConsumer.fromConsumer(excessStacks));
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static boolean interactWithTank(FixedFluidInv inv, class_1657 player, class_1268 hand) {
        return FluidInvUtil.interactHandWithTank(inv, player, hand).didMoveAny();
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static boolean interactWithTank(FluidTransferable inv, class_1657 player, class_1268 hand) {
        return FluidInvUtil.interactHandWithTank(inv, player, hand).didMoveAny();
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static boolean interactWithTank(@Nullable FluidInsertable invInsert, @Nullable FluidExtractable invExtract, class_1657 player, class_1268 hand) {
        return FluidInvUtil.interactHandWithTank(invInsert, invExtract, player, hand).didMoveAny();
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static boolean interactCursorWithTank(FixedFluidInv inv, class_3222 player) {
        return FluidInvUtil.interactCursorWithTank(inv, player).didMoveAny();
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static boolean interactCursorWithTank(FluidTransferable inv, class_3222 player) {
        return FluidInvUtil.interactCursorWithTank(inv, player).didMoveAny();
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static boolean interactCursorWithTank(FluidInsertable invInsert, FluidExtractable invExtract, class_3222 player) {
        return FluidInvUtil.interactCursorWithTank(invInsert, invExtract, player).didMoveAny();
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static boolean interactWithTank(@Nullable FluidInsertable invInsert, @Nullable FluidExtractable invExtract, class_1657 player, Reference<class_1799> mainStackRef) {
        return FluidInvUtil.interactWithTank(invInsert, invExtract, player, mainStackRef).didMoveAny();
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidTankInteraction interactWithTank(FixedFluidInv inv, Ref<class_1799> stack, Consumer<class_1799> excessStacks) {
        return FluidVolumeUtil.interactWithTank(inv.getInsertable(), inv.getExtractable(), stack, excessStacks);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidTankInteraction interactWithTank(FluidTransferable inv, Ref<class_1799> stack, Consumer<class_1799> excessStacks) {
        return FluidVolumeUtil.interactWithTank((FluidInsertable)inv, (FluidExtractable)inv, stack, excessStacks);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidTankInteraction interactWithTank(FluidInsertable invInsert, FluidExtractable invExtract, Ref<class_1799> stack, Consumer<class_1799> excessStacks) {
        return FluidInvUtil.interactItemWithTank(invInsert, invExtract, stack, (LimitedConsumer<class_1799>)LimitedConsumer.fromConsumer(excessStacks));
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidTankInteraction interactWithTank(FixedFluidInv inv, Reference<class_1799> stack, LimitedConsumer<class_1799> excessStacks) {
        return FluidInvUtil.interactItemWithTank(inv.getInsertable(), inv.getExtractable(), stack, excessStacks);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidTankInteraction interactWithTank(FluidTransferable inv, Reference<class_1799> stack, LimitedConsumer<class_1799> excessStacks) {
        return FluidInvUtil.interactItemWithTank((FluidInsertable)inv, inv, stack, excessStacks);
    }

    @Deprecated(since="0.6.4", forRemoval=true)
    public static FluidTankInteraction interactWithTank(FluidInsertable invInsert, FluidExtractable invExtract, Reference<class_1799> stack, LimitedConsumer<class_1799> excessStacks) {
        return FluidInvUtil.interactItemWithTank(invInsert, invExtract, stack, excessStacks);
    }

    @Deprecated(since="0.8.0", forRemoval=true)
    public static FluidVolume insertSingle(FixedFluidInv inv, int tank, FluidVolume toInsert, Simulation simulation) {
        return inv.insertFluid(tank, toInsert, simulation);
    }

    public static FluidTransferResult computeInsertion(FluidVolume current, FluidAmount capacity, FluidVolume toInsert) {
        FluidVolume insertCopy;
        if (toInsert.isEmpty()) {
            return new FluidTransferResult(toInsert, current);
        }
        FluidAmount currentA = current.getAmount_F();
        FluidAmount max = (FluidAmount)currentA.roundedAdd(toInsert.getAmount_F(), RoundingMode.DOWN).min(capacity);
        FluidAmount addable = max.roundedSub(currentA, RoundingMode.UP);
        if (!addable.isPositive()) {
            return new FluidTransferResult(toInsert, current);
        }
        if (currentA.isPositive() && !current.canMerge(toInsert)) {
            return new FluidTransferResult(toInsert, current);
        }
        FluidVolume merged = FluidVolume.merge(current = current.copy(), (insertCopy = toInsert.copy()).split(addable));
        if (merged == null) {
            return new FluidTransferResult(toInsert, current);
        }
        return new FluidTransferResult(insertCopy, merged);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    public static FluidVolume extractSingle(FixedFluidInv inv, int tank, @Nullable FluidFilter filter, FluidVolume toAddWith, int maxAmount, Simulation simulation) {
        return FluidVolumeUtil.extractSingle(inv, tank, filter, toAddWith, FluidAmount.of1620(maxAmount), simulation);
    }

    @Deprecated(since="0.8.0", forRemoval=true)
    public static FluidVolume extractSingle(FixedFluidInv inv, int tank, @Nullable FluidFilter filter, FluidVolume toAddWith, FluidAmount maxAmount, Simulation simulation) {
        return inv.extractFluid(tank, filter, toAddWith, maxAmount, simulation);
    }

    public static FluidTransferResult computeExtraction(FluidVolume inTank, FluidFilter filter, FluidAmount maxAmount) {
        return FluidVolumeUtil.computeExtraction(inTank, filter, EMPTY, maxAmount);
    }

    public static FluidTransferResult computeExtraction(FluidVolume inTank, FluidFilter filter, FluidVolume toAddWith, FluidAmount maxAmount) {
        FluidVolume merged;
        if (inTank.isEmpty() || filter != null && !filter.matches(inTank.fluidKey)) {
            return new FluidTransferResult(toAddWith, inTank);
        }
        FluidVolume addable = (inTank = inTank.copy()).split(maxAmount);
        if (addable.isEmpty()) {
            return new FluidTransferResult(toAddWith, inTank);
        }
        if (!toAddWith.isEmpty()) {
            toAddWith = toAddWith.copy();
        }
        if ((merged = FluidVolume.merge(toAddWith, addable)) != null) {
            toAddWith = merged;
        }
        return new FluidTransferResult(toAddWith, inTank);
    }

    private static IllegalStateException throwBadImplException(String reason, String[] names, Object[] objs) {
        Object detail = "\n";
        int max = Math.max(names.length, objs.length);
        for (int i = 0; i < max; ++i) {
            String name = names.length <= i ? "?" : names[i];
            String obj = objs.length <= i ? "" : objs[i];
            detail = (String)detail + "\n" + name + " = " + obj;
        }
        throw new IllegalStateException(reason + (String)detail);
    }

    public static final class FluidTankInteraction {
        public static final FluidTankInteraction NONE = new FluidTankInteraction(EMPTY, false);
        public final FluidVolume fluidMoved;
        public final boolean intoTank;
        public final ItemContainerStatus intoTankStatus;
        public final ItemContainerStatus fromTankStatus;

        @Deprecated(since="0.6.4", forRemoval=true)
        public static FluidTankInteraction intoTank(FluidVolume fluid) {
            return new FluidTankInteraction(fluid, true);
        }

        @Deprecated(since="0.6.4", forRemoval=true)
        public static FluidTankInteraction fromTank(FluidVolume fluid) {
            return new FluidTankInteraction(fluid, false);
        }

        public static FluidTankInteraction none(ItemContainerStatus intoTankStatus, ItemContainerStatus fromTankStatus) {
            return new FluidTankInteraction(EMPTY, false, intoTankStatus, fromTankStatus);
        }

        @Deprecated(since="0.6.4", forRemoval=true)
        public FluidTankInteraction(FluidVolume fluidMoved, boolean intoTank) {
            this.fluidMoved = fluidMoved;
            this.intoTank = intoTank;
            this.intoTankStatus = ItemContainerStatus.NOT_CHECKED;
            this.fromTankStatus = ItemContainerStatus.NOT_CHECKED;
        }

        public FluidTankInteraction(FluidVolume fluidMoved, boolean intoTank, ItemContainerStatus intoTankStatus, ItemContainerStatus fromTankStatus) {
            this.fluidMoved = fluidMoved;
            this.intoTank = intoTank;
            this.intoTankStatus = intoTankStatus == null ? ItemContainerStatus.NOT_CHECKED : intoTankStatus;
            this.fromTankStatus = fromTankStatus == null ? ItemContainerStatus.NOT_CHECKED : fromTankStatus;
        }

        public boolean didMoveAny() {
            return !this.fluidMoved.isEmpty();
        }

        public boolean wasContainerValid() {
            return this.intoTankStatus == ItemContainerStatus.VALID || this.fromTankStatus == ItemContainerStatus.VALID;
        }

        public boolean didCheckItemStack() {
            return this.intoTankStatus != ItemContainerStatus.NOT_CHECKED || this.fromTankStatus != ItemContainerStatus.NOT_CHECKED;
        }

        public class_1269 asActionResult() {
            if (this.didMoveAny()) {
                return class_1269.field_5812;
            }
            return this.wasContainerValid() ? class_1269.field_5814 : class_1269.field_5811;
        }

        @Deprecated(since="0.6.0", forRemoval=true)
        public int amountMoved() {
            return this.fluidMoved.getAmount();
        }

        public FluidAmount amountMoved_F() {
            return this.fluidMoved.getAmount_F();
        }
    }

    public static final class FluidTransferResult {
        public final FluidVolume result;
        public final FluidVolume inTank;

        public FluidTransferResult(FluidVolume result, FluidVolume inTank) {
            this.result = result;
            this.inTank = inTank;
        }
    }

    public static enum ItemContainerStatus {
        INVALID,
        NOT_CHECKED,
        VALID;

    }
}

