/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.FilteredFluidTransferable;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface FluidTransferable
extends FluidInsertable,
FluidExtractable {
    @Override
    default public FluidTransferable filtered(FluidFilter filter) {
        return new FilteredFluidTransferable(this, filter);
    }

    @Nonnull
    public static FluidTransferable from(final FluidInsertable insertable) {
        return new FluidTransferable(){

            @Override
            public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
                return insertable.attemptInsertion(fluid, simulation);
            }

            @Override
            public FluidFilter getInsertionFilter() {
                return insertable.getInsertionFilter();
            }

            @Override
            @Nullable
            public FluidAmount getMinimumAcceptedAmount() {
                return insertable.getMinimumAcceptedAmount();
            }

            @Override
            public FluidVolume attemptExtraction(FluidFilter filter, int maxAmount, Simulation simulation) {
                return FluidKeys.EMPTY.withAmount(FluidAmount.ZERO);
            }

            @Override
            public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
                return FluidKeys.EMPTY.withAmount(FluidAmount.ZERO);
            }
        };
    }

    @Nonnull
    public static FluidTransferable from(final FluidExtractable extractable) {
        return new FluidTransferable(){

            @Override
            public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
                return fluid;
            }

            @Override
            public FluidFilter getInsertionFilter() {
                return ConstantFluidFilter.NOTHING;
            }

            @Override
            @Deprecated(since="0.6.0", forRemoval=true)
            public FluidVolume attemptExtraction(FluidFilter filter, int maxAmount, Simulation simulation) {
                return extractable.attemptExtraction(filter, maxAmount, simulation);
            }

            @Override
            @Deprecated(since="0.6.0", forRemoval=true)
            public FluidVolume attemptAnyExtraction(int maxAmount, Simulation simulation) {
                return extractable.attemptAnyExtraction(maxAmount, simulation);
            }

            @Override
            public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
                return extractable.attemptExtraction(filter, maxAmount, simulation);
            }

            @Override
            public FluidVolume attemptAnyExtraction(FluidAmount maxAmount, Simulation simulation) {
                return extractable.attemptAnyExtraction(maxAmount, simulation);
            }
        };
    }

    @Nonnull
    public static FluidTransferable from(final FluidInsertable insertable, final FluidExtractable extractable) {
        if (insertable == extractable && insertable instanceof FluidTransferable) {
            return (FluidTransferable)insertable;
        }
        return new FluidTransferable(){

            @Override
            public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
                return insertable.attemptInsertion(fluid, simulation);
            }

            @Override
            public FluidFilter getInsertionFilter() {
                return insertable.getInsertionFilter();
            }

            @Override
            @Nullable
            public FluidAmount getMinimumAcceptedAmount() {
                return insertable.getMinimumAcceptedAmount();
            }

            @Override
            @Deprecated(since="0.6.0", forRemoval=true)
            public FluidVolume attemptExtraction(FluidFilter filter, int maxAmount, Simulation simulation) {
                return extractable.attemptExtraction(filter, maxAmount, simulation);
            }

            @Override
            @Deprecated(since="0.6.0", forRemoval=true)
            public FluidVolume attemptAnyExtraction(int maxAmount, Simulation simulation) {
                return extractable.attemptAnyExtraction(maxAmount, simulation);
            }

            @Override
            public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
                return extractable.attemptExtraction(filter, maxAmount, simulation);
            }

            @Override
            public FluidVolume attemptAnyExtraction(FluidAmount maxAmount, Simulation simulation) {
                return extractable.attemptAnyExtraction(maxAmount, simulation);
            }
        };
    }
}

