/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilterUtil;
import alexiil.mc.lib.attributes.fluid.mixin.api.IBucketItem;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.AbstractItemBasedAttribute;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Reference;
import java.util.Set;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

abstract class FluidItemBase
extends AbstractItemBasedAttribute {
    protected FluidItemBase(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excessStacks) {
        super(stackRef, excessStacks);
    }

    static boolean isIBucket(class_1799 stack) {
        return FluidItemBase.isIBucket(stack.method_7909());
    }

    static boolean isIBucket(class_1792 item) {
        if (item instanceof class_1785) {
            return false;
        }
        return item instanceof IBucketItem && ((IBucketItem)item).libblockattributes__shouldExposeFluid();
    }

    GroupedFluidInvView.FluidInvStatistic getIBucketStatistics(class_1799 stack, FluidFilter filter) {
        if (!FluidItemBase.isIBucket(stack)) {
            return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
        }
        IBucketItem bucket = (IBucketItem)stack.method_7909();
        FluidKey current = bucket.libblockattributes__getFluid(stack);
        if (current != FluidKeys.EMPTY) {
            if (filter.matches(current)) {
                FluidAmount perBucket = bucket.libblockattributes__getFluidVolumeAmount();
                FluidAmount amount = perBucket.checkedMul(stack.method_7947());
                return new GroupedFluidInvView.FluidInvStatistic(filter, amount, FluidAmount.ZERO, amount);
            }
            return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
        }
        Set<FluidKey> any = FluidFilterUtil.decomposeFilter(filter);
        if (any != null) {
            FluidAmount perBucket = bucket.libblockattributes__getFluidVolumeAmount();
            FluidAmount space = perBucket.checkedMul(stack.method_7947());
            for (FluidKey key : any) {
                if (bucket.libblockattributes__withFluid(key).method_7960()) continue;
                return new GroupedFluidInvView.FluidInvStatistic(filter, FluidAmount.ZERO, FluidAmount.ZERO, space);
            }
        }
        return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
    }

    FluidVolume attemptIBucketInsertion(class_1799 stack, FluidVolume fluid, Simulation simulation) {
        if (!FluidItemBase.isIBucket(stack)) {
            return fluid;
        }
        IBucketItem bucket = (IBucketItem)stack.method_7909();
        FluidAmount perBucket = bucket.libblockattributes__getFluidVolumeAmount();
        if (fluid.getAmount_F().isLessThan(perBucket)) {
            return fluid;
        }
        FluidKey current = bucket.libblockattributes__getFluid(stack);
        if (!current.isEmpty()) {
            return fluid;
        }
        class_1799 newStack = bucket.libblockattributes__withFluid(fluid.fluidKey);
        if (newStack.method_7960()) {
            return fluid;
        }
        stack = stack.method_7972();
        stack.method_7934(1);
        FluidVolume originalFluid = fluid;
        fluid = fluid.copy();
        FluidVolume splitOff = fluid.split(perBucket);
        if (!splitOff.getAmount_F().equals(perBucket)) {
            throw new IllegalStateException("Split off amount was not equal to perBucket!\n\tsplitOff = " + splitOff + "\n\tfluid = " + fluid + "\n\tperBucket = " + perBucket);
        }
        return this.setStacks(simulation, stack, newStack) ? fluid : originalFluid;
    }
}

