/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.FilteredFluidInsertable;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import javax.annotation.Nullable;

@FunctionalInterface
public interface FluidInsertable
extends LimitedConsumer<FluidVolume> {
    public FluidVolume attemptInsertion(FluidVolume var1, Simulation var2);

    @Deprecated
    default public boolean offer(FluidVolume fluid, Simulation simulation) {
        return this.attemptInsertion(fluid, simulation).isEmpty();
    }

    @Deprecated
    default public boolean offer(FluidVolume object) {
        return this.insert(object).isEmpty();
    }

    @Deprecated
    default public boolean wouldAccept(FluidVolume object) {
        return this.attemptInsertion(object, Simulation.SIMULATE).isEmpty();
    }

    default public FluidVolume insert(FluidVolume fluid) {
        return this.attemptInsertion(fluid, Simulation.ACTION);
    }

    @Nullable
    default public FluidAmount getMinimumAcceptedAmount() {
        return null;
    }

    default public FluidFilter getInsertionFilter() {
        return ConstantFluidFilter.ANYTHING;
    }

    default public FluidInsertable filtered(FluidFilter filter) {
        return new FilteredFluidInsertable(this, filter);
    }

    default public FluidInsertable getPureInsertable() {
        final FluidInsertable delegate = this;
        return new FluidInsertable(){

            @Override
            public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
                return delegate.attemptInsertion(fluid, simulation);
            }

            @Override
            public FluidFilter getInsertionFilter() {
                return delegate.getInsertionFilter();
            }
        };
    }
}

