/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.AttributeUtil;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.FilteredFluidExtractable;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import java.lang.reflect.Method;
import java.math.RoundingMode;

public interface FluidExtractable {
    default public FluidVolume attemptExtraction(FluidFilter filter, int maxAmount, Simulation simulation) {
        if (AttributeUtil.EXPENSIVE_DEBUG_CHECKS) {
            FluidExtractable.validateFluidExtractable(this);
        }
        return this.attemptExtraction(filter, FluidAmount.of1620(maxAmount), simulation);
    }

    default public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
        if (AttributeUtil.EXPENSIVE_DEBUG_CHECKS) {
            FluidExtractable.validateFluidExtractable(this);
        }
        return this.attemptExtraction(filter, maxAmount.asInt(1620, RoundingMode.DOWN), simulation);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    default public FluidVolume attemptAnyExtraction(int maxAmount, Simulation simulation) {
        return this.attemptExtraction((FluidFilter)ConstantFluidFilter.ANYTHING, maxAmount, simulation);
    }

    default public FluidVolume attemptAnyExtraction(FluidAmount maxAmount, Simulation simulation) {
        return this.attemptExtraction((FluidFilter)ConstantFluidFilter.ANYTHING, maxAmount, simulation);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    default public FluidVolume extract(FluidFilter filter, int maxAmount) {
        return this.attemptExtraction(filter, maxAmount, Simulation.ACTION);
    }

    default public FluidVolume extract(FluidFilter filter, FluidAmount maxAmount) {
        return this.attemptExtraction(filter, maxAmount, Simulation.ACTION);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    default public FluidVolume extract(FluidKey filter, int maxAmount) {
        return this.attemptExtraction((FluidFilter)filter.exactFilter, maxAmount, Simulation.ACTION);
    }

    default public FluidVolume extract(FluidKey filter, FluidAmount maxAmount) {
        return this.attemptExtraction((FluidFilter)filter.exactFilter, maxAmount, Simulation.ACTION);
    }

    @Deprecated(since="0.6.0", forRemoval=true)
    default public FluidVolume extract(int maxAmount) {
        return this.attemptExtraction((FluidFilter)ConstantFluidFilter.ANYTHING, maxAmount, Simulation.ACTION);
    }

    default public FluidVolume extract(FluidAmount maxAmount) {
        return this.attemptExtraction((FluidFilter)ConstantFluidFilter.ANYTHING, maxAmount, Simulation.ACTION);
    }

    default public boolean couldExtractAnything() {
        return !this.attemptAnyExtraction(FluidAmount.ONE, Simulation.SIMULATE).isEmpty();
    }

    public static void validateFluidExtractable(FluidExtractable instance) {
        Class<?> c = instance.getClass();
        try {
            Method m0 = c.getMethod("attemptExtraction", FluidFilter.class, Integer.TYPE, Simulation.class);
            Method m1 = c.getMethod("attemptExtraction", FluidFilter.class, FluidAmount.class, Simulation.class);
            if (m0.getDeclaringClass() == FluidExtractable.class && m1.getDeclaringClass() == FluidExtractable.class) {
                throw new Error("The " + c + " needs to override either attemptExtraction(FluidFilter, int, Simulation) or attemptExtraction(FluidFilter, FluidAmount, Simulation)!");
            }
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    default public FluidExtractable filtered(FluidFilter filter) {
        return new FilteredFluidExtractable(this, filter);
    }

    default public FluidExtractable getPureExtractable() {
        final FluidExtractable delegate = this;
        return new FluidExtractable(){

            @Override
            @Deprecated
            public FluidVolume attemptExtraction(FluidFilter filter, int maxAmount, Simulation simulation) {
                return delegate.attemptExtraction(filter, maxAmount, simulation);
            }

            @Override
            public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
                return delegate.attemptExtraction(filter, maxAmount, simulation);
            }

            @Override
            @Deprecated
            public FluidVolume attemptAnyExtraction(int maxAmount, Simulation simulation) {
                return delegate.attemptAnyExtraction(maxAmount, simulation);
            }

            @Override
            public FluidVolume attemptAnyExtraction(FluidAmount maxAmount, Simulation simulation) {
                return delegate.attemptAnyExtraction(maxAmount, simulation);
            }
        };
    }
}

