/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.AttributeSourceType;
import alexiil.mc.lib.attributes.CombinableAttribute;
import alexiil.mc.lib.attributes.CompatLeveledMap;
import alexiil.mc.lib.attributes.ItemAttributeAdder;
import alexiil.mc.lib.attributes.ItemAttributeList;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FluidAttributes;
import alexiil.mc.lib.attributes.fluid.FluidItemBase;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ExactFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.AbstractItemBasedAttribute;
import alexiil.mc.lib.attributes.misc.LibBlockAttributes;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Reference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class FluidContainerRegistry {
    private static final Map<class_1792, ItemContainerState> containerStates = new IdentityHashMap<class_1792, ItemContainerState>();
    private static final Map<FluidKey, Set<class_1792>> fullContainers = new HashMap<FluidKey, Set<class_1792>>();
    private static final Set<class_1792> emptyItems = new HashSet<class_1792>();
    private static final Set<class_1792> fullItems = new HashSet<class_1792>();
    private static final Map<FluidKey, Set<class_1792>> fullContainersUn = new HashMap<FluidKey, Set<class_1792>>();
    private static final Set<class_1792> emptyItemsUn = Collections.unmodifiableSet(emptyItems);
    private static final Set<class_1792> fullItemsUn = Collections.unmodifiableSet(fullItems);

    private FluidContainerRegistry() {
    }

    public static void mapContainer(class_1792 empty, class_1792 full, FluidVolume fluid) {
        ItemContainerState forEmpty = containerStates.get(empty);
        boolean putEmpty = false;
        if (forEmpty == null) {
            forEmpty = new StateEmpty(empty);
            putEmpty = true;
        }
        if (forEmpty instanceof StateFull) {
            throw new IllegalArgumentException("The item " + forEmpty.itemToString() + " is already mapped as a full item - so we cannot remap it as empty to allow it to be filled with " + fluid + " to make " + ItemContainerState.itemToString(full));
        }
        ((StateEmpty)forEmpty).mapDirectContainer(full, fluid);
        if (putEmpty) {
            containerStates.put(empty, forEmpty);
            forEmpty.addItemAttributes();
        }
        fullContainers.computeIfAbsent(fluid.fluidKey, k -> new HashSet()).add(full);
        emptyItems.add(empty);
        fullItems.add(full);
    }

    public static void registerFillHandler(class_1792 empty, FluidKey fluid, FluidFillHandler handler) {
        FluidContainerRegistry.registerFillHandlerInternal(empty, handler, state -> state.variants.putExact(AttributeSourceType.INSTANCE, (Object)fluid, (Object)handler));
    }

    public static void registerFillHandler(class_1792 empty, FluidKey fluid, FluidAmount minimum, FluidAmount capacity, FluidFillFunction fn) {
        FluidContainerRegistry.registerFillHandler(empty, fluid, new FluidFillHandlerWrapper(minimum, capacity, fn));
    }

    public static void registerFillHandler(class_1792 empty, FluidFilter fluids, boolean isFilterSpecific, FluidFillHandler handler) {
        FluidContainerRegistry.registerFillHandlerInternal(empty, handler, state -> state.variants.addPredicateBased(AttributeSourceType.INSTANCE, isFilterSpecific, fluids.asPredicate(), (Object)handler));
    }

    public static void registerFillHandler(class_1792 empty, FluidFilter fluids, boolean isFilterSpecific, FluidAmount minimum, FluidAmount capacity, FluidFillFunction fn) {
        FluidContainerRegistry.registerFillHandler(empty, fluids, isFilterSpecific, (FluidFillHandler)new FluidFillHandlerWrapper(minimum, capacity, fn));
    }

    public static void registerFillHandler(class_1792 empty, FluidFillHandler handler) {
        FluidContainerRegistry.registerFillHandler(empty, ConstantFluidFilter.ANYTHING, false, handler);
    }

    public static void registerFillHandler(class_1792 empty, FluidAmount minimum, FluidAmount capacity, FluidFillFunction fn) {
        FluidContainerRegistry.registerFillHandler(empty, ConstantFluidFilter.ANYTHING, false, minimum, capacity, fn);
    }

    public static void registerFillHandler(class_1792 empty, Class<?> keyClass, boolean matchSubclasses, FluidFillHandler handler) {
        FluidContainerRegistry.registerFillHandlerInternal(empty, handler, state -> state.variants.putClassBased(AttributeSourceType.INSTANCE, keyClass, matchSubclasses, (Object)handler));
    }

    private static void registerFillHandlerInternal(class_1792 empty, FluidFillHandler handler, Consumer<StateEmpty> registor) {
        ItemContainerState forEmpty = containerStates.get(empty);
        boolean putEmpty = false;
        if (forEmpty == null) {
            forEmpty = new StateEmpty(empty);
            putEmpty = true;
        }
        if (forEmpty instanceof StateFull) {
            throw new IllegalArgumentException("The item " + forEmpty.itemToString() + " is already mapped as a full item - so we cannot remap it as empty to allow it to be handled by " + handler);
        }
        StateEmpty state = (StateEmpty)forEmpty;
        registor.accept(state);
        FluidAmount fluidAmount = state.minimum = state.minimum == null ? handler.minimum : (FluidAmount)state.minimum.min(handler.minimum);
        if (putEmpty) {
            containerStates.put(empty, forEmpty);
            forEmpty.addItemAttributes();
        }
        emptyItems.add(empty);
    }

    public static Set<class_1792> getFullContainersFor(FluidKey fluid) {
        Set<class_1792> set = fullContainersUn.get(fluid);
        if (set == null) {
            Set<class_1792> internal = fullContainers.get(fluid);
            if (internal == null) {
                internal = new HashSet<class_1792>();
                fullContainers.put(fluid, internal);
            }
            set = Collections.unmodifiableSet(internal);
            fullContainersUn.put(fluid, set);
        }
        return set;
    }

    public static Set<class_1792> getEmptyContainers() {
        return emptyItemsUn;
    }

    public static Set<class_1792> getFullContainers() {
        return fullItemsUn;
    }

    public static FluidVolume getContainedFluid(class_1792 item) {
        ItemContainerState state = containerStates.get(item);
        if (state instanceof StateFull) {
            return ((StateFull)state).containedFluid.copy();
        }
        return FluidVolumeUtil.EMPTY;
    }

    static {
        FluidAttributes.ensureClassLoaded();
    }

    static abstract class ItemContainerState {
        final class_1792 item;

        ItemContainerState(class_1792 item) {
            this.item = item;
        }

        static String itemToString(class_1792 item) {
            class_2960 id = class_2378.field_11142.method_10221((Object)item);
            if (id == null || class_2378.field_11142.method_10137().equals((Object)id)) {
                return "{UnregisteredItem " + item.getClass() + " #" + System.identityHashCode(item) + "}";
            }
            return "{Item " + id + " #" + System.identityHashCode(item) + "}";
        }

        final String itemToString() {
            return ItemContainerState.itemToString(this.item);
        }

        abstract void addItemAttributes();
    }

    static final class StateEmpty
    extends ItemContainerState {
        final CompatLeveledMap<FluidKey, FluidKey, FluidFillHandler> variants = new CompatLeveledMap("{fluid fill handler for " + this.itemToString() + "}", FluidKey.class, (Object)NullFluidFillHandler.INSTANCE, FluidKey::toString);
        FluidAmount minimum;

        StateEmpty(class_1792 item) {
            super(item);
        }

        void mapDirectContainer(class_1792 fullItem, FluidVolume fluid) {
            ItemContainerState fullState = containerStates.get(fullItem);
            if (fullState instanceof StateFull) {
                StateFull state = (StateFull)fullState;
                if (state.emptyItem != this.item) {
                    LibBlockAttributes.LOGGER.warn("[FluidContainerRegistry] Rejecting a new mapping with " + this.itemToString() + " as an empty item to " + state.itemToString() + " because it already has a mapping from a different empty item: " + StateEmpty.itemToString(state.emptyItem));
                    return;
                }
                if (!state.containedFluid.equals(fluid)) {
                    LibBlockAttributes.LOGGER.warn("[FluidContainerRegistry] Rejecting a new mapping with " + this.itemToString() + " as an empty item to " + state.itemToString() + " containing " + fluid + " because it already has a mapping to a different fluid: " + state.containedFluid);
                    return;
                }
                return;
            }
            if (fullState != null) {
                throw new IllegalArgumentException("Cannot map " + this.itemToString() + "as an empty item to " + fullState.itemToString() + " because that item has already been mapped as empty!");
            }
            StateFull state = new StateFull(fullItem, this.item, fluid);
            containerStates.put(fullItem, state);
            SimpleDirectFillHandler handler = new SimpleDirectFillHandler(fluid.amount(), fullItem);
            this.variants.putExact(AttributeSourceType.INSTANCE, (Object)fluid.fluidKey, (Object)handler);
            state.addItemAttributes();
            this.minimum = this.minimum == null ? fluid.amount() : (FluidAmount)this.minimum.min(fluid.amount());
        }

        @Override
        void addItemAttributes() {
            FluidAttributes.forEachGroupedInv(attribute -> this.setupItemAdder((CombinableAttribute)attribute));
        }

        private <T> void setupItemAdder(CombinableAttribute<T> attribute) {
            attribute.setItemAdder(AttributeSourceType.INSTANCE, this.item, new ItemAttributeAdder<T>(){

                public void addAll(Reference<class_1799> ref, LimitedConsumer<class_1799> excess, ItemAttributeList<T> list) {
                    list.offer((Object)new EmptyBucketInv(ref, excess));
                }

                public String toString() {
                    return this.toString();
                }
            });
        }

        public String toString() {
            return "{FluidContainerRegistry.StateEmpty for " + this.itemToString() + "}";
        }

        class EmptyBucketInv
        extends FluidItemBase
        implements GroupedFluidInv {
            public EmptyBucketInv(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excessStacks) {
                super(stackRef, excessStacks);
            }

            @Override
            public Set<FluidKey> getStoredFluids() {
                return Collections.emptySet();
            }

            @Override
            public GroupedFluidInvView.FluidInvStatistic getStatistics(FluidFilter filter) {
                class_1799 stack = (class_1799)this.stackRef.get();
                if (stack.method_7960() || stack.method_7909() != StateEmpty.this.item) {
                    return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
                }
                if (filter instanceof ExactFluidFilter) {
                    FluidKey fluid = ((ExactFluidFilter)filter).fluid;
                    FluidFillHandler handler = (FluidFillHandler)StateEmpty.this.variants.get((Object)fluid, fluid.getClass());
                    if (handler == null) {
                        return this.getIBucketStatistics(stack, filter);
                    }
                    FluidAmount capacity = handler.getCapacity(filter).mul(stack.method_7947());
                    return new GroupedFluidInvView.FluidInvStatistic(filter, FluidAmount.ZERO, FluidAmount.ZERO, capacity);
                }
                return new GroupedFluidInvView.FluidInvStatistic(filter, FluidAmount.ZERO, FluidAmount.ZERO, FluidAmount.NEGATIVE_ONE);
            }

            @Override
            public FluidAmount getAmount_F(FluidKey fluid) {
                return FluidAmount.ZERO;
            }

            @Override
            public FluidVolume attemptInsertion(FluidVolume fluid, final Simulation simulation) {
                class_1799 stack = (class_1799)this.stackRef.get();
                if (stack.method_7960() || stack.method_7909() != StateEmpty.this.item) {
                    return fluid;
                }
                if (fluid.isEmpty()) {
                    return fluid;
                }
                FluidFillHandler handler = (FluidFillHandler)StateEmpty.this.variants.get((Object)fluid.fluidKey, fluid.fluidKey.getClass());
                if (handler == null) {
                    return this.attemptIBucketInsertion(stack, fluid, simulation);
                }
                if (fluid.amount().isLessThan(handler.minimum)) {
                    return fluid;
                }
                FluidFillHandler.StackReturnFunc stackReturn = new FluidFillHandler.StackReturnFunc(){
                    boolean called = false;

                    @Override
                    public boolean returnStacks(class_1799 oldS, class_1799 newS) {
                        if (this.called) {
                            throw new IllegalStateException("Due to the unknowns involved in LimitedConsumer it's not generally useful (or accurate) to call returnStacks multiple times!");
                        }
                        this.called = true;
                        return EmptyBucketInv.this.setStacks(simulation, oldS, newS);
                    }
                };
                return handler.insert(stack.method_7972(), fluid, simulation, stackReturn);
            }

            @Override
            public FluidAmount getMinimumAcceptedAmount() {
                return StateEmpty.this.minimum;
            }

            @Override
            public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
                return FluidVolumeUtil.EMPTY;
            }

            public String toString() {
                return "{FluidContainerRegistry.EmptyBucket for " + StateEmpty.this.itemToString() + " in " + this.stackRef + "}";
            }
        }
    }

    static final class StateFull
    extends ItemContainerState {
        final class_1792 emptyItem;
        final FluidVolume containedFluid;

        StateFull(class_1792 fullItem, class_1792 emptyItem, FluidVolume containedFluid) {
            super(fullItem);
            this.emptyItem = emptyItem;
            this.containedFluid = containedFluid;
        }

        void linkFull(class_1792 fullItem, FluidVolume fluid) {
            throw new IllegalArgumentException("The item " + this.itemToString() + " is already mapped as an empty item - so we cannot remap it as empty to allow it to be filled with " + fluid + " to make " + StateFull.itemToString(fullItem));
        }

        @Override
        void addItemAttributes() {
            FluidAttributes.forEachGroupedInv(attribute -> this.setupItemAdders((CombinableAttribute)attribute));
        }

        private <T> void setupItemAdders(CombinableAttribute<T> attribute) {
            attribute.setItemAdder(AttributeSourceType.INSTANCE, this.item, new ItemAttributeAdder<T>(){

                public void addAll(Reference<class_1799> ref, LimitedConsumer<class_1799> excess, ItemAttributeList<T> list) {
                    list.offer((Object)new FullBucketInv(ref, excess));
                }

                public String toString() {
                    return this.toString();
                }
            });
        }

        public String toString() {
            return "{FluidContainerRegistry.StateFull for " + this.itemToString() + "}";
        }

        class FullBucketInv
        extends AbstractItemBasedAttribute
        implements GroupedFluidInv {
            public FullBucketInv(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excessStacks) {
                super(stackRef, excessStacks);
            }

            @Override
            public Set<FluidKey> getStoredFluids() {
                class_1799 stack = (class_1799)this.stackRef.get();
                if (stack.method_7960() || stack.method_7909() != StateFull.this.item) {
                    return Collections.emptySet();
                }
                return Collections.singleton(StateFull.this.containedFluid.fluidKey);
            }

            @Override
            public GroupedFluidInvView.FluidInvStatistic getStatistics(FluidFilter filter) {
                class_1799 stack = (class_1799)this.stackRef.get();
                if (stack.method_7960() || stack.method_7909() != StateFull.this.item) {
                    return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
                }
                if (!filter.matches(StateFull.this.containedFluid.fluidKey)) {
                    return GroupedFluidInvView.FluidInvStatistic.emptyOf(filter);
                }
                FluidAmount amount = StateFull.this.containedFluid.amount().mul(stack.method_7947());
                return new GroupedFluidInvView.FluidInvStatistic(filter, amount, FluidAmount.ZERO, FluidAmount.ZERO);
            }

            @Override
            public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
                return fluid;
            }

            @Override
            public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
                class_1799 stack = (class_1799)this.stackRef.get();
                if (stack.method_7960() || stack.method_7909() != StateFull.this.item) {
                    return FluidVolumeUtil.EMPTY;
                }
                if (maxAmount.isLessThan(StateFull.this.containedFluid.amount())) {
                    return FluidVolumeUtil.EMPTY;
                }
                if (!filter.matches(StateFull.this.containedFluid.fluidKey)) {
                    return FluidVolumeUtil.EMPTY;
                }
                class_1799 oldStack = stack.method_7972();
                class_1799 newStack = new class_1799((class_1935)StateFull.this.emptyItem);
                oldStack.method_7934(1);
                if (this.setStacks(simulation, oldStack, newStack)) {
                    return StateFull.this.containedFluid.copy();
                }
                return FluidVolumeUtil.EMPTY;
            }

            public String toString() {
                return "{FluidContainerRegistry.FullBucket for " + StateFull.this.itemToString() + " in " + this.stackRef + "}";
            }
        }
    }

    public static abstract class FluidFillHandler {
        public final FluidAmount minimum;

        public FluidFillHandler(FluidAmount minimum) {
            this.minimum = minimum;
        }

        protected abstract FluidVolume insert(class_1799 var1, FluidVolume var2, Simulation var3, StackReturnFunc var4);

        protected abstract FluidAmount getCapacity(FluidFilter var1);

        public static interface StackReturnFunc {
            public boolean returnStacks(class_1799 var1, class_1799 var2);
        }
    }

    static final class FluidFillHandlerWrapper
    extends FluidFillHandler {
        final FluidAmount capacity;
        final FluidFillFunction function;

        FluidFillHandlerWrapper(FluidAmount minimum, FluidAmount capacity, FluidFillFunction function) {
            super(minimum);
            this.capacity = capacity;
            this.function = function;
        }

        @Override
        protected FluidVolume insert(class_1799 stack, FluidVolume fluid, Simulation simulation, FluidFillHandler.StackReturnFunc stackReturn) {
            return this.function.insert(stack, fluid, simulation, stackReturn);
        }

        public String toString() {
            return this.function.toString();
        }

        @Override
        protected FluidAmount getCapacity(FluidFilter filter) {
            return this.capacity;
        }
    }

    @FunctionalInterface
    public static interface FluidFillFunction {
        public FluidVolume insert(class_1799 var1, FluidVolume var2, Simulation var3, FluidFillHandler.StackReturnFunc var4);
    }

    static final class SimpleDirectFillHandler
    extends FluidFillHandler {
        final FluidAmount amount;
        final class_1792 filledItem;

        public SimpleDirectFillHandler(FluidAmount amount, class_1792 filledItem) {
            super(amount);
            this.amount = amount;
            this.filledItem = filledItem;
        }

        @Override
        protected FluidVolume insert(class_1799 stack, FluidVolume fluid, Simulation simulation, FluidFillHandler.StackReturnFunc stackReturn) {
            class_1799 oldStack = stack.method_7972();
            class_1799 newStack = new class_1799((class_1935)this.filledItem);
            oldStack.method_7934(1);
            FluidVolume newFluid = fluid.copy();
            newFluid.split(this.amount);
            return stackReturn.returnStacks(oldStack, newStack) ? newFluid : fluid;
        }

        @Override
        protected FluidAmount getCapacity(FluidFilter filter) {
            return this.amount;
        }
    }

    static final class NullFluidFillHandler
    extends FluidFillHandler {
        static final NullFluidFillHandler INSTANCE = new NullFluidFillHandler();

        private NullFluidFillHandler() {
            super(FluidAmount.MAX_BUCKETS);
        }

        @Override
        protected FluidVolume insert(class_1799 stack, FluidVolume fluid, Simulation simulation, FluidFillHandler.StackReturnFunc stackReturn) {
            return fluid;
        }

        @Override
        protected FluidAmount getCapacity(FluidFilter filter) {
            return FluidAmount.ZERO;
        }
    }
}

