/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.Attribute;
import alexiil.mc.lib.attributes.AttributeCombiner;
import alexiil.mc.lib.attributes.AttributeSourceType;
import alexiil.mc.lib.attributes.Attributes;
import alexiil.mc.lib.attributes.CombinableAttribute;
import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FixedFluidInv;
import alexiil.mc.lib.attributes.fluid.FixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.FluidInvAmountChangeListener_F;
import alexiil.mc.lib.attributes.fluid.FluidItemBase;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.compat.mod.LbaFluidModCompatLoader;
import alexiil.mc.lib.attributes.fluid.filter.AggregateFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.ConstantFluidFilter;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.CombinedFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.impl.CombinedFixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.impl.CombinedFluidExtractable;
import alexiil.mc.lib.attributes.fluid.impl.CombinedFluidInsertable;
import alexiil.mc.lib.attributes.fluid.impl.CombinedGroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.impl.CombinedGroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.impl.EmptyFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.impl.EmptyFluidExtractable;
import alexiil.mc.lib.attributes.fluid.impl.EmptyGroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.impl.RejectingFluidInsertable;
import alexiil.mc.lib.attributes.fluid.mixin.api.IBucketItem;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.lib.attributes.misc.LibBlockAttributes;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Reference;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1799;

public final class FluidAttributes {
    public static final CombinableAttribute<FixedFluidInvView> FIXED_INV_VIEW = FluidAttributes.create(FixedFluidInvView.class, EmptyFixedFluidInv.INSTANCE, CombinedFixedFluidInvView::new, inv -> inv);
    public static final CombinableAttribute<FixedFluidInv> FIXED_INV = FluidAttributes.create(FixedFluidInv.class, EmptyFixedFluidInv.INSTANCE, CombinedFixedFluidInv::new, Function.identity());
    public static final CombinableAttribute<GroupedFluidInvView> GROUPED_INV_VIEW = FluidAttributes.create(GroupedFluidInvView.class, EmptyGroupedFluidInv.INSTANCE, list -> new CombinedGroupedFluidInvView(list), FixedFluidInv::getGroupedInv);
    public static final CombinableAttribute<GroupedFluidInv> GROUPED_INV = FluidAttributes.create(GroupedFluidInv.class, EmptyGroupedFluidInv.INSTANCE, list -> new CombinedGroupedFluidInv(list), FixedFluidInv::getGroupedInv);
    public static final CombinableAttribute<FluidInsertable> INSERTABLE = FluidAttributes.create(FluidInsertable.class, RejectingFluidInsertable.NULL, list -> new CombinedFluidInsertable(list), FixedFluidInv::getInsertable);
    public static final CombinableAttribute<FluidExtractable> EXTRACTABLE = FluidAttributes.create(FluidExtractable.class, EmptyFluidExtractable.NULL, list -> new CombinedFluidExtractable(list), FixedFluidInv::getExtractable);
    public static final CombinableAttribute<FluidFilter> FILTER = Attributes.createCombinable(FluidFilter.class, (Object)ConstantFluidFilter.NOTHING, AggregateFluidFilter::allOf);
    public static final List<CombinableAttribute<?>> INVENTORY_BASED = Arrays.asList(FIXED_INV_VIEW, FIXED_INV, GROUPED_INV_VIEW, GROUPED_INV, INSERTABLE, EXTRACTABLE);
    public static final List<CombinableAttribute<?>> GROUPED_INVENTORY_BASED = Arrays.asList(GROUPED_INV_VIEW, GROUPED_INV, INSERTABLE, EXTRACTABLE);

    private FluidAttributes() {
    }

    public static void forEachInv(Consumer<? super CombinableAttribute<?>> consumer) {
        INVENTORY_BASED.forEach(consumer);
    }

    public static void forEachGroupedInv(Consumer<? super CombinableAttribute<?>> consumer) {
        GROUPED_INVENTORY_BASED.forEach(consumer);
    }

    private static <T> CombinableAttribute<T> create(Class<T> clazz, @Nonnull T defaultValue, AttributeCombiner<T> combiner, Function<FixedFluidInv, T> convertor) {
        CombinableAttribute attribute = Attributes.createCombinable(clazz, defaultValue, combiner);
        AttributeSourceType srcType = AttributeSourceType.COMPAT_WRAPPER;
        attribute.addItemPredicateAdder(srcType, true, FluidItemBase::isIBucket, (ref, excess, list) -> list.offer((Object)new BucketItemGroupedFluidInv((Reference<class_1799>)ref, (LimitedConsumer<class_1799>)excess)));
        return attribute;
    }

    private static void validateEnvironment() throws Error {
        URL coreLoc;
        FabricLoader loader = FabricLoader.getInstance();
        if (loader.getAllMods().isEmpty()) {
            return;
        }
        ModContainer allModule = LibBlockAttributes.LbaModule.ALL.getModContainer();
        ModContainer coreModule = LibBlockAttributes.LbaModule.CORE.getModContainer();
        ModContainer fluidsModule = LibBlockAttributes.LbaModule.FLUIDS.getModContainer();
        if (fluidsModule == null || coreModule == null) {
            if (allModule == null) {
                throw new Error("(No LBA modules present?)\n\nLoaded the LBA FatJar outside of a development environment!\nThis can cause stability issues when older or newer versions\nof the different submodules are present on the classpath, as\nfabric loader cannot load the seperate modules correctly. (Which\nthen causes NoSuchMethodError's, or other strange behaviour)");
            }
            if ("$version".equals(allModule.getMetadata().getVersion().getFriendlyString())) {
                return;
            }
            throw new Error("(Only 'all' present!)\n\nLoaded the LBA FatJar outside of a development environment!\nThis can cause stability issues when older or newer versions\nof the different submodules are present on the classpath, as\nfabric loader cannot load the seperate modules correctly. (Which\nthen causes NoSuchMethodError's, or other strange behaviour)");
        }
        if (loader.isDevelopmentEnvironment()) {
            return;
        }
        Class<FluidAttributes> fluidsClass = FluidAttributes.class;
        Class<Attribute> coreClass = Attribute.class;
        URL fluidsLoc = fluidsClass.getProtectionDomain().getCodeSource().getLocation();
        if (fluidsLoc.equals(coreLoc = coreClass.getProtectionDomain().getCodeSource().getLocation())) {
            throw new Error("(core and fluids have the same path " + fluidsLoc + ")\n\nLoaded the LBA FatJar outside of a development environment!\nThis can cause stability issues when older or newer versions\nof the different submodules are present on the classpath, as\nfabric loader cannot load the seperate modules correctly. (Which\nthen causes NoSuchMethodError's, or other strange behaviour)");
        }
    }

    static void ensureClassLoaded() {
    }

    static {
        LbaFluidModCompatLoader.load();
        FluidAttributes.validateEnvironment();
    }

    static final class BucketItemGroupedFluidInv
    extends FluidItemBase
    implements GroupedFluidInv {
        BucketItemGroupedFluidInv(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excessStacks) {
            super(stackRef, excessStacks);
        }

        @Override
        public Set<FluidKey> getStoredFluids() {
            class_1799 stack = (class_1799)this.stackRef.get();
            if (!BucketItemGroupedFluidInv.isIBucket(stack)) {
                return Collections.emptySet();
            }
            IBucketItem bucket = (IBucketItem)stack.method_7909();
            FluidKey fluid = bucket.libblockattributes__getFluid(stack);
            if (fluid == FluidKeys.EMPTY) {
                return Collections.emptySet();
            }
            return Collections.singleton(fluid);
        }

        @Override
        public FluidAmount getTotalCapacity_F() {
            class_1799 stack = (class_1799)this.stackRef.get();
            if (!BucketItemGroupedFluidInv.isIBucket(stack)) {
                return FluidAmount.ZERO;
            }
            IBucketItem bucket = (IBucketItem)stack.method_7909();
            FluidAmount perBucket = bucket.libblockattributes__getFluidVolumeAmount();
            return perBucket.checkedMul(stack.method_7947());
        }

        @Override
        public GroupedFluidInvView.FluidInvStatistic getStatistics(FluidFilter filter) {
            class_1799 stack = (class_1799)this.stackRef.get();
            return this.getIBucketStatistics(stack, filter);
        }

        @Override
        public ListenerToken addListener_F(FluidInvAmountChangeListener_F listener, ListenerRemovalToken removalToken) {
            return null;
        }

        @Override
        public FluidVolume attemptInsertion(FluidVolume fluid, Simulation simulation) {
            class_1799 stack = (class_1799)this.stackRef.get();
            return this.attemptIBucketInsertion(stack, fluid, simulation);
        }

        @Override
        public FluidVolume attemptExtraction(FluidFilter filter, FluidAmount maxAmount, Simulation simulation) {
            class_1799 stack = (class_1799)this.stackRef.get();
            if (!BucketItemGroupedFluidInv.isIBucket(stack)) {
                return FluidVolumeUtil.EMPTY;
            }
            IBucketItem bucket = (IBucketItem)stack.method_7909();
            FluidAmount perBucket = bucket.libblockattributes__getFluidVolumeAmount();
            if (maxAmount.isLessThan(perBucket)) {
                return FluidVolumeUtil.EMPTY;
            }
            FluidKey current = bucket.libblockattributes__getFluid(stack);
            if (current.isEmpty() || !filter.matches(current)) {
                return FluidVolumeUtil.EMPTY;
            }
            class_1799 newStack = bucket.libblockattributes__drainedOfFluid(stack);
            stack = stack.method_7972();
            stack.method_7934(1);
            if (this.setStacks(simulation, stack, newStack)) {
                return current.withAmount(perBucket);
            }
            return FluidVolumeUtil.EMPTY;
        }
    }
}

