/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.AttributeUtil;
import alexiil.mc.lib.attributes.CacheInfo;
import alexiil.mc.lib.attributes.Convertible;
import alexiil.mc.lib.attributes.ListenerRemovalToken;
import alexiil.mc.lib.attributes.ListenerToken;
import alexiil.mc.lib.attributes.fluid.FluidInvTankChangeListener;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInvView;
import alexiil.mc.lib.attributes.fluid.SingleFluidTankView;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.EmptyFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.impl.GroupedFluidInvViewFixedWrapper;
import alexiil.mc.lib.attributes.fluid.impl.MappedFixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.impl.SubFixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.class_265;

public interface FixedFluidInvView
extends Convertible {
    public int getTankCount();

    public FluidVolume getInvFluid(int var1);

    @Deprecated(since="0.6.0", forRemoval=true)
    default public int getMaxAmount(int tank) {
        if (AttributeUtil.EXPENSIVE_DEBUG_CHECKS) {
            FixedFluidInvView.validateFixedFluidInvView(this);
        }
        return this.getMaxAmount_F(tank).as1620();
    }

    default public FluidAmount getMaxAmount_F(int tank) {
        if (AttributeUtil.EXPENSIVE_DEBUG_CHECKS) {
            FixedFluidInvView.validateFixedFluidInvView(this);
        }
        return FluidAmount.of1620(this.getMaxAmount(tank));
    }

    public boolean isFluidValidForTank(int var1, FluidKey var2);

    default public FluidFilter getFilterForTank(int tank) {
        return stack -> this.isFluidValidForTank(tank, stack);
    }

    default public SingleFluidTankView getTank(int tank) {
        return new SingleFluidTankView(this, tank);
    }

    default public Iterable<? extends SingleFluidTankView> tankIterable() {
        return () -> new Iterator<SingleFluidTankView>(){
            int index = 0;

            @Override
            public SingleFluidTankView next() {
                return FixedFluidInvView.this.getTank(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < FixedFluidInvView.this.getTankCount();
            }
        };
    }

    default public Iterable<FluidVolume> fluidIterable() {
        return () -> new Iterator<FluidVolume>(){
            int index = 0;

            @Override
            public FluidVolume next() {
                return FixedFluidInvView.this.getInvFluid(this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index < FixedFluidInvView.this.getTankCount();
            }
        };
    }

    default public GroupedFluidInvView getGroupedInv() {
        return new GroupedFluidInvViewFixedWrapper(this);
    }

    default public ListenerToken addListener(FluidInvTankChangeListener listener, ListenerRemovalToken removalToken) {
        return null;
    }

    default public FixedFluidInvView getSubInv(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return EmptyFixedFluidInv.INSTANCE;
        }
        if (fromIndex == 0 && toIndex == this.getTankCount()) {
            return this;
        }
        return new SubFixedFluidInvView(this, fromIndex, toIndex);
    }

    default public FixedFluidInvView getMappedInv(int ... tanks) {
        if (tanks.length == 0) {
            return EmptyFixedFluidInv.INSTANCE;
        }
        if (tanks.length == this.getTankCount()) {
            boolean isThis = true;
            for (int i = 0; i < tanks.length; ++i) {
                if (tanks[i] == i) continue;
                isThis = false;
                break;
            }
            if (isThis) {
                return this;
            }
        }
        return new MappedFixedFluidInvView(this, tanks);
    }

    @Deprecated(since="0.4.9", forRemoval=true)
    default public void offerSelfAsAttribute(AttributeList<?> list, @Nullable CacheInfo cacheInfo, @Nullable class_265 shape) {
        list.offer((Object)this, cacheInfo, shape);
    }

    default public <T> T convertTo(Class<T> otherType) {
        return (T)Convertible.offer(otherType, (Object)this.getGroupedInv());
    }

    public static void validateFixedFluidInvView(FixedFluidInvView instance) {
        Class<?> c = instance.getClass();
        try {
            Method m0 = c.getDeclaredMethod("getMaxAmount", Integer.TYPE);
            Method m1 = c.getDeclaredMethod("getMaxAmount_F", Integer.TYPE);
            if (m0.getDeclaringClass() == FixedFluidInvView.class && m1.getDeclaringClass() == FixedFluidInvView.class) {
                throw new Error("The " + c + " needs to override either getMaxAmount() or getMaxAmount_F()!");
            }
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    default public FixedFluidInvView getFixedView() {
        final FixedFluidInvView real = this;
        return new FixedFluidInvView(){

            @Override
            public int getTankCount() {
                return real.getTankCount();
            }

            @Override
            public FluidVolume getInvFluid(int tank) {
                return real.getInvFluid(tank);
            }

            @Override
            public boolean isFluidValidForTank(int tank, FluidKey fluid) {
                return real.isFluidValidForTank(tank, fluid);
            }

            @Override
            @Deprecated
            public int getMaxAmount(int tank) {
                return real.getMaxAmount(tank);
            }

            @Override
            public FluidAmount getMaxAmount_F(int tank) {
                return real.getMaxAmount_F(tank);
            }

            @Override
            public FluidFilter getFilterForTank(int tank) {
                return real.getFilterForTank(tank);
            }

            @Override
            public GroupedFluidInvView getGroupedInv() {
                return new GroupedFluidInvViewFixedWrapper(this);
            }

            @Override
            public ListenerToken addListener(FluidInvTankChangeListener listener, ListenerRemovalToken removalToken) {
                3 view = this;
                return real.addListener((inv, tank, prev, curr) -> listener.onChange(view, tank, prev, curr), removalToken);
            }
        };
    }
}

