/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.fluid;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.fluid.FixedFluidInvView;
import alexiil.mc.lib.attributes.fluid.FluidExtractable;
import alexiil.mc.lib.attributes.fluid.FluidInsertable;
import alexiil.mc.lib.attributes.fluid.FluidTransferable;
import alexiil.mc.lib.attributes.fluid.FluidVolumeUtil;
import alexiil.mc.lib.attributes.fluid.GroupedFluidInv;
import alexiil.mc.lib.attributes.fluid.LimitedFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.SingleFluidTank;
import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.filter.FluidFilter;
import alexiil.mc.lib.attributes.fluid.impl.EmptyFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.impl.GroupedFluidInvFixedWrapper;
import alexiil.mc.lib.attributes.fluid.impl.MappedFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.impl.SimpleLimitedFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.impl.SubFixedFluidInv;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface FixedFluidInv
extends FixedFluidInvView {
    @Override
    public boolean isFluidValidForTank(int var1, FluidKey var2);

    public boolean setInvFluid(int var1, FluidVolume var2, Simulation var3);

    default public void forceSetInvFluid(int slot, FluidVolume to) {
        if (!this.setInvFluid(slot, to, Simulation.ACTION)) {
            throw new IllegalStateException("Unable to force-set the tank " + slot + " to " + to + "!");
        }
    }

    default public void modifyTank(int tank, Function<FluidVolume, FluidVolume> function) {
        this.forceSetInvFluid(tank, function.apply(this.getInvFluid(tank)));
    }

    default public FluidVolume insertFluid(int tank, FluidVolume volume, Simulation simulation) {
        FluidVolumeUtil.FluidTransferResult result = FluidVolumeUtil.computeInsertion(this.getInvFluid(tank), this.getMaxAmount_F(tank), volume);
        if (result.result == volume) {
            return volume;
        }
        if (this.setInvFluid(tank, result.inTank, simulation)) {
            return result.result;
        }
        return volume;
    }

    default public FluidVolume extractFluid(int tank, @Nullable FluidFilter filter, FluidVolume mergeWith, FluidAmount maxAmount, Simulation simulation) {
        if (mergeWith == null) {
            mergeWith = FluidVolumeUtil.EMPTY;
        }
        FluidVolume inTank = this.getInvFluid(tank);
        FluidVolumeUtil.FluidTransferResult result = FluidVolumeUtil.computeExtraction(inTank, filter, mergeWith, maxAmount);
        if (this.setInvFluid(tank, result.inTank, simulation)) {
            return result.result;
        }
        return mergeWith;
    }

    @Override
    default public SingleFluidTank getTank(int tank) {
        return new SingleFluidTank(this, tank);
    }

    default public Iterable<? extends SingleFluidTank> tankIterable() {
        return () -> new Iterator<SingleFluidTank>(){
            int index = 0;

            @Override
            public SingleFluidTank next() {
                return FixedFluidInv.this.getTank(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < FixedFluidInv.this.getTankCount();
            }
        };
    }

    default public LimitedFixedFluidInv createLimitedFixedInv() {
        return new SimpleLimitedFixedFluidInv(this);
    }

    default public FluidInsertable getInsertable() {
        return this.getGroupedInv();
    }

    default public FluidExtractable getExtractable() {
        return this.getGroupedInv();
    }

    default public FluidTransferable getTransferable() {
        return this.getGroupedInv();
    }

    @Override
    default public GroupedFluidInv getGroupedInv() {
        return new GroupedFluidInvFixedWrapper(this);
    }

    @Override
    default public FixedFluidInv getSubInv(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return EmptyFixedFluidInv.INSTANCE;
        }
        if (fromIndex == 0 && toIndex == this.getTankCount()) {
            return this;
        }
        return new SubFixedFluidInv(this, fromIndex, toIndex);
    }

    @Override
    default public FixedFluidInv getMappedInv(int ... tanks) {
        if (tanks.length == 0) {
            return EmptyFixedFluidInv.INSTANCE;
        }
        if (tanks.length == this.getTankCount()) {
            boolean isThis = true;
            for (int i = 0; i < tanks.length; ++i) {
                if (tanks[i] == i) continue;
                isThis = false;
                break;
            }
            if (isThis) {
                return this;
            }
        }
        return new MappedFixedFluidInv(this, tanks);
    }
}

