/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.misc;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.misc.CallableRef;
import alexiil.mc.lib.attributes.misc.DestroyableRef;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.SimulatableRef;
import alexiil.mc.lib.attributes.misc.UnmodifiableRef;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Reference<T> {
    public T get();

    public boolean set(T var1);

    public boolean isValid(T var1);

    default public boolean set(T value, Simulation simulation) {
        if (simulation == Simulation.ACTION) {
            return this.set(value);
        }
        return this.isValid(value);
    }

    default public DestroyableRef<T> asDestroyable() {
        return new DestroyableRef(this);
    }

    public static <T> UnmodifiableRef<T> unmodifiable(T obj) {
        return new UnmodifiableRef<T>(obj);
    }

    public static <T> CallableRef<T> callable(Supplier<T> getter, Consumer<T> setter, Predicate<T> filter) {
        return new CallableRef<T>(getter, setter, filter);
    }

    public static <T> SimulatableRef<T> simulating(Supplier<T> getter, LimitedConsumer<T> setter) {
        return new SimulatableRef<T>(getter, setter);
    }

    public static <T> DestroyableRef<T> destroying(Reference<T> ref) {
        return new DestroyableRef<T>(ref);
    }
}

