/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes.misc;

import alexiil.mc.lib.attributes.misc.Reference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class CallableRef<T>
implements Reference<T> {
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private final Predicate<T> canSet;

    public CallableRef(Supplier<T> getter, Consumer<T> setter, Predicate<T> canSet) {
        this.getter = getter;
        this.setter = setter;
        this.canSet = canSet;
    }

    @Override
    public T get() {
        return this.getter.get();
    }

    @Override
    public boolean set(T value) {
        if (this.canSet.test(value)) {
            this.setter.accept(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid(T value) {
        return this.canSet.test(value);
    }
}

