/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes;

import alexiil.mc.lib.attributes.AbstractAttributeList;
import alexiil.mc.lib.attributes.Attribute;
import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.CombinableAttribute;
import alexiil.mc.lib.attributes.Convertible;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class ItemAttributeList<T>
extends AbstractAttributeList<T> {
    private final Predicate<T> searchMatcher;
    private int offeredCount;

    public ItemAttributeList(Attribute<T> attribute) {
        super(attribute);
        this.searchMatcher = null;
    }

    public ItemAttributeList(Attribute<T> attribute, Predicate<T> searchMatcher) {
        super(attribute);
        this.searchMatcher = searchMatcher;
    }

    public void add(T object) {
        this.assertAdding();
        ++this.offeredCount;
        if (this.searchMatcher != null && !this.searchMatcher.test(object)) {
            return;
        }
        this.list.add(object);
    }

    public void offer(Object object) {
        this.assertAdding();
        Object converted = Convertible.getAs(object, this.attribute.clazz);
        if (converted != null) {
            this.add(converted);
        }
    }

    public boolean hasOfferedAny() {
        return this.offeredCount > 0;
    }

    public int getOfferedCount() {
        return this.offeredCount;
    }

    @Nonnull
    public T combine(AttributeList<T> after, CombinableAttribute<T> combinable) {
        this.assertUsing();
        return combinable.combine((List<T>)this.list, (List<T>)after.list);
    }
}

