/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes;

import alexiil.mc.lib.attributes.AttributeSourceType;
import alexiil.mc.lib.attributes.misc.LibBlockAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class CompatLeveledMap<Instance, Cls, V> {
    public static final int NULL_PRIORITY = 65536;
    private static final boolean RECORD_ADDITIONS = Boolean.getBoolean("libblockattributes.debug.record_attribute_additions");
    private static final Map<Class<?>, List<Class<?>>> CLASS_TO_SUPERS = new HashMap();
    private final String name;
    private final Class<Cls> usedClass;
    private final ValueEntry<V> nullEntry;
    private final Function<Instance, String> toStringFunc;
    public int baseOffset = 0;
    public int priorityMultiplier = 1;
    private PriorityEntry instanceValues = null;
    private PriorityEntry compatValues = null;
    private Map<Instance, ValueEntry<V>> resolved = null;
    private Map<Class<?>, ValueEntry<V>> classResolved = null;
    private boolean resolvedByClass = false;

    public CompatLeveledMap(String name, Class<Cls> usedClass, V nullValue, Function<Instance, String> toStringFunc) {
        this.name = name;
        this.usedClass = usedClass;
        this.nullEntry = new ValueEntry<V>(nullValue, 65536);
        this.toStringFunc = toStringFunc;
    }

    @Nullable
    public V get(Instance key, Class<? extends Cls> clazz) {
        ValueEntry<V> value = this.getEntry(key, clazz);
        return value != this.nullEntry ? (V)value.value : null;
    }

    public ValueEntry<V> getEntry(Instance key, Class<? extends Cls> clazz) {
        ValueEntry<V> value = null;
        if (this.resolved != null && (value = this.resolved.get(key)) != null && value.priority == 0) {
            return value;
        }
        if (this.classResolved != null) {
            ValueEntry<V> instance = value;
            value = this.classResolved.get(clazz);
            if (value == null) {
                if (instance != null) {
                    return instance;
                }
            } else {
                if (instance == null) {
                    return value;
                }
                return value.priority < instance.priority ? value : instance;
            }
        }
        if (this.instanceValues != null && (value = this.instanceValues.get(key, clazz)) != null) {
            return this.resolvedByClass ? this.resolveClassTo(clazz, value) : this.resolveTo(key, value);
        }
        if (this.compatValues != null && (value = this.compatValues.get(key, clazz)) != null) {
            return this.resolvedByClass ? this.resolveClassTo(clazz, value) : this.resolveTo(key, value);
        }
        this.resolveTo(key, this.nullEntry);
        return this.nullEntry;
    }

    private ValueEntry<V> resolveTo(Instance key, ValueEntry<V> entry) {
        if (this.resolved == null) {
            this.resolved = new HashMap<Instance, ValueEntry<V>>();
        }
        this.resolved.put(key, entry);
        return entry;
    }

    private ValueEntry<V> resolveClassTo(Class<? extends Cls> key, ValueEntry<V> entry) {
        if (this.classResolved == null) {
            this.classResolved = new HashMap();
        }
        this.classResolved.put(key, entry);
        return entry;
    }

    private static Iterable<Class<?>> classesToConsider(Class<?> clazz) {
        List<Class<?>> list = CLASS_TO_SUPERS.get(clazz);
        if (list != null) {
            return list;
        }
        LinkedHashSet classes = new LinkedHashSet();
        Class<?> s = clazz;
        do {
            classes.add(s);
            Collections.addAll(classes, s.getInterfaces());
            for (Class<?> cls : s.getInterfaces()) {
                for (Class<?> c2 : CompatLeveledMap.classesToConsider(cls)) {
                    classes.add(c2);
                }
            }
        } while ((s = s.getSuperclass()) != null);
        list = new ArrayList(classes);
        CLASS_TO_SUPERS.put(clazz, list);
        return list;
    }

    public void putExact(AttributeSourceType type, Instance key, V value) {
        Object old;
        if (this.resolved != null) {
            this.resolved.remove(key);
        }
        PriorityEntry entry = this.getOrCreateEntry(type);
        if (entry.exactMappings == null) {
            entry.exactMappings = new HashMap();
            if (RECORD_ADDITIONS) {
                entry.exactMappingsTrace = new HashMap();
            }
        }
        if ((old = entry.exactMappings.put(key, value)) != null) {
            LibBlockAttributes.LOGGER.warn("Replaced the " + this.name + " value for " + this.toStringFunc.apply(key) + " with " + value + " (was " + old + ")");
            if (RECORD_ADDITIONS) {
                LibBlockAttributes.LOGGER.warn(" - Original added: ", entry.exactMappingsTrace.get(key));
                LibBlockAttributes.LOGGER.warn(" - Replacement: ", new Throwable());
            } else {
                LibBlockAttributes.LOGGER.info("Try adding '-Dlibblockattributes.debug.record_attribute_additions=true' to your vm arguments to debug the cause of this");
            }
        }
        if (RECORD_ADDITIONS) {
            entry.exactMappingsTrace.put(key, new Throwable());
        }
    }

    public void addPredicateBased(AttributeSourceType type, boolean specific, Predicate<? super Instance> predicate, V value) {
        if (specific) {
            this.addSpecificPredicateBased(type, predicate, value);
        } else {
            this.addGeneralPredicateBased(type, predicate, value);
        }
    }

    private void addSpecificPredicateBased(AttributeSourceType type, Predicate<? super Instance> predicate, V value) {
        this.clearResolved();
        PriorityEntry entry = this.getOrCreateEntry(type);
        if (entry.specificPredicates == null) {
            entry.specificPredicates = new ArrayList();
        }
        entry.specificPredicates.add(new PredicateEntry<Instance, V>(predicate, value));
    }

    public void putClassBased(AttributeSourceType type, Class<?> clazz, boolean matchSubclasses, V value) {
        Map<Class<?>, Throwable> mapTrace;
        Map<Class<?>, V> map;
        if (!matchSubclasses) {
            if (clazz.isInterface()) {
                throw new IllegalArgumentException("The given " + clazz + " is an interface, and matchSubclasses is set to false - which will never match anything, as it's impossible to construct an interface.");
            }
            if ((clazz.getModifiers() & 0x400) != 0) {
                throw new IllegalArgumentException("The given " + clazz + " is abstract, and matchSubclasses is set to false - which will never match anything, as it's impossible to construct an abstract class.");
            }
        }
        if (clazz.isAssignableFrom(this.usedClass)) {
            throw new IllegalArgumentException("The given " + clazz + " is a superclass/superinterface of the base " + this.usedClass + " - which won't work very well, because it will override everything else.");
        }
        this.clearResolved();
        PriorityEntry entry = this.getOrCreateEntry(type);
        if (matchSubclasses) {
            if (entry.inheritClassMappings == null) {
                entry.inheritClassMappings = new HashMap();
                if (RECORD_ADDITIONS) {
                    entry.inheritClassMappingsTrace = new HashMap();
                }
            }
            map = entry.inheritClassMappings;
            mapTrace = entry.inheritClassMappingsTrace;
        } else {
            if (entry.exactClassMappings == null) {
                entry.exactClassMappings = new HashMap();
                if (RECORD_ADDITIONS) {
                    entry.exactClassMappingsTrace = new HashMap();
                }
            }
            map = entry.exactClassMappings;
            mapTrace = entry.exactClassMappingsTrace;
        }
        Object old = map.put(clazz, value);
        if (old != null) {
            LibBlockAttributes.LOGGER.warn("Replaced the " + this.name + " value for " + clazz + " with " + value + " (was " + old + ")");
            if (RECORD_ADDITIONS) {
                LibBlockAttributes.LOGGER.warn(" - Original added: ", mapTrace.get(clazz));
                LibBlockAttributes.LOGGER.warn(" - Replacement: ", new Throwable());
            } else {
                LibBlockAttributes.LOGGER.info("Try adding '-Dlibblockattributes.debug.record_attribute_additions=true' to your vm arguments to debug the cause of this");
            }
        }
        if (RECORD_ADDITIONS) {
            mapTrace.put(clazz, new Throwable());
        }
    }

    private void addGeneralPredicateBased(AttributeSourceType type, Predicate<? super Instance> predicate, V value) {
        this.clearResolved();
        PriorityEntry entry = this.getOrCreateEntry(type);
        if (entry.generalPredicates == null) {
            entry.generalPredicates = new ArrayList();
        }
        entry.generalPredicates.add(new PredicateEntry<Instance, V>(predicate, value));
    }

    private PriorityEntry getOrCreateEntry(AttributeSourceType type) {
        switch (type) {
            case INSTANCE: {
                if (this.instanceValues == null) {
                    this.instanceValues = new PriorityEntry(8 * (this.baseOffset + this.priorityMultiplier * type.ordinal()));
                }
                return this.instanceValues;
            }
            case COMPAT_WRAPPER: {
                if (this.compatValues == null) {
                    this.compatValues = new PriorityEntry(8 * (this.baseOffset + this.priorityMultiplier * type.ordinal()));
                }
                return this.compatValues;
            }
        }
        throw new IllegalArgumentException("Unknown AttributeSourceType" + type + "!");
    }

    private void clearResolved() {
        this.resolved = null;
        this.classResolved = null;
    }

    final class PriorityEntry {
        private final int basePriority;
        private Map<Instance, V> exactMappings = null;
        private List<PredicateEntry<Instance, V>> specificPredicates = null;
        private Map<Class<?>, V> exactClassMappings = null;
        private Map<Class<?>, V> inheritClassMappings = null;
        private List<PredicateEntry<Instance, V>> generalPredicates = null;
        private Map<Instance, Throwable> exactMappingsTrace = null;
        private Map<Class<?>, Throwable> exactClassMappingsTrace = null;
        private Map<Class<?>, Throwable> inheritClassMappingsTrace = null;

        PriorityEntry(int basePriority) {
            this.basePriority = basePriority;
        }

        @Nullable
        ValueEntry<V> get(Instance key, Class<? extends Cls> clazz) {
            Object value;
            CompatLeveledMap.this.resolvedByClass = false;
            if (this.exactMappings != null && (value = this.exactMappings.get(key)) != null) {
                return new ValueEntry(value, this.basePriority);
            }
            if (this.specificPredicates != null) {
                for (PredicateEntry predicateEntry : this.specificPredicates) {
                    if (!predicateEntry.predicate.test(key)) continue;
                    return new ValueEntry(predicateEntry.value, this.basePriority + 1);
                }
            }
            if (this.exactClassMappings != null && (value = this.exactClassMappings.get(clazz)) != null) {
                CompatLeveledMap.this.resolvedByClass = true;
                return new ValueEntry(value, this.basePriority + 2);
            }
            if (this.inheritClassMappings != null) {
                for (Class clazz2 : CompatLeveledMap.classesToConsider(clazz)) {
                    value = this.inheritClassMappings.get(clazz2);
                    if (value == null) continue;
                    CompatLeveledMap.this.resolvedByClass = true;
                    return new ValueEntry(value, this.basePriority + 3);
                }
            }
            if (this.generalPredicates != null) {
                for (PredicateEntry predicateEntry : this.generalPredicates) {
                    if (!predicateEntry.predicate.test(key)) continue;
                    return new ValueEntry(predicateEntry.value, this.basePriority + 4);
                }
            }
            return null;
        }
    }

    public static final class ValueEntry<V> {
        public final V value;
        public final int priority;

        ValueEntry(V value, int priority) {
            this.value = value;
            this.priority = priority;
        }
    }

    static final class PredicateEntry<K, V> {
        final Predicate<? super K> predicate;
        final V value;

        PredicateEntry(Predicate<? super K> predicate, V value) {
            this.predicate = predicate;
            this.value = value;
        }
    }
}

