/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes;

import alexiil.mc.lib.attributes.AttributeCombiner;
import alexiil.mc.lib.attributes.CustomAttributeAdder;
import alexiil.mc.lib.attributes.DefaultedAttribute;
import alexiil.mc.lib.attributes.ItemAttributeAdder;
import alexiil.mc.lib.attributes.SearchOption;
import alexiil.mc.lib.attributes.SearchOptions;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class CombinableAttribute<T>
extends DefaultedAttribute<T> {
    private final AttributeCombiner<T> combiner;

    protected CombinableAttribute(Class<T> clazz, @Nonnull T defaultValue, AttributeCombiner<T> combiner) {
        super(clazz, defaultValue);
        this.combiner = combiner;
    }

    @Override
    public CombinableAttribute<T> appendBlockAdder(CustomAttributeAdder<T> blockAdder) {
        super.appendBlockAdder((CustomAttributeAdder)blockAdder);
        return this;
    }

    @Override
    public CombinableAttribute<T> appendItemAdder(ItemAttributeAdder<T> itemAdder) {
        super.appendItemAdder((ItemAttributeAdder)itemAdder);
        return this;
    }

    @Nonnull
    public final T combine(List<T> list) {
        switch (list.size()) {
            case 0: {
                return (T)this.defaultValue;
            }
            case 1: {
                return this.asNonNull(list.get(0));
            }
        }
        return this.combiner.combine(list);
    }

    @Nonnull
    public final T combine(List<T> firstList, List<T> secondList) {
        switch (firstList.size() + secondList.size()) {
            case 0: {
                return (T)this.defaultValue;
            }
            case 1: {
                if (secondList.isEmpty()) {
                    return this.asNonNull(firstList.get(0));
                }
                return this.asNonNull(firstList.get(0));
            }
        }
        if (firstList.isEmpty()) {
            return this.combiner.combine(secondList);
        }
        if (secondList.isEmpty()) {
            return this.combiner.combine(firstList);
        }
        ArrayList<T> combined = new ArrayList<T>();
        combined.add(this.asNonNull(firstList.get(0)));
        combined.addAll(secondList);
        return this.combiner.combine(combined);
    }

    @Nonnull
    private final T asNonNull(@Nullable T value) {
        if (value == null) {
            throw new NullPointerException("The value was null, when all elements are meant to be non-null!");
        }
        return value;
    }

    @Nonnull
    public final T get(class_1937 world, class_2338 pos) {
        return this.get(world, pos, null);
    }

    @Nonnull
    public final T get(class_1937 world, class_2338 pos, SearchOption<? super T> searchParam) {
        return this.getAll(world, pos, searchParam).combine(this);
    }

    @Nonnull
    public final T getFromNeighbour(class_2586 be, class_2350 dir) {
        return (T)this.get(be.method_10997(), be.method_11016().method_10093(dir), SearchOptions.inDirection(dir));
    }

    @Nonnull
    public final T get(class_1799 unmodifiableStack) {
        return this.getAll(unmodifiableStack).combine(this);
    }

    @Nonnull
    public final T get(Reference<class_1799> stackRef) {
        return this.getAll(stackRef).combine(this);
    }

    @Nonnull
    public final T get(Reference<class_1799> stackRef, @Nullable Predicate<T> filter) {
        return this.getAll(stackRef, filter).combine(this);
    }

    @Nonnull
    public final T get(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excess) {
        return this.getAll(stackRef, excess).combine(this);
    }

    @Nonnull
    public final T get(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excess, @Nullable Predicate<T> filter) {
        return this.getAll(stackRef, excess, filter).combine(this);
    }
}

