/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes;

import alexiil.mc.lib.attributes.AbstractAttributeList;
import alexiil.mc.lib.attributes.Attribute;
import alexiil.mc.lib.attributes.CacheInfo;
import alexiil.mc.lib.attributes.CombinableAttribute;
import alexiil.mc.lib.attributes.Convertible;
import alexiil.mc.lib.attributes.SearchOption;
import alexiil.mc.lib.attributes.SearchOptionDirectional;
import alexiil.mc.lib.attributes.SearchOptions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;

public class AttributeList<T>
extends AbstractAttributeList<T> {
    public final SearchOption<? super T> searchParam;
    @Nonnull
    final class_265 defaultShape;
    final class_2371<CacheInfo> cacheList = class_2371.method_10211();
    final List<class_265> shapeList = new ArrayList<class_265>();
    final List<class_265> combinedShapeList;
    class_265 obstructingShape;
    private int offeredCount;

    AttributeList(Attribute<T> attribute, @Nullable SearchOption<? super T> searchOption, class_265 defaultShape) {
        super(attribute);
        if (defaultShape == null) {
            throw new NullPointerException("defaultShape");
        }
        if (searchOption == null) {
            searchOption = SearchOptions.ALL;
        }
        this.searchParam = searchOption;
        this.defaultShape = defaultShape;
        this.obstructingShape = this.getSearchDirection() != null ? class_259.method_1073() : null;
        this.combinedShapeList = this.searchParam.getShape() != class_259.method_1077() || this.obstructingShape != null ? new ArrayList<class_265>() : null;
    }

    @Nullable
    public class_2350 getSearchDirection() {
        if (this.searchParam instanceof SearchOptionDirectional) {
            return ((SearchOptionDirectional)this.searchParam).direction;
        }
        return null;
    }

    @Nullable
    public class_2350 getTargetSide() {
        class_2350 dir = this.getSearchDirection();
        return dir == null ? null : dir.method_10153();
    }

    public void add(T object) {
        this.add(object, null, null);
    }

    public void add(T object, @Nullable CacheInfo cacheInfo) {
        this.add(object, cacheInfo, null);
    }

    public void add(T object, @Nullable class_265 shape) {
        this.add(object, null, shape);
    }

    public void add(T object, @Nullable CacheInfo cacheInfo, @Nullable class_265 shape) {
        this.assertAdding();
        if (cacheInfo == null) {
            cacheInfo = CacheInfo.NOT_CACHABLE;
        }
        if (shape == null) {
            shape = this.defaultShape;
        }
        ++this.offeredCount;
        if (!this.searchParam.matches(object)) {
            return;
        }
        class_265 searchShape = this.searchParam.getShape();
        if (this.combinedShapeList != null) {
            class_265 combined = searchShape == class_259.method_1077() ? shape : class_259.method_1082((class_265)shape, (class_265)searchShape, (class_247)class_247.field_16896);
            if (combined.method_1110()) {
                return;
            }
            this.combinedShapeList.add(combined);
        }
        this.list.add(object);
        this.cacheList.add((Object)cacheInfo);
        this.shapeList.add(shape);
    }

    public void offer(Object object) {
        this.offer(object, null, null);
    }

    public void offer(Object object, @Nullable CacheInfo cacheInfo) {
        this.offer(object, cacheInfo, null);
    }

    public void offer(Object object, @Nullable class_265 shape) {
        this.offer(object, null, shape);
    }

    public void offer(Object object, @Nullable CacheInfo cacheInfo, @Nullable class_265 shape) {
        this.assertAdding();
        Object converted = Convertible.getAs(object, this.attribute.clazz);
        if (converted != null) {
            this.add(converted, cacheInfo, shape);
        }
    }

    public void obstruct(class_265 shape) {
        if (this.obstructingShape != null && !(shape = class_259.method_1082((class_265)shape, (class_265)this.searchParam.getShape(), (class_247)class_247.field_16896)).method_1110()) {
            this.obstructingShape = class_259.method_1084((class_265)this.obstructingShape, (class_265)AttributeList.extendShape(shape, this.getSearchDirection()));
        }
    }

    @Override
    void finishAdding() {
        super.finishAdding();
        if (this.obstructingShape != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                class_265 cShape = this.combinedShapeList.get(i);
                class_265 visible = class_259.method_1082((class_265)this.obstructingShape, (class_265)cShape, (class_247)class_247.field_16893);
                if (!visible.method_1110()) continue;
                this.list.remove(i);
                this.shapeList.remove(i);
                this.combinedShapeList.remove(i);
                --i;
            }
        }
    }

    private static class_265 extendShape(class_265 shape, class_2350 direction) {
        if (direction == null) {
            return shape;
        }
        class_265 combined = null;
        for (class_238 box : shape.method_1090()) {
            box = box.method_997(class_243.method_24954((class_2382)direction.method_10163()).method_1021(0.03125));
            double minX = box.field_1323;
            double minY = box.field_1322;
            double minZ = box.field_1321;
            double maxX = box.field_1320;
            double maxY = box.field_1325;
            double maxZ = box.field_1324;
            switch (direction) {
                case field_11033: {
                    minY = 0.0;
                    break;
                }
                case field_11036: {
                    maxY = 1.0;
                    break;
                }
                case field_11043: {
                    minZ = 0.0;
                    break;
                }
                case field_11035: {
                    maxZ = 1.0;
                    break;
                }
                case field_11039: {
                    minX = 0.0;
                    break;
                }
                case field_11034: {
                    maxX = 1.0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown Direction " + direction);
                }
            }
            class_265 thisBox = class_259.method_1081((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            if (combined == null) {
                combined = thisBox;
                continue;
            }
            combined = class_259.method_1084((class_265)combined, (class_265)thisBox);
        }
        return combined == null ? class_259.method_1073() : combined;
    }

    public CacheInfo getCacheInfo(int index) {
        this.assertUsing();
        return (CacheInfo)this.cacheList.get(index);
    }

    @Nullable
    public class_265 getVoxelShape(int index) {
        this.assertUsing();
        return this.shapeList.get(index);
    }

    public boolean doesSearchReachEnd() {
        this.assertUsing();
        class_2350 dir = this.getSearchDirection();
        if (dir == null) {
            throw new IllegalStateException("Didn't have a search shape!");
        }
        assert (this.obstructingShape != null);
        class_265 searchShape = this.searchParam.getShape();
        class_265 leftover = class_259.method_1082((class_265)searchShape, (class_265)this.obstructingShape, (class_247)class_247.field_16886);
        if (dir.method_10171() == class_2350.class_2352.field_11056) {
            return searchShape.method_1105(dir.method_10166()) == leftover.method_1105(dir.method_10166());
        }
        return searchShape.method_1091(dir.method_10166()) == leftover.method_1091(dir.method_10166());
    }

    public boolean hasOfferedAny() {
        return this.offeredCount > 0;
    }

    public int getOfferedCount() {
        return this.offeredCount;
    }

    @Nonnull
    public T combine(AttributeList<T> after, CombinableAttribute<T> combinable) {
        this.assertUsing();
        return combinable.combine((List<T>)this.list, (List<T>)after.list);
    }
}

