/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes;

import alexiil.mc.lib.attributes.AttributeList;
import alexiil.mc.lib.attributes.AttributeProvider;
import alexiil.mc.lib.attributes.AttributeProviderBlockEntity;
import alexiil.mc.lib.attributes.AttributeProviderItem;
import alexiil.mc.lib.attributes.AttributeSourceType;
import alexiil.mc.lib.attributes.BlockEntityAttributeAdder;
import alexiil.mc.lib.attributes.CompatLeveledMap;
import alexiil.mc.lib.attributes.CustomAttributeAdder;
import alexiil.mc.lib.attributes.ItemAttributeAdder;
import alexiil.mc.lib.attributes.ItemAttributeList;
import alexiil.mc.lib.attributes.NullAttributeAdder;
import alexiil.mc.lib.attributes.SearchOption;
import alexiil.mc.lib.attributes.SearchOptions;
import alexiil.mc.lib.attributes.misc.LibBlockAttributes;
import alexiil.mc.lib.attributes.misc.LimitedConsumer;
import alexiil.mc.lib.attributes.misc.Reference;
import alexiil.mc.lib.attributes.misc.UnmodifiableRef;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class Attribute<T> {
    public final Class<T> clazz;
    private final CompatLeveledMap<class_2248, class_2248, CustomAttributeAdder<T>> customBlockMap;
    private final CompatLeveledMap<class_1792, class_1792, ItemAttributeAdder<T>> customItemMap;
    private final CompatLeveledMap<class_2591<?>, class_2586, BlockEntityAttributeAdder<T, ?>> customBlockEntityMap;
    private final ArrayList<CustomAttributeAdder<T>> fallbackBlockAdders = new ArrayList();
    private final ArrayList<ItemAttributeAdder<T>> fallbackItemAdders = new ArrayList();

    protected Attribute(Class<T> clazz) {
        this.clazz = clazz;
        String name = "attribute " + clazz.getName();
        this.customBlockMap = new CompatLeveledMap(name, class_2248.class, NullAttributeAdder.get(), Attribute::getName);
        this.customItemMap = new CompatLeveledMap(name, class_1792.class, NullAttributeAdder.get(), Attribute::getName);
        this.customBlockEntityMap = new CompatLeveledMap(name, class_2586.class, NullAttributeAdder.get(), Attribute::getName);
        this.customBlockMap.baseOffset = 0;
        this.customBlockMap.priorityMultiplier = 2;
        this.customBlockEntityMap.baseOffset = 1;
        this.customBlockEntityMap.priorityMultiplier = 2;
    }

    @Deprecated(since="0.5.0", forRemoval=true)
    protected Attribute(Class<T> clazz, CustomAttributeAdder<T> customAdder) {
        this(clazz);
        this.appendBlockAdder(customAdder);
    }

    public final boolean isInstance(Object obj) {
        return this.clazz.isInstance(obj);
    }

    public final T cast(Object obj) {
        return this.clazz.cast(obj);
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final void setBlockAdder(AttributeSourceType sourceType, class_2248 block, CustomAttributeAdder<T> adder) {
        this.customBlockMap.putExact(sourceType, block, adder);
    }

    public final <BE extends class_2586> void setBlockEntityAdder(AttributeSourceType sourceType, class_2591<BE> type, BlockEntityAttributeAdder<T, BE> adder) {
        this.customBlockEntityMap.putExact(sourceType, type, adder);
    }

    public final <BE extends class_2586> void setBlockEntityAdder(AttributeSourceType sourceType, class_2591<BE> type, Class<BE> clazz, BlockEntityAttributeAdder.BlockEntityAttributeAdderFN<T, BE> adder) {
        BlockEntityAttributeAdder<T, BE> real = BlockEntityAttributeAdder.ofTyped(clazz, adder);
        this.customBlockEntityMap.putExact(sourceType, type, real);
    }

    public final void setBlockEntityAdderFN(AttributeSourceType sourceType, class_2591<?> type, BlockEntityAttributeAdder.BlockEntityAttributeAdderFN<T, class_2586> adder) {
        this.customBlockEntityMap.putExact(sourceType, type, BlockEntityAttributeAdder.ofBasic(adder));
    }

    public final void setItemAdder(AttributeSourceType sourceType, class_1792 item, ItemAttributeAdder<T> adder) {
        this.customItemMap.putExact(sourceType, item, adder);
    }

    public final void addBlockPredicateAdder(AttributeSourceType sourceType, boolean specific, Predicate<class_2248> filter, CustomAttributeAdder<T> adder) {
        this.customBlockMap.addPredicateBased(sourceType, specific, filter, adder);
    }

    public final void addBlockEntityPredicateAdder(AttributeSourceType sourceType, boolean specific, Predicate<class_2591<?>> filter, BlockEntityAttributeAdder.BlockEntityAttributeAdderFN<T, class_2586> adder) {
        this.customBlockEntityMap.addPredicateBased(sourceType, specific, filter, BlockEntityAttributeAdder.ofBasic(adder));
    }

    public final void addItemPredicateAdder(AttributeSourceType sourceType, boolean specific, Predicate<class_1792> filter, ItemAttributeAdder<T> adder) {
        this.customItemMap.addPredicateBased(sourceType, specific, filter, adder);
    }

    public final void putBlockClassAdder(AttributeSourceType sourceType, Class<?> clazz, boolean matchSubclasses, CustomAttributeAdder<T> adder) {
        this.customBlockMap.putClassBased(sourceType, clazz, matchSubclasses, adder);
    }

    public final <BE> void putBlockEntityClassAdder(AttributeSourceType sourceType, Class<BE> clazz, boolean matchSubclasses, BlockEntityAttributeAdder.BlockEntityAttributeAdderFN<T, BE> adder) {
        BlockEntityAttributeAdder<T, BE> real = BlockEntityAttributeAdder.ofTyped(clazz, adder);
        this.customBlockEntityMap.putClassBased(sourceType, clazz, matchSubclasses, real);
    }

    public final void putItemClassAdder(AttributeSourceType sourceType, Class<?> clazz, boolean matchSubclasses, ItemAttributeAdder<T> adder) {
        this.customItemMap.putClassBased(sourceType, clazz, matchSubclasses, adder);
    }

    @Deprecated(since="0.5.0", forRemoval=true)
    public final void appendCustomAdder(CustomAttributeAdder<T> customAdder) {
        this.appendBlockAdder(customAdder);
    }

    public Attribute<T> appendBlockAdder(CustomAttributeAdder<T> blockAdder) {
        this.fallbackBlockAdders.add(blockAdder);
        return this;
    }

    public Attribute<T> appendItemAdder(ItemAttributeAdder<T> itemAdder) {
        this.fallbackItemAdders.add(itemAdder);
        return this;
    }

    final void addAll(class_1937 world, class_2338 pos, AttributeList<T> list) {
        class_2586 be;
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof AttributeProvider) {
            ((AttributeProvider)block).addAllAttributes(world, pos, state, list);
            if (list.hasOfferedAny()) {
                return;
            }
        }
        class_2586 class_25862 = be = state.method_31709() ? world.method_8321(pos) : null;
        if (be instanceof AttributeProviderBlockEntity) {
            ((AttributeProviderBlockEntity)be).addAllAttributes(list);
            if (list.hasOfferedAny()) {
                return;
            }
        }
        CompatLeveledMap.ValueEntry<CustomAttributeAdder<T>> customBlock = this.customBlockMap.getEntry(block, block.getClass());
        if (customBlock.priority < 8) {
            ((CustomAttributeAdder)customBlock.value).addAll(world, pos, state, list);
            return;
        }
        if (be == null) {
            if (customBlock.priority < 65536) {
                ((CustomAttributeAdder)customBlock.value).addAll(world, pos, state, list);
                return;
            }
        } else {
            CompatLeveledMap.ValueEntry<BlockEntityAttributeAdder<T, ?>> customEntity = this.customBlockEntityMap.getEntry(be.method_11017(), be.getClass());
            if (customEntity.priority < customBlock.priority) {
                this.addAll((BlockEntityAttributeAdder)customEntity.value, be, list);
                return;
            }
            if (customBlock.priority < 65536) {
                ((CustomAttributeAdder)customBlock.value).addAll(world, pos, state, list);
                return;
            }
        }
        for (CustomAttributeAdder<T> custom : this.fallbackBlockAdders) {
            custom.addAll(world, pos, state, list);
        }
    }

    private <BE> void addAll(BlockEntityAttributeAdder<T, BE> value, class_2586 be, AttributeList<T> to) {
        value.addAll(value.getBlockEntityClass().cast(be), to);
    }

    public final AttributeList<T> getAll(class_1937 world, class_2338 pos) {
        return this.getAll(world, pos, null);
    }

    public final AttributeList<T> getAll(class_1937 world, class_2338 pos, SearchOption<? super T> searchParam) {
        class_265 blockShape = world.method_8320(pos).method_26218((class_1922)world, pos);
        AttributeList<T> list = new AttributeList<T>(this, searchParam, blockShape);
        this.addAll(world, pos, list);
        list.finishAdding();
        return list;
    }

    public final AttributeList<T> getAllFromNeighbour(class_2586 be, class_2350 dir) {
        return this.getAll(be.method_10997(), be.method_11016().method_10093(dir), SearchOptions.inDirection(dir));
    }

    @Nullable
    public final T getFirstOrNull(class_1937 world, class_2338 pos) {
        return this.getFirstOrNull(world, pos, null);
    }

    @Nullable
    public final T getFirstOrNull(class_1937 world, class_2338 pos, @Nullable SearchOption<? super T> searchParam) {
        return this.getAll(world, pos, searchParam).getFirstOrNull();
    }

    @Nullable
    public final T getFirstOrNullFromNeighbour(class_2586 be, class_2350 dir) {
        return (T)this.getFirstOrNull(be.method_10997(), be.method_11016().method_10093(dir), SearchOptions.inDirection(dir));
    }

    final void addAll(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excess, ItemAttributeList<T> list) {
        ItemAttributeAdder<T> c;
        class_1799 stack = stackRef.get();
        class_1792 item = stack.method_7909();
        if (item instanceof AttributeProviderItem) {
            int offeredBefore = list.getOfferedCount();
            AttributeProviderItem attributeItem = (AttributeProviderItem)item;
            attributeItem.addAllAttributes(stackRef, excess, list);
            if (offeredBefore < list.getOfferedCount()) {
                return;
            }
        }
        if ((c = this.customItemMap.get(item, item.getClass())) != null) {
            c.addAll(stackRef, excess, list);
            return;
        }
        for (ItemAttributeAdder<T> custom : this.fallbackItemAdders) {
            custom.addAll(stackRef, excess, list);
        }
    }

    public final ItemAttributeList<T> getAll(class_1799 unmodifiableStack) {
        return this.getAll(new UnmodifiableRef<class_1799>(unmodifiableStack), null, null);
    }

    public final ItemAttributeList<T> getAll(Reference<class_1799> stackRef) {
        return this.getAll(stackRef, LimitedConsumer.rejecting(), null);
    }

    public final ItemAttributeList<T> getAll(Reference<class_1799> stackRef, @Nullable Predicate<T> filter) {
        return this.getAll(stackRef, LimitedConsumer.rejecting(), filter);
    }

    public final ItemAttributeList<T> getAll(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excess) {
        return this.getAll(stackRef, excess, null);
    }

    public final ItemAttributeList<T> getAll(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excess, @Nullable Predicate<T> filter) {
        if (excess == null) {
            excess = LimitedConsumer.rejecting();
        }
        ItemAttributeList<T> list = new ItemAttributeList<T>(this, filter);
        this.addAll(stackRef, excess, list);
        list.finishAdding();
        return list;
    }

    @Nullable
    public final T getFirstOrNull(class_1799 unmodifiableStack) {
        return this.getAll(unmodifiableStack).getFirstOrNull();
    }

    @Nullable
    public final T getFirstOrNull(Reference<class_1799> stackRef) {
        return this.getAll(stackRef).getFirstOrNull();
    }

    @Nullable
    public final T getFirstOrNull(Reference<class_1799> stackRef, @Nullable Predicate<T> filter) {
        return this.getAll(stackRef, filter).getFirstOrNull();
    }

    @Nullable
    public final T getFirstOrNull(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excess) {
        return this.getAll(stackRef, excess).getFirstOrNull();
    }

    @Nullable
    public final T getFirstOrNull(Reference<class_1799> stackRef, LimitedConsumer<class_1799> excess, @Nullable Predicate<T> filter) {
        return this.getAll(stackRef, excess, filter).getFirstOrNull();
    }

    private static String getName(class_2248 block) {
        class_2960 id = class_2378.field_11146.method_10221((Object)block);
        if (!class_2378.field_11146.method_10137().equals((Object)id)) {
            return id.toString();
        }
        return "UnknownBlock{" + block.getClass() + " @" + Integer.toHexString(System.identityHashCode(block)) + "}";
    }

    private static String getName(class_2591<?> type) {
        class_2960 id = class_2378.field_11137.method_10221(type);
        if (id != null) {
            return id.toString();
        }
        return "UnknownBlockEntity{" + type.getClass() + " @" + Integer.toHexString(System.identityHashCode(type)) + "}";
    }

    private static String getName(class_1792 item) {
        class_2960 id = class_2378.field_11142.method_10221((Object)item);
        if (!class_2378.field_11142.method_10137().equals((Object)id)) {
            return id.toString();
        }
        return "UnknownItem{" + item.getClass() + " @" + Integer.toHexString(System.identityHashCode(item)) + "}";
    }

    private static void validateEnvironment() throws Error {
        FabricLoader loader = FabricLoader.getInstance();
        if (loader.getAllMods().isEmpty()) {
            return;
        }
        ModContainer allModule = LibBlockAttributes.LbaModule.ALL.getModContainer();
        ModContainer coreModule = LibBlockAttributes.LbaModule.CORE.getModContainer();
        if (coreModule == null) {
            if (allModule == null) {
                throw new Error("(No LBA modules present?)\n\nLoaded the LBA FatJar outside of a development environment!\nThis can cause stability issues when older or newer versions\nof the different submodules are present on the classpath, as\nfabric loader cannot load the seperate modules correctly. (Which\nthen causes NoSuchMethodError's, or other strange behaviour)");
            }
            if ("$version".equals(allModule.getMetadata().getVersion().getFriendlyString())) {
                return;
            }
            throw new Error("(Only 'all' present!)\n\nLoaded the LBA FatJar outside of a development environment!\nThis can cause stability issues when older or newer versions\nof the different submodules are present on the classpath, as\nfabric loader cannot load the seperate modules correctly. (Which\nthen causes NoSuchMethodError's, or other strange behaviour)");
        }
        if (loader.isDevelopmentEnvironment()) {
            return;
        }
    }

    static {
        Attribute.validateEnvironment();
    }
}

