/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.attributes;

import alexiil.mc.lib.attributes.Attribute;
import alexiil.mc.lib.attributes.CombinableAttribute;
import alexiil.mc.lib.attributes.DefaultedAttribute;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2371;

public abstract class AbstractAttributeList<T> {
    public final Attribute<T> attribute;
    protected final class_2371<T> list = class_2371.method_10211();
    private boolean hasFinishedAdding = false;

    public AbstractAttributeList(Attribute<T> attribute) {
        this.attribute = attribute;
    }

    public int getCount() {
        this.assertUsing();
        return this.list.size();
    }

    @Nonnull
    public T get(int index) {
        this.assertUsing();
        return (T)this.list.get(index);
    }

    @Nullable
    public T getFirstOrNull() {
        this.assertUsing();
        if (this.list.isEmpty()) {
            return null;
        }
        return (T)this.list.get(0);
    }

    @Nonnull
    public T getFirst(DefaultedAttribute<T> defaulted) {
        this.assertUsing();
        if (this.list.isEmpty()) {
            return defaulted.defaultValue;
        }
        return (T)this.list.get(0);
    }

    @Nonnull
    public T combine(CombinableAttribute<T> combinable) {
        this.assertUsing();
        return combinable.combine((List<T>)this.list);
    }

    void reset() {
        this.list.clear();
        this.hasFinishedAdding = false;
    }

    void finishAdding() {
        this.assertAdding();
        this.hasFinishedAdding = true;
    }

    protected void assertAdding() {
        assert (!this.hasFinishedAdding);
    }

    protected void assertUsing() {
        assert (this.hasFinishedAdding);
    }
}

