/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.megane.module.techreborn.provider;

import lol.bai.megane.module.techreborn.provider.AbstractInventoryProgressProvider;
import reborncore.api.blockentity.InventoryProvider;

public class HardCodedProgressProvider<T extends InventoryProvider>
extends AbstractInventoryProgressProvider<T> {
    private final int[] inputSlots;
    private final int[] outputSlots;
    private final ProgressScaledFunction<T> progressScaledFunction;
    private final int scale;
    private final boolean inverted;

    public static <T extends InventoryProvider> Builder<T> builder(ProgressScaledFunction<T> progressScaledFunction) {
        return new Builder<T>(progressScaledFunction);
    }

    private HardCodedProgressProvider(int[] inputSlots, int[] outputSlots, ProgressScaledFunction<T> progressScaledFunction, int scale, boolean inverted) {
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.progressScaledFunction = progressScaledFunction;
        this.scale = scale;
        this.inverted = inverted;
    }

    public int getPercentage() {
        int scaled = this.progressScaledFunction.apply((InventoryProvider)this.getObject(), this.scale);
        return this.inverted ? 100 - (scaled == 0 ? 100 : scaled) : scaled;
    }

    protected int[] getInputSlots() {
        return this.inputSlots;
    }

    protected int[] getOutputSlots() {
        return this.outputSlots;
    }

    public static class Builder<T extends InventoryProvider> {
        private final ProgressScaledFunction<T> progressScaledFunction;
        private int[] inputSlots = new int[0];
        private int[] outputSlots = new int[0];
        private int scale = 100;
        private boolean inverted = false;

        private Builder(ProgressScaledFunction<T> progressScaledFunction) {
            this.progressScaledFunction = progressScaledFunction;
        }

        public Builder<T> input(int ... inputSlots) {
            this.inputSlots = inputSlots;
            return this;
        }

        public Builder<T> output(int ... outputSlots) {
            this.outputSlots = outputSlots;
            return this;
        }

        public Builder<T> inverted() {
            this.inverted = true;
            return this;
        }

        public Builder<T> scale(int scale) {
            this.scale = scale;
            return this;
        }

        public HardCodedProgressProvider<T> build() {
            return new HardCodedProgressProvider<T>(this.inputSlots, this.outputSlots, this.progressScaledFunction, this.scale, this.inverted);
        }
    }

    public static interface ProgressScaledFunction<T> {
        public int apply(T var1, int var2);
    }
}

