/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.mixin.access.WeightedEntryWrapperAccess;
import potionstudios.byg.mixin.access.WeightedListAccess;

public class BYGUtil {
    public static final ThreadLocal<class_5455> CAPTURED_REGISTRY_ACCESS = ThreadLocal.withInitial(() -> null);

    public static void captureRegistryAccess(class_5455 registryAccess) {
        CAPTURED_REGISTRY_ACCESS.set(registryAccess);
    }

    public static <V> List<List<V>> convert2DArray(V[][] arrayToConvert) {
        ArrayList<List<V>> convertedArrays = new ArrayList<List<V>>();
        for (V[] vs : arrayToConvert) {
            convertedArrays.add(Arrays.asList(vs));
        }
        return convertedArrays;
    }

    public static <T> class_5321<T>[][] convert2DResourceKeyArrayTo2DList(List<List<class_5321<T>>> listToConvert) {
        ArrayList<class_5321[]> resultList = new ArrayList<class_5321[]>(listToConvert.size());
        for (List<class_5321<T>> vs : listToConvert) {
            resultList.add((class_5321[])vs.toArray(class_5321[]::new));
        }
        return (class_5321[][])resultList.toArray(x$0 -> new class_5321[x$0][]);
    }

    public static <T> String dumpRegistry(class_2378<T> registry) {
        StringBuilder registryElements = new StringBuilder();
        for (int i = 0; i < registry.method_29722().size(); ++i) {
            Object object = registry.method_10200(i);
            registryElements.append(i).append(". \"").append(registry.method_10221(object).toString()).append("\"\n");
        }
        return registryElements.toString();
    }

    public static boolean createMarkerFile(Path path, String markerText) {
        if (path.toFile().exists()) {
            return false;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, markerText.getBytes(), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isNearby(class_4538 levelReader, class_2338 origin, int searchRange, BiPredicate<class_4538, class_2338> passes) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339().method_10101((class_2382)origin);
        for (int xOffset = -searchRange; xOffset < searchRange; ++xOffset) {
            for (int yOffset = -searchRange; yOffset < searchRange; ++yOffset) {
                for (int zOffset = -searchRange; zOffset < searchRange; ++zOffset) {
                    mutableBlockPos.method_10101((class_2382)origin).method_10100(xOffset, yOffset, zOffset);
                    if (!passes.test(levelReader, (class_2338)mutableBlockPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static IOException configFileFailureException(Path path) {
        return new IOException(String.format("BYG config found at: \"%s\" could not be read. The fastest solution is to rename this failed file and let a new file generate from BYG and replace the fields in the new file with the broken file's fields.", path.toFile()));
    }

    public static <T> class_6005<T> combineWeightedRandomListsWithoutDuplicatesFilter(class_6005<T> ... builders) {
        class_6005.class_6006 combinedBuilder = new class_6005.class_6006();
        for (class_6005<T> build : builders) {
            for (class_6008.class_6010 item : ((WeightedListAccess)build).getItems()) {
                Object data;
                Set collection = ((WeightedListAccess)combinedBuilder.method_34974()).getItems().stream().map(item1 -> ((WeightedEntryWrapperAccess)item1).getData()).collect(Collectors.toSet());
                if (collection.contains(data = ((WeightedEntryWrapperAccess)item).getData())) continue;
                combinedBuilder.method_34975(data, ((WeightedEntryWrapperAccess)item).getWeight().method_34976());
            }
        }
        return combinedBuilder.method_34974();
    }

    public static List<class_1959> createBiomesFromBiomeData(class_2378<class_1959> biomeRegistry, Path configPath, LayersBiomeData ... layersBiomeDatas) {
        ArrayList<class_1959> biomes = new ArrayList<class_1959>();
        for (LayersBiomeData layersBiomeData : layersBiomeDatas) {
            ImmutableList items = ((WeightedListAccess)layersBiomeData.biomeWeights()).getItems();
            for (class_6008.class_6010 key : items) {
                class_5321 resourceKey = (class_5321)key.method_34983();
                class_1959 biome = (class_1959)biomeRegistry.method_29107(resourceKey);
                if (biome != null) {
                    biomes.add(biome);
                    continue;
                }
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid biome in the registry, fix the ID or remove the json entry from the config: \"%s\" and relaunch Minecraft...", resourceKey, configPath.toString()));
            }
        }
        return biomes;
    }
}

