/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.server.command;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2408;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_31;
import net.minecraft.class_3754;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5285;
import net.minecraft.class_5363;
import net.minecraft.class_5384;
import net.minecraft.class_5455;
import potionstudios.byg.mixin.access.WorldGenRegistryDumpReportAccess;
import potionstudios.byg.util.ModLoaderContext;

public class WorldGenExportCommand {
    public static void worldGenExportCommand(CommandDispatcher<class_2168> dispatcher) {
        String commandString = "worldGenExport";
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)commandString).then(class_2170.method_9244((String)"Generate Built In Registries?", (ArgumentType)BoolArgumentType.bool()).executes(cs -> {
            WorldGenExportCommand.generateWorldGenExport((Boolean)cs.getArgument("Generate Built In Registries?", Boolean.class), (CommandContext<class_2168>)cs);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)commandString).redirect((CommandNode)source));
    }

    public static void generateWorldGenExport(boolean builtin, CommandContext<class_2168> commandSource) {
        class_2168 source = (class_2168)commandSource.getSource();
        source.method_9226((class_2561)new class_2588("byg.worldgenexport.starting").method_27692(class_124.field_1054), true);
        try {
            Path exportPath = ModLoaderContext.getInstance().configPath().getParent().resolve("world_gen_export").resolve(builtin ? "builtin" : "world");
            class_2408 cache = new class_2408(exportPath, "cache");
            class_5455.class_5457 registry = builtin ? class_5455.method_30528() : source.method_9225().method_30349();
            class_2370 defaultDimensions = class_2874.method_28517((class_5455)registry, (long)0L, (boolean)false);
            class_3754 chunkGenerator = class_5285.method_39558((class_5455)registry, (long)0L, (boolean)false);
            class_5384 ops = class_5384.method_29771((DynamicOps)JsonOps.INSTANCE, (class_5455)registry);
            for (class_5455.class_5456 knownRegistry : class_5455.method_39674()) {
                WorldGenRegistryDumpReportAccess.invokeDumpRegistryCap(cache, exportPath, (class_5455)registry, (DynamicOps<JsonElement>)ops, knownRegistry);
            }
            WorldGenExportCommand.createPackMCMeta(exportPath, builtin);
            class_2370 worldSettings = builtin ? class_5285.method_28608((class_2378)registry.method_33309(class_2378.field_25095), (class_2370)defaultDimensions, (class_2794)chunkGenerator) : ((class_31)source.method_9211().method_3847(class_1937.field_25179).method_8401()).method_28057().method_28609();
            WorldGenRegistryDumpReportAccess.invokeDumpRegistry(exportPath, cache, (DynamicOps<JsonElement>)ops, class_2378.field_25490, worldSettings, class_5363.field_25411);
            class_5250 fileComponent = new class_2585(exportPath.toString()).method_27692(class_124.field_1073).method_27694(text -> text.method_27703(class_5251.method_27718((class_124)class_124.field_1075)).method_10958(new class_2558(class_2558.class_2559.field_11746, exportPath.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2588("byg.clickevent.hovertext"))));
            source.method_9226((class_2561)new class_2588("byg.worldgenexport.success", new Object[]{fileComponent}).method_27692(class_124.field_1060), true);
        }
        catch (IOException e) {
            source.method_9213((class_2561)new class_2588("byg.worldgenexport.failed"));
            e.printStackTrace();
        }
    }

    private static void createPackMCMeta(Path path, boolean builtIn) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 8,\n\t\t\"description\": \" Generated world gen datapack from " + (builtIn ? "built in registries" : "current world registries") + ".\"\n\t}\n}\n";
        Files.write(path.resolve("reports").resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }
}

