/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config.json;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.BYGOverworldBiomeBuilder;
import potionstudios.byg.util.BYGUtil;

public record OverworldBiomeConfig(boolean generateOverworld, List<BYGOverworldBiomeBuilder.BiomeProviderData> values) {
    public static final OverworldBiomeConfig DEFAULT = new OverworldBiomeConfig(true, BYGOverworldBiomeBuilder.OVERWORLD_DEFAULTS);
    public static OverworldBiomeConfig INSTANCE = null;
    public static final Codec<OverworldBiomeConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("overworld_enabled").forGetter(overworldBiomeConfig -> overworldBiomeConfig.generateOverworld), (App)BYGOverworldBiomeBuilder.BiomeProviderData.CODEC.listOf().fieldOf("providers").forGetter(overworldBiomeConfig -> overworldBiomeConfig.values)).apply((Applicative)builder, OverworldBiomeConfig::new));

    public static OverworldBiomeConfig getConfig(boolean serialize) {
        if (INSTANCE == null || serialize) {
            INSTANCE = OverworldBiomeConfig.readConfig();
        }
        return INSTANCE;
    }

    public static void setConfigInstance(OverworldBiomeConfig config) {
        INSTANCE = config;
    }

    private static OverworldBiomeConfig readConfig() {
        Path path = BYG.CONFIG_PATH.resolve("overworld-biomes.json");
        if (!path.toFile().exists()) {
            JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)DEFAULT).result().get();
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(jsonElement).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                BYG.LOGGER.error(e.toString());
            }
        }
        BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
        try {
            return (OverworldBiomeConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(path.toFile()))).result().orElseThrow(() -> BYGUtil.configFileFailureException(path))).getFirst();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

