/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import java.nio.file.Path;
import java.util.Arrays;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import potionstudios.byg.BYG;
import potionstudios.byg.config.CommentedConfigBuilder;

public class WorldConfig {
    public static WorldConfig INSTANCE = null;
    private final CommentedConfigBuilder configHelper;

    public WorldConfig(Path path) {
        this.configHelper = new CommentedConfigBuilder(path);
        this.configHelper.build();
    }

    public static WorldConfig worldConfig(boolean refreshConfig) {
        if (INSTANCE == null || refreshConfig) {
            INSTANCE = new WorldConfig(BYG.CONFIG_PATH.resolve("world.toml"));
        }
        return INSTANCE;
    }

    public static WorldConfig worldConfig() {
        return WorldConfig.worldConfig(false);
    }

    public static boolean conditionPasses(String conditionString, class_5321<class_1959> biomeKey, class_1959 biome) {
        if (conditionString.isEmpty()) {
            return false;
        }
        if (conditionString.equalsIgnoreCase("all")) {
            return true;
        }
        String[] conditions = conditionString.trim().split("\\s*,\\s*");
        String biomeNamespace = biomeKey.method_29177().method_12836();
        String biomeLocation = biomeKey.method_29177().toString();
        for (String condition : conditions) {
            String[] split = condition.split("(?=[\\$#])");
            boolean categoryExists = true;
            for (String result : split) {
                if (result.startsWith("!")) {
                    result = result.substring(1);
                }
                if (!result.startsWith("#")) continue;
                String categoryString = result.substring(1);
                categoryExists = Arrays.stream(class_1959.class_1961.values()).anyMatch(bc -> bc.toString().equalsIgnoreCase(categoryString));
                if (categoryExists) continue;
                BYG.LOGGER.error("\"" + categoryString + "\" is not a valid biome category!");
            }
            if (!categoryExists) continue;
            boolean fail = false;
            for (String result : split) {
                if (result.startsWith("!")) {
                    result = result.substring(1);
                }
                if (result.startsWith("#")) {
                    String categoryString = result.substring(1);
                    fail = !biome.method_8688().method_8749().equalsIgnoreCase(categoryString);
                    continue;
                }
                if (biomeLocation.equalsIgnoreCase(result) || result.equalsIgnoreCase(biomeNamespace)) continue;
                fail = true;
            }
            boolean isFlipped = condition.startsWith("!");
            if (fail && isFlipped) {
                return true;
            }
            if (fail || isFlipped) continue;
            return true;
        }
        return false;
    }
}

