/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_3542;

public class CommentedConfigBuilder {
    private final CommentedConfig config;
    @Nullable
    private final Path filePath;

    public CommentedConfigBuilder(Path filePath) {
        this.filePath = filePath;
        if (!filePath.getParent().toFile().exists()) {
            try {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        CommentedFileConfig builtConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)filePath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        builtConfig.load();
        this.config = builtConfig;
    }

    public CommentedConfigBuilder(CommentedConfig config) {
        this.config = config;
        this.filePath = null;
    }

    public <T> List<T> addList(String comment, String key, List<T> defaultValue) {
        if (this.config.get(key) == null) {
            this.config.set(key, defaultValue);
        }
        if (this.config.getComment(key) == null) {
            this.config.setComment(key, comment);
        }
        return (List)this.config.get(key);
    }

    public CommentedConfigBuilder addSubConfig(String comment, String key, CommentedConfigBuilder defaultValue) {
        if (this.config.get(key) == null) {
            this.config.set(key, (Object)CommentedConfigBuilder.organizeConfig(defaultValue.config));
        }
        CommentedConfig subConfig = (CommentedConfig)this.config.get(key);
        String commentValue = this.config.getComment(key);
        if (commentValue == null) {
            this.config.setComment(key, comment);
        }
        return new CommentedConfigBuilder(subConfig);
    }

    public Map<?, ?> addMap(String comment, String key, Map<?, Number> defaultValue) {
        CommentedConfig subConfig;
        if (this.config.get(key) == null) {
            subConfig = this.config.createSubConfig();
            defaultValue.forEach((a, b) -> {
                String subConfigKey = a.toString();
                if (subConfig.get(a.toString()) == null) {
                    subConfig.set(subConfigKey, b);
                }
            });
            this.config.set(key, (Object)subConfig);
        }
        subConfig = (CommentedConfig)this.config.get(key);
        String commentValue = this.config.getComment(key);
        if (commentValue == null) {
            this.config.setComment(key, comment);
        }
        return subConfig.valueMap();
    }

    public <T> T add(String comment, String key, T defaultValue) {
        if (this.config.get(key) == null) {
            this.config.set(key, defaultValue);
        }
        if (this.config.getComment(key) == null) {
            this.config.setComment(key, comment);
        }
        return (T)this.config.get(key);
    }

    public <T extends Number> T addNumber(String comment, String key, T defaultValue, T min, T max) {
        Number value;
        if (this.config.get(key) == null) {
            this.config.set(key, defaultValue);
        }
        if (this.config.getComment(key) == null) {
            this.config.setComment(key, comment + String.format("\nRange: %s-%s", min, max));
        }
        return (T)(((Comparable)((Object)(value = (Number)this.config.get(key)))).compareTo(max) > 0 ? max : (((Comparable)((Object)value)).compareTo(min) < 0 ? min : value));
    }

    public <T extends Enum<T>> T addEnum(String comment, String key, T defaultValue) {
        if (this.config.get(key) == null) {
            this.config.set(key, defaultValue);
        }
        if (this.config.getComment(key) == null) {
            StringBuilder builder = new StringBuilder().append("Values: ").append(defaultValue instanceof class_3542 ? "\n" : "");
            for (Enum value : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
                if (defaultValue instanceof class_3542) {
                    builder.append(((class_3542)value).method_15434()).append("\n");
                    continue;
                }
                builder.append(value.name()).append(", ");
            }
            this.config.setComment(key, comment + "\n" + builder.toString());
        }
        String value = this.config.get(key).toString();
        return Enum.valueOf(defaultValue.getDeclaringClass(), value);
    }

    public <T> void updateValue(String key, T newValue) {
        this.config.set(key, newValue);
        this.build();
    }

    public <T> T getValue(String key) {
        return (T)this.config.get(key);
    }

    public void build() {
        if (this.filePath == null) {
            throw new UnsupportedOperationException("This file cannot be parsed w/ a null file path.");
        }
        TomlWriter writer = new TomlWriter();
        writer.write((UnmodifiableConfig)CommentedConfigBuilder.organizeConfig(this.config), this.filePath.toFile(), WritingMode.REPLACE);
    }

    public static CommentedConfig organizeConfig(CommentedConfig config) {
        CommentedConfig newConfig = CommentedConfig.of((Supplier)Config.getDefaultMapCreator((boolean)false, (boolean)true), (ConfigFormat)TomlFormat.instance());
        List<Map.Entry> organizedCollection = config.valueMap().entrySet().stream().sorted(Comparator.comparing(Objects::toString)).collect(Collectors.toList());
        organizedCollection.forEach(stringObjectEntry -> newConfig.add((String)stringObjectEntry.getKey(), stringObjectEntry.getValue()));
        newConfig.commentMap().putAll(config.commentMap());
        return newConfig;
    }
}

