/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import potionstudios.byg.common.world.feature.config.PointyRockConfig;
import potionstudios.byg.common.world.math.noise.simplex.OpenSimplex2;

public class PointyRockFeature
extends class_3031<PointyRockConfig> {
    private static final int RADIUS = 8;
    private static final int BASE_HEIGHT_MULTIPLER = 96;
    private static final double NOISE_FREQUENCY_1 = 0.013;
    private static final double NOISE_FREQUENCY_2 = 0.026;
    private static final double NOISE_RANGE = 1.5;
    private static final double EFFECTIVE_HEIGHT_MULTIPLIER = 0.015625;
    private static final double NOISE_OFFSET_X = 0.45534180126147955;
    private static final double NOISE_OFFSET_Y = 0.12200846792814621;

    public PointyRockFeature(Codec<PointyRockConfig> config) {
        super(config);
    }

    public boolean method_13151(class_5821<PointyRockConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.method_33652(), featurePlaceContext.method_33653(), featurePlaceContext.method_33654(), featurePlaceContext.method_33655(), (PointyRockConfig)featurePlaceContext.method_33656());
    }

    public boolean place(class_5281 world, class_2794 changedBlock, Random rand, class_2338 position, PointyRockConfig config) {
        long seed1 = rand.nextLong();
        long seed2 = rand.nextLong();
        int baseX = position.method_10263();
        int baseZ = position.method_10260();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        double effectiveConfiguredHeightMultiplier = config.getHeightMultiplier() * 0.015625;
        for (int z = -7; z < 8; ++z) {
            int worldZ = z + baseZ;
            for (int x = -7; x < 8; ++x) {
                int worldX = x + baseX;
                int distSq = z * z + x * x;
                if (distSq >= 64) continue;
                double falloff = 4096 - distSq * distSq;
                double noise = 1.5 - (double)Math.abs(OpenSimplex2.noise2(seed1, (double)x * 0.013 + 0.45534180126147955, (double)z * 0.013 + 0.12200846792814621)) - (double)Math.abs(OpenSimplex2.noise2(seed2, (double)x * 0.026 + 0.45534180126147955, (double)z * 0.026 + 0.12200846792814621)) * 0.5;
                noise *= falloff;
                int maximumHeight = (int)(noise *= effectiveConfiguredHeightMultiplier);
                int terrainHeight = world.method_8624(class_2902.class_2903.field_13200, worldX, worldZ);
                if (maximumHeight <= terrainHeight) continue;
                mutable.method_10103(worldX, maximumHeight, worldZ);
                for (int y = maximumHeight; y >= terrainHeight; --y) {
                    mutable.method_33098(y);
                    world.method_8652((class_2338)mutable, config.getBlockProvider().method_23455(rand, (class_2338)mutable), 2);
                }
            }
        }
        return true;
    }
}

