/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import net.minecraft.class_6796;
import potionstudios.byg.common.world.feature.config.LargeLakeFeatureConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;
import potionstudios.byg.util.MLBlockTags;

public class LargeLakeFeature
extends class_3031<LargeLakeFeatureConfig> {
    public static final boolean DEBUG = false;
    public static class_2350[] DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11033};
    public static FastNoise fastNoise;
    protected static long seed;

    public LargeLakeFeature(Codec<LargeLakeFeatureConfig> $$0) {
        super($$0);
    }

    public boolean method_13151(class_5821<LargeLakeFeatureConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.method_33652(), featurePlaceContext.method_33653(), featurePlaceContext.method_33654(), featurePlaceContext.method_33655(), (LargeLakeFeatureConfig)featurePlaceContext.method_33656());
    }

    public boolean place(class_5281 world, class_2794 chunkGenerator, Random random, class_2338 blockPos, LargeLakeFeatureConfig config) {
        LargeLakeFeature.setSeed(world.method_8412());
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)blockPos);
        class_2338.class_2339 mutable2 = new class_2338.class_2339().method_10101((class_2382)mutable);
        int xRadius = config.getRandomRadius(random) / 2;
        int yRadius = config.getRandomDepth(random);
        int zRadius = config.getRandomRadius(random) / 2;
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        ArrayList<class_2338> edgePositions = new ArrayList<class_2338>();
        Function<class_2338, class_2680> lakeBorderStateFunction = blockPos3 -> config.borderStateProvider().method_23455(random, blockPos3);
        Function<class_2338, class_2680> lakeFloorStateFunction = blockPos3 -> config.lakeFloorStateProvider().method_23455(random, blockPos3);
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                for (int y = -yRadius; y <= 0; ++y) {
                    mutable2.method_10101((class_2382)mutable).method_10100(x, y, z);
                    double xSquared = Math.pow(x, 2.0);
                    double ySquared = Math.pow(y, 2.0);
                    double zSquared = Math.pow(z, 2.0);
                    double squaredDistance = xSquared + ySquared + zSquared;
                    double equationResult = xSquared / Math.pow(xRadius, 2.0) + ySquared / Math.pow(yRadius, 2.0) + zSquared / Math.pow(zRadius, 2.0);
                    double threshold = 1.0 + 1.4 * (double)fastNoise.GetNoise(mutable2.method_10263(), mutable2.method_10264() * 2, mutable2.method_10260());
                    if (equationResult >= threshold) continue;
                    if (squaredDistance <= (double)(xRadius * zRadius)) {
                        class_2338 immutable = mutable2.method_10062();
                        if (y >= 0) continue;
                        positions.add(immutable);
                        continue;
                    }
                    double sizeAmplifier = 1.6;
                    if (y < 0 || !(squaredDistance <= ((double)xRadius + (double)xRadius * sizeAmplifier) * ((double)zRadius + (double)zRadius * sizeAmplifier))) continue;
                    edgePositions.add(mutable2.method_10062());
                }
            }
        }
        int waterLevel = blockPos.method_10264();
        for (class_2338 position : positions) {
            waterLevel = Math.min(world.method_8624(class_2902.class_2903.field_13202, position.method_10263(), position.method_10260()) - 1, waterLevel);
        }
        ArrayList<Pair> fallingBlocks = new ArrayList<Pair>();
        ArrayList<class_2338> lakeSurfacePositions = new ArrayList<class_2338>();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        block4: for (class_2338 position : positions) {
            class_2338.class_2339 mutable3 = mutableBlockPos.method_10103(position.method_10263(), Math.min(position.method_10264(), waterLevel), position.method_10260());
            for (int i = mutable3.method_10264(); i <= waterLevel; ++i) {
                this.setLakeBlocks(world, mutable3.method_10264() == waterLevel ? lakeBorderStateFunction : lakeFloorStateFunction, (class_2338)mutable3);
                mutable3.method_10098(class_2350.field_11036);
            }
            lakeSurfacePositions.add(mutable3.method_10062());
            class_2338.class_2339 mutable4 = new class_2338.class_2339().method_10101((class_2382)mutable3);
            for (int i = 0; i < 10; ++i) {
                class_2680 blockStateAbove = world.method_8320((class_2338)mutable4);
                class_2248 stateAboveBlock = blockStateAbove.method_26204();
                if (stateAboveBlock instanceof class_2346) {
                    fallingBlocks.add(new Pair((Object)mutable4.method_10062(), (Object)blockStateAbove));
                    world.method_8650((class_2338)mutable4, false);
                } else {
                    if (!LargeLakeFeature.canReplace(blockStateAbove)) continue block4;
                    world.method_8650((class_2338)mutable4, false);
                }
                mutable4.method_10098(class_2350.field_11036);
            }
        }
        for (class_2338 lakeSurfacePosition : lakeSurfacePositions) {
            for (Supplier<class_6796> lakeSurfaceFeature : config.lakeSurfaceFeatures()) {
                lakeSurfaceFeature.get().method_39644(world, chunkGenerator, random, lakeSurfacePosition);
            }
        }
        for (class_2338 lakeEdgePosition : edgePositions) {
            for (Supplier<class_6796> lakeSurfaceFeature : config.lakeEdgeFeatures()) {
                lakeSurfaceFeature.get().method_39644(world, chunkGenerator, random, lakeEdgePosition);
            }
        }
        return true;
    }

    private void setLakeBlocks(class_5281 world, Function<class_2338, class_2680> stateFunction, class_2338 mutable2) {
        world.method_8652(mutable2, class_2246.field_10382.method_9564(), 2);
        world.method_39281(mutable2, (class_3611)class_3612.field_15910, 0);
        class_2338.class_2339 mutable3 = new class_2338.class_2339().method_10101((class_2382)mutable2);
        for (class_2350 value : DIRECTIONS) {
            mutable3.method_25505((class_2382)mutable2, value);
            if (world.method_8320((class_2338)mutable3).method_26204() == class_2246.field_10382) continue;
            world.method_8652((class_2338)mutable3, stateFunction.apply((class_2338)mutable3), 2);
        }
    }

    private void fillDownwards(class_5281 world, Function<class_2338, class_2680> stateFunction, class_2338.class_2339 mutable3) {
        while (mutable3.method_10264() > world.method_31607()) {
            world.method_8652((class_2338)mutable3, stateFunction.apply((class_2338)mutable3), 2);
            mutable3.method_10098(class_2350.field_11033);
        }
    }

    public static void setSeed(long worldSeed) {
        if (seed != worldSeed || fastNoise == null) {
            fastNoise = new FastNoise((int)worldSeed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            fastNoise.SetFrequency(0.8f);
            seed = worldSeed;
        }
    }

    private static boolean canReplace(class_2680 state) {
        return !state.method_26215() && state.method_26207().method_15800() || state.method_26164((class_3494)class_3481.field_25806) || state.method_26164(MLBlockTags.END_STONES) || state.method_26164(MLBlockTags.SANDSTONE) || state.method_26164((class_3494)class_3481.field_20339) || state.method_26164(MLBlockTags.ORES) || state.method_26164((class_3494)class_3481.field_29822) || state.method_26164((class_3494)class_3481.field_36265) || state.method_26207().equals(class_3614.field_15935) || state.method_26207().equals(class_3614.field_15947) || state.method_26207().equals(class_3614.field_15926);
    }
}

