/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3610;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import net.minecraft.class_6796;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class NoisyCaveSphere
extends class_3031<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public NoisyCaveSphere(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<NoisySphereConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.method_33652(), featurePlaceContext.method_33653(), featurePlaceContext.method_33654(), featurePlaceContext.method_33655(), (NoisySphereConfig)featurePlaceContext.method_33656());
    }

    public boolean place(class_5281 world, class_2794 chunkGenerator, Random random, class_2338 position, NoisySphereConfig config) {
        this.setSeed(world.method_8412());
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)position.method_10087(2 + random.nextInt(10)));
        class_2338.class_2339 mutable2 = new class_2338.class_2339().method_10101((class_2382)mutable);
        int stackHeight = config.stackHeight().method_35008(random);
        NoisySphereConfig.RadiusSettings radiusSettings = config.radiusSettings();
        int xRadius = radiusSettings.xRadius().method_35008(random) / 2;
        int yRadius = radiusSettings.yRadius().method_35008(random) / 2;
        int zRadius = radiusSettings.zRadius().method_35008(random) / 2;
        fastNoise.SetFrequency(config.noiseFrequency());
        double radiusDivisorPerStack = config.radiusDivisorPerStack();
        ArrayList<class_2338> caveAir = new ArrayList<class_2338>();
        for (int stackIDX = 0; stackIDX < stackHeight; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                for (int z = -zRadius; z <= zRadius; ++z) {
                    for (int y = -yRadius; y <= yRadius; ++y) {
                        mutable2.method_10101((class_2382)mutable).method_10100(x, y, z);
                        double equationResult = Math.pow(x, 2.0) / Math.pow(xRadius, 2.0) + Math.pow(y, 2.0) / Math.pow(yRadius, 2.0) + Math.pow(z, 2.0) / Math.pow(zRadius, 2.0);
                        double threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable2.method_10263(), mutable2.method_10264(), mutable2.method_10260());
                        if (equationResult >= threshold || !world.method_8320((class_2338)mutable2).method_26225()) continue;
                        if (mutable2.method_10264() <= 30) {
                            NoisyCaveSphere.placeFluid(world, config.fluidState(), mutable2);
                            continue;
                        }
                        class_2680 state = config.blockProvider().method_23455(random, (class_2338)mutable2);
                        if (state.method_26215()) {
                            caveAir.add(mutable2.method_10062());
                        }
                        world.method_8652((class_2338)mutable2, state, 2);
                        for (int i = 0; i < 8; ++i) {
                            class_2680 blockState = world.method_8320((class_2338)mutable2);
                            if (!blockState.method_26225() && !blockState.method_26215() || blockState.method_27852(BYGBlocks.CRYPTIC_VENT) || blockState.method_27852(BYGBlocks.TALL_CRYPTIC_VENT) || blockState.method_27852(BYGBlocks.CRYPTIC_FIRE)) {
                                world.method_8650((class_2338)mutable2, false);
                            }
                            mutable2.method_10098(class_2350.field_11036);
                        }
                    }
                    xRadius = (int)((double)xRadius / radiusDivisorPerStack);
                    yRadius = (int)((double)yRadius / radiusDivisorPerStack);
                    zRadius = (int)((double)zRadius / radiusDivisorPerStack);
                }
            }
            for (class_2338 blockPos : caveAir) {
                for (Supplier<class_6796> spawningFeature : config.spawningFeatures()) {
                    spawningFeature.get().method_39644(world, chunkGenerator, random, blockPos);
                }
            }
        }
        return true;
    }

    public static void placeFluid(class_5281 world, class_3610 fluidState, class_2338.class_2339 mutable2) {
        boolean isSolidAllAround = true;
        for (class_2350 direction : class_2350.values()) {
            class_2680 blockState;
            if (direction == class_2350.field_11036 || (blockState = world.method_8320(mutable2.method_10093(direction))).method_26227().method_15772() == fluidState.method_15772() || blockState.method_26225()) continue;
            isSolidAllAround = false;
            break;
        }
        if (isSolidAllAround) {
            world.method_8652((class_2338)mutable2, fluidState.method_15759().method_26204().method_9564(), 2);
            world.method_39281((class_2338)mutable2, fluidState.method_15772(), 0);
        }
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }
}

