/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class PointyRockConfig
implements class_3037 {
    public static final Codec<PointyRockConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)class_4651.field_24937.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("seed").orElse((Object)0).forGetter(config -> config.seed), (App)Codec.DOUBLE.fieldOf("height_multiplier").orElse((Object)1.0).forGetter(config -> config.heightMultiplier)).apply((Applicative)codecRecorder, PointyRockConfig::new));
    private final class_4651 blockProvider;
    private final int seed;
    private final double heightMultiplier;
    private FastNoise noiseGen = null;

    PointyRockConfig(class_4651 blockProvider, int seed, double heightMultiplier) {
        this.blockProvider = blockProvider;
        this.seed = seed;
        this.heightMultiplier = heightMultiplier;
    }

    public class_4651 getBlockProvider() {
        return this.blockProvider;
    }

    public int getSeed() {
        return this.seed;
    }

    public double getHeightMultiplier() {
        return this.heightMultiplier;
    }

    public void setUpNoise(long worldSeed) {
        if (this.noiseGen == null) {
            this.noiseGen = new FastNoise((int)(worldSeed + (long)this.seed));
            this.noiseGen.SetFractalType(FastNoise.FractalType.RigidMulti);
            this.noiseGen.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.noiseGen.SetGradientPerturbAmp(5.0f);
            this.noiseGen.SetFractalOctaves(1);
            this.noiseGen.SetFractalGain(0.3f);
            this.noiseGen.SetFrequency(0.02f);
        }
    }

    public FastNoise getNoiseGen() {
        if (this.noiseGen == null) {
            throw new NullPointerException("Initialize the noiseGen variable with \"setupNoise\" in your feature!");
        }
        return this.noiseGen;
    }

    public static class Builder {
        private class_4651 blockProvider = class_4656.method_38433((class_2680)class_2246.field_10340.method_9564());
        private int seed = 65;
        private double heightMultiplier = 1.0;

        public Builder setBlock(class_2248 block) {
            this.blockProvider = class_4656.method_38433((class_2680)block.method_9564());
            return this;
        }

        public Builder setBlock(class_2680 state) {
            this.blockProvider = class_4656.method_38433((class_2680)state);
            return this;
        }

        public Builder setBlock(class_4651 blockProvider) {
            this.blockProvider = blockProvider;
            return this;
        }

        public Builder setSeed(int seed) {
            this.seed = seed;
            return this;
        }

        public Builder setHeightMultiplier(double heightMultiplier) {
            this.heightMultiplier = heightMultiplier;
            return this;
        }

        public PointyRockConfig build() {
            return new PointyRockConfig(this.blockProvider, this.seed, this.heightMultiplier);
        }
    }
}

