/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.nether;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.util.BYGUtil;

public record NetherBiomesConfig(boolean useBYGNetherBiomeSourceInNewWorlds, boolean warnBYGNetherBiomeSourceNotUsedInNewWorlds, boolean useUpdatingConfig, LayersBiomeData upperLayer, LayersBiomeData middleLayer, LayersBiomeData bottomLayer, int layerSize, boolean addAllNetherBiomeCategoryEntries) {
    public static final Supplier<Path> CONFIG_PATH = () -> BYG.CONFIG_PATH.resolve("byg-nether-biomes.json");
    public static final Codec<NetherBiomesConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("useBYGNetherBiomeSourceInNewWorlds").forGetter(overworldBiomeConfig -> overworldBiomeConfig.useBYGNetherBiomeSourceInNewWorlds), (App)Codec.BOOL.fieldOf("warnBYGNetherBiomeSourceNotUsedInNewWorlds").forGetter(overworldBiomeConfig -> overworldBiomeConfig.warnBYGNetherBiomeSourceNotUsedInNewWorlds), (App)Codec.BOOL.optionalFieldOf("useConfigDataInExistingWorlds", (Object)true).forGetter(overworldBiomeConfig -> overworldBiomeConfig.useUpdatingConfig), (App)LayersBiomeData.CODEC.fieldOf("upperLayer").forGetter(overworldBiomeConfig -> overworldBiomeConfig.upperLayer), (App)LayersBiomeData.CODEC.fieldOf("middleLayer").forGetter(overworldBiomeConfig -> overworldBiomeConfig.middleLayer), (App)LayersBiomeData.CODEC.fieldOf("bottomLayer").forGetter(overworldBiomeConfig -> overworldBiomeConfig.bottomLayer), (App)Codec.INT.fieldOf("layerSizeInBlocks").forGetter(overworldBiomeConfig -> overworldBiomeConfig.layerSize), (App)Codec.BOOL.fieldOf("addAllEndBiomeCategoryEntries").forGetter(overworldBiomeConfig -> overworldBiomeConfig.addAllNetherBiomeCategoryEntries)).apply((Applicative)builder, NetherBiomesConfig::new));
    public static NetherBiomesConfig INSTANCE = null;
    public static final NetherBiomesConfig DEFAULT = new NetherBiomesConfig(true, true, true, LayersBiomeData.DEFAULT_NETHER_UPPER, LayersBiomeData.DEFAULT_NETHER_MIDDLE, LayersBiomeData.DEFAULT_NETHER_LOWER, 40, true);

    public static NetherBiomesConfig getConfig() {
        return NetherBiomesConfig.getConfig(false, null);
    }

    public static NetherBiomesConfig getConfig(boolean serialize) {
        return NetherBiomesConfig.getConfig(serialize, null);
    }

    public static NetherBiomesConfig getConfig(boolean serialize, @Nullable class_2378<class_1959> additional) {
        if (INSTANCE == null || serialize) {
            INSTANCE = NetherBiomesConfig.readConfig();
        }
        if (additional != null && INSTANCE.addAllNetherBiomeCategoryEntries()) {
            class_6005 registryDefaults = ((class_6005.class_6006)class_156.method_654((Object)class_6005.method_34971(), builder -> {
                for (class_1959 biome : additional) {
                    if (biome.method_8688() != class_1959.class_1961.field_9366) continue;
                    builder.method_34975((Object)((class_5321)additional.method_29113((Object)biome).get()), 2);
                }
            })).method_34974();
            NetherBiomesConfig registryUpdatedConfig = new NetherBiomesConfig(INSTANCE.useBYGNetherBiomeSourceInNewWorlds(), INSTANCE.warnBYGNetherBiomeSourceNotUsedInNewWorlds(), INSTANCE.useUpdatingConfig(), new LayersBiomeData(INSTANCE.bottomLayer().biomeWeights(), INSTANCE.bottomLayer().biomeSize()), new LayersBiomeData(BYGUtil.combineWeightedRandomListsWithoutDuplicatesFilter(INSTANCE.middleLayer().biomeWeights(), registryDefaults), INSTANCE.middleLayer().biomeSize()), new LayersBiomeData(BYGUtil.combineWeightedRandomListsWithoutDuplicatesFilter(INSTANCE.upperLayer().biomeWeights(), registryDefaults), INSTANCE.upperLayer().biomeSize()), INSTANCE.layerSize(), INSTANCE.addAllNetherBiomeCategoryEntries());
            NetherBiomesConfig.createConfig(CONFIG_PATH.get(), registryUpdatedConfig);
            INSTANCE = registryUpdatedConfig;
        }
        return INSTANCE;
    }

    private static NetherBiomesConfig readConfig() {
        Path path = CONFIG_PATH.get();
        if (!path.toFile().exists()) {
            NetherBiomesConfig.createConfig(path, DEFAULT);
        }
        BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
        try {
            return (NetherBiomesConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(path.toFile()))).result().orElseThrow(() -> BYGUtil.configFileFailureException(path))).getFirst();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void createConfig(Path path, NetherBiomesConfig configToSerialize) {
        JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)configToSerialize).result().get();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(jsonElement).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BYG.LOGGER.error(e.toString());
        }
    }
}

