/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.nether;

import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6780;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.lite.FastNoiseLite;
import potionstudios.byg.util.BYGUtil;

public abstract class BYGNetherBiomeSource
extends class_1966 {
    public static final class_2960 LOCATION = BYG.createLocation("nether");
    private final FastNoiseLite lowerLayerRoughnessNoise;
    private final FastNoiseLite upperLayerRoughnessNoise;
    private final class_2378<class_1959> biomeRegistry;
    private final LayersBiomeData upperLayerBiomeData;
    private final LayersBiomeData middleLayerBiomeData;
    private final LayersBiomeData bottomLayerBiomeData;
    private final class_6780 upperBiomeResolver;
    private final class_6780 middleBiomeResolver;
    private final class_6780 bottomResolver;
    private final int bottomTopY;
    private final long seed;

    protected BYGNetherBiomeSource(class_2378<class_1959> biomeRegistry, long seed, LayersBiomeData upperLayerBiomeData, LayersBiomeData middleLayerBiomeData, LayersBiomeData bottomLayerBiomeData, int layerSize) {
        super((List)class_156.method_656(() -> {
            NetherBiomesConfig config = NetherBiomesConfig.getConfig(true, biomeRegistry);
            LayersBiomeData usedUpperLayer = config.useUpdatingConfig() ? config.upperLayer() : upperLayerBiomeData;
            LayersBiomeData usedMiddleLayer = config.useUpdatingConfig() ? config.middleLayer() : middleLayerBiomeData;
            LayersBiomeData usedBottomLayer = config.useUpdatingConfig() ? config.bottomLayer() : bottomLayerBiomeData;
            List<class_1959> biomesFromBiomeData = BYGUtil.createBiomesFromBiomeData(biomeRegistry, NetherBiomesConfig.CONFIG_PATH.get(), usedUpperLayer, usedMiddleLayer, usedBottomLayer);
            biomesFromBiomeData.addAll(biomeRegistry.method_10220().filter(biome -> biome.method_8688() == class_1959.class_1961.field_9366).toList());
            return biomesFromBiomeData;
        }));
        this.biomeRegistry = biomeRegistry;
        this.seed = seed;
        this.lowerLayerRoughnessNoise = new FastNoiseLite((int)seed);
        this.lowerLayerRoughnessNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.lowerLayerRoughnessNoise.SetFrequency(0.005f);
        this.upperLayerRoughnessNoise = new FastNoiseLite((int)seed + 43594389);
        this.upperLayerRoughnessNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2);
        this.upperLayerRoughnessNoise.SetFrequency(0.005f);
        this.upperLayerBiomeData = upperLayerBiomeData;
        this.middleLayerBiomeData = middleLayerBiomeData;
        this.bottomLayerBiomeData = bottomLayerBiomeData;
        NetherBiomesConfig config = NetherBiomesConfig.getConfig(true);
        LayersBiomeData usedUpperLayer = config.useUpdatingConfig() ? config.upperLayer() : upperLayerBiomeData;
        LayersBiomeData usedMiddleLayer = config.useUpdatingConfig() ? config.middleLayer() : middleLayerBiomeData;
        LayersBiomeData usedBottomLayer = config.useUpdatingConfig() ? config.bottomLayer() : bottomLayerBiomeData;
        int usedLayerSize = config.useUpdatingConfig() ? config.layerSize() : layerSize;
        this.upperBiomeResolver = this.getUpperBiomeResolver(biomeRegistry, seed, usedUpperLayer);
        this.middleBiomeResolver = this.getMiddleBiomeResolver(biomeRegistry, seed, usedMiddleLayer);
        this.bottomResolver = this.getLowerBiomeResolver(biomeRegistry, seed, usedBottomLayer);
        this.bottomTopY = class_5742.method_33100((int)usedLayerSize);
    }

    public abstract class_6780 getUpperBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public abstract class_6780 getMiddleBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public abstract class_6780 getLowerBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public class_1959 method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        if ((float)y < (float)this.bottomTopY + this.lowerLayerRoughnessNoise.GetNoise(x, z) * 5.0f) {
            return this.bottomResolver.method_38109(x, y, z, sampler);
        }
        if ((float)y > (float)(this.bottomTopY + this.bottomTopY) + this.upperLayerRoughnessNoise.GetNoise(x, z) * 5.0f) {
            return this.upperBiomeResolver.method_38109(x, y, z, sampler);
        }
        return this.middleBiomeResolver.method_38109(x, y, z, sampler);
    }

    public class_2378<class_1959> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public LayersBiomeData getUpperLayerBiomeData() {
        return this.upperLayerBiomeData;
    }

    public LayersBiomeData getMiddleLayerBiomeData() {
        return this.middleLayerBiomeData;
    }

    public LayersBiomeData getBottomLayerBiomeData() {
        return this.bottomLayerBiomeData;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getBottomTopY() {
        return class_5742.method_33101((int)this.bottomTopY);
    }
}

