/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.end;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.util.BYGUtil;

public record EndBiomesConfig(boolean useBYGEndBiomeSourceInNewWorlds, boolean warnBYGEndBiomeSourceNotUsedInNewWorlds, boolean useUpdatingConfig, LayersBiomeData islandLayers, LayersBiomeData voidLayers, LayersBiomeData skyLayers, int skyLayerStartY, boolean addAllEndBiomeCategoryEntries) {
    public static final Supplier<Path> CONFIG_PATH = () -> BYG.CONFIG_PATH.resolve("byg-end-biomes.json");
    public static final Codec<EndBiomesConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("useBYGNetherBiomeSourceInNewWorlds").forGetter(overworldBiomeConfig -> overworldBiomeConfig.useBYGEndBiomeSourceInNewWorlds), (App)Codec.BOOL.optionalFieldOf("useConfigDataInExistingWorlds", (Object)true).forGetter(overworldBiomeConfig -> overworldBiomeConfig.useUpdatingConfig), (App)Codec.BOOL.fieldOf("warnBYGNetherBiomeSourceNotUsedInNewWorlds").forGetter(overworldBiomeConfig -> overworldBiomeConfig.warnBYGEndBiomeSourceNotUsedInNewWorlds), (App)LayersBiomeData.CODEC.fieldOf("islandLayerData").forGetter(overworldBiomeConfig -> overworldBiomeConfig.islandLayers), (App)LayersBiomeData.CODEC.fieldOf("voidLayerData").forGetter(overworldBiomeConfig -> overworldBiomeConfig.voidLayers), (App)LayersBiomeData.CODEC.fieldOf("skyLayerData").forGetter(overworldBiomeConfig -> overworldBiomeConfig.skyLayers), (App)Codec.INT.fieldOf("skyLayerStartY").forGetter(overworldBiomeConfig -> overworldBiomeConfig.skyLayerStartY), (App)Codec.BOOL.fieldOf("addAllEndBiomeCategoryEntries").forGetter(overworldBiomeConfig -> overworldBiomeConfig.addAllEndBiomeCategoryEntries)).apply((Applicative)builder, EndBiomesConfig::new));
    public static EndBiomesConfig INSTANCE = null;
    public static final EndBiomesConfig DEFAULT = new EndBiomesConfig(true, true, true, LayersBiomeData.DEFAULT_END_ISLANDS, LayersBiomeData.DEFAULT_END_VOID, LayersBiomeData.DEFAULT_SKY, 180, true);

    public static EndBiomesConfig getConfig() {
        return EndBiomesConfig.getConfig(false, null);
    }

    public static EndBiomesConfig getConfig(boolean serialize) {
        return EndBiomesConfig.getConfig(serialize, null);
    }

    public static EndBiomesConfig getConfig(boolean serialize, @Nullable class_2378<class_1959> additional) {
        if (INSTANCE == null || serialize) {
            INSTANCE = EndBiomesConfig.readConfig();
        }
        if (additional != null && INSTANCE.addAllEndBiomeCategoryEntries()) {
            class_6005 registryDefaults = ((class_6005.class_6006)class_156.method_654((Object)class_6005.method_34971(), builder -> {
                for (class_1959 biome : additional) {
                    if (biome.method_8688() != class_1959.class_1961.field_9360) continue;
                    builder.method_34975((Object)((class_5321)additional.method_29113((Object)biome).get()), 2);
                }
            })).method_34974();
            EndBiomesConfig registryUpdatedConfig = new EndBiomesConfig(INSTANCE.useBYGEndBiomeSourceInNewWorlds(), INSTANCE.warnBYGEndBiomeSourceNotUsedInNewWorlds(), INSTANCE.useUpdatingConfig(), new LayersBiomeData(BYGUtil.combineWeightedRandomListsWithoutDuplicatesFilter(INSTANCE.islandLayers().biomeWeights(), registryDefaults), INSTANCE.islandLayers().biomeSize()), new LayersBiomeData(INSTANCE.voidLayers().biomeWeights(), INSTANCE.voidLayers().biomeSize()), new LayersBiomeData(INSTANCE.skyLayers().biomeWeights(), INSTANCE.skyLayers().biomeSize()), INSTANCE.skyLayerStartY(), INSTANCE.addAllEndBiomeCategoryEntries());
            EndBiomesConfig.createConfig(CONFIG_PATH.get(), registryUpdatedConfig);
            INSTANCE = registryUpdatedConfig;
        }
        return INSTANCE;
    }

    private static EndBiomesConfig readConfig() {
        Path path = CONFIG_PATH.get();
        if (!path.toFile().exists()) {
            EndBiomesConfig.createConfig(path, DEFAULT);
        }
        BYG.LOGGER.info(String.format("\"%s\" was read.", path.toString()));
        try {
            return (EndBiomesConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(path.toFile()))).result().orElseThrow(() -> BYGUtil.configFileFailureException(path))).getFirst();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void createConfig(Path path, EndBiomesConfig configToSerialize) {
        JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)configToSerialize).result().get();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(jsonElement).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BYG.LOGGER.error(e.toString());
        }
    }
}

