/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome.end;

import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3541;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6544;
import net.minecraft.class_6780;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.LayersBiomeData;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.util.BYGUtil;

public abstract class BYGEndBiomeSource
extends class_1966 {
    public static final class_2960 LOCATION = BYG.createLocation("end");
    private final class_3541 islandNoise;
    private final class_2378<class_1959> biomeRegistry;
    private final LayersBiomeData islandLayersBiomeData;
    private final LayersBiomeData voidLayersBiomeData;
    private final LayersBiomeData skyLayersBiomeData;
    private final class_6780 islandBiomeResolver;
    private final class_6780 voidBiomeResolver;
    private final class_6780 skyBiomeResolver;
    private final int skyLayersStartY;
    private final long seed;

    protected BYGEndBiomeSource(class_2378<class_1959> biomeRegistry, long seed, LayersBiomeData islandLayersBiomeData, LayersBiomeData voidLayersBiomeData, LayersBiomeData skyLayersBiomeData) {
        super((List)class_156.method_656(() -> {
            EndBiomesConfig config = EndBiomesConfig.getConfig(true, biomeRegistry);
            LayersBiomeData usedIslandLayer = config.useUpdatingConfig() ? config.islandLayers() : islandLayersBiomeData;
            LayersBiomeData usedVoidLayer = config.useUpdatingConfig() ? config.voidLayers() : voidLayersBiomeData;
            LayersBiomeData usedSkyLayer = config.useUpdatingConfig() ? config.skyLayers() : skyLayersBiomeData;
            List<class_1959> biomesFromBiomeData = BYGUtil.createBiomesFromBiomeData(biomeRegistry, EndBiomesConfig.CONFIG_PATH.get(), usedIslandLayer, usedVoidLayer, usedSkyLayer);
            biomesFromBiomeData.add((class_1959)biomeRegistry.method_29107(class_1972.field_9411));
            return biomesFromBiomeData;
        }));
        this.biomeRegistry = biomeRegistry;
        this.seed = seed;
        class_2919 worldgenrandom = new class_2919((class_5819)new class_5820(seed));
        worldgenrandom.method_33650(17292);
        this.islandNoise = new class_3541((class_5819)worldgenrandom);
        this.islandLayersBiomeData = islandLayersBiomeData;
        this.voidLayersBiomeData = voidLayersBiomeData;
        this.skyLayersBiomeData = skyLayersBiomeData;
        EndBiomesConfig config = EndBiomesConfig.getConfig(true);
        LayersBiomeData usedIslandLayer = config.useUpdatingConfig() ? config.islandLayers() : islandLayersBiomeData;
        LayersBiomeData usedVoidLayer = config.useUpdatingConfig() ? config.voidLayers() : voidLayersBiomeData;
        LayersBiomeData usedSkyLayer = config.useUpdatingConfig() ? config.skyLayers() : skyLayersBiomeData;
        this.islandBiomeResolver = this.getIslandBiomeResolver(biomeRegistry, seed, usedIslandLayer);
        this.voidBiomeResolver = this.getVoidBiomeResolver(biomeRegistry, seed, usedVoidLayer);
        this.skyBiomeResolver = this.getSkyBiomeResolver(biomeRegistry, seed, usedSkyLayer);
        this.skyLayersStartY = class_5742.method_33100((int)config.skyLayerStartY());
    }

    public abstract class_6780 getIslandBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public abstract class_6780 getVoidBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public abstract class_6780 getSkyBiomeResolver(class_2378<class_1959> var1, long var2, LayersBiomeData var4);

    public class_1959 method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        int chunkX = x >> 2;
        int chunkZ = z >> 2;
        if ((long)chunkX * (long)chunkX + (long)chunkZ * (long)chunkZ <= 4096L) {
            return (class_1959)this.biomeRegistry.method_29107(class_1972.field_9411);
        }
        if (y > this.skyLayersStartY) {
            return this.skyBiomeResolver.method_38109(x, y, z, sampler);
        }
        float heightValue = class_2169.method_8757((class_3541)this.islandNoise, (int)(chunkX * 2 + 1), (int)(chunkZ * 2 + 1));
        if (heightValue > 40.0f) {
            return this.islandBiomeResolver.method_38109(x, y, z, sampler);
        }
        if (heightValue >= 0.0f) {
            return this.islandBiomeResolver.method_38109(x, y, z, sampler);
        }
        return heightValue < -20.0f ? this.voidBiomeResolver.method_38109(x, y, z, sampler) : this.islandBiomeResolver.method_38109(x, y, z, sampler);
    }

    public class_2378<class_1959> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public LayersBiomeData getIslandLayersBiomeData() {
        return this.islandLayersBiomeData;
    }

    public LayersBiomeData getVoidLayersBiomeData() {
        return this.voidLayersBiomeData;
    }

    public LayersBiomeData getSkyLayersBiomeData() {
        return this.skyLayersBiomeData;
    }

    public long getSeed() {
        return this.seed;
    }
}

