/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.BYGNetherBiomes;
import potionstudios.byg.common.world.biome.BYGOverworldBiomes;
import potionstudios.byg.common.world.biome.end.BYGEndBiomes;
import potionstudios.byg.mixin.access.BiomeGenerationSettingsAccess;
import potionstudios.byg.util.RegistryObject;

public class BYGBiomes {
    public static final List<RegistryObject<class_1959>> BIOMES = new ArrayList<RegistryObject<class_1959>>();
    public static class_5321<class_1959> ALLIUM_FIELDS = BYGBiomes.createBiome("allium_fields", BYGOverworldBiomes.alliumFields());
    public static class_5321<class_1959> AMARANTH_FIELDS = BYGBiomes.createBiome("amaranth_fields", BYGOverworldBiomes.amaranthFields());
    public static class_5321<class_1959> ARAUCARIA_SAVANNA = BYGBiomes.createBiome("araucaria_savanna", BYGOverworldBiomes.araucariaSavanna(false));
    public static class_5321<class_1959> ASPEN_FOREST = BYGBiomes.createBiome("aspen_forest", BYGOverworldBiomes.aspenForest());
    public static class_5321<class_1959> AUTUMNAL_VALLEY = BYGBiomes.createBiome("autumnal_valley", BYGOverworldBiomes.autumnalValley());
    public static class_5321<class_1959> BAOBAB_SAVANNA = BYGBiomes.createBiome("baobab_savanna", BYGOverworldBiomes.baobabSavanna());
    public static class_5321<class_1959> BAYOU = BYGBiomes.createBiome("bayou", BYGOverworldBiomes.bayou());
    public static class_5321<class_1959> BLACK_FOREST = BYGBiomes.createBiome("black_forest", BYGOverworldBiomes.blackForest());
    public static class_5321<class_1959> BOREALIS_GROVE = BYGBiomes.createBiome("borealis_grove", BYGOverworldBiomes.borealisGrove());
    public static class_5321<class_1959> CANADIAN_SHIELD = BYGBiomes.createBiome("canadian_shield", BYGOverworldBiomes.canadianShield());
    public static class_5321<class_1959> CHERRY_BLOSSOM_FOREST = BYGBiomes.createBiome("cherry_blossom_forest", BYGOverworldBiomes.cherryBlossomForest());
    public static class_5321<class_1959> CIKA_WOODS = BYGBiomes.createBiome("cika_woods", BYGOverworldBiomes.cikaWoods());
    public static class_5321<class_1959> CONIFEROUS_FOREST = BYGBiomes.createBiome("coniferous_forest", BYGOverworldBiomes.coniferousForest(false));
    public static class_5321<class_1959> CRAG_GARDENS = BYGBiomes.createBiome("crag_gardens", BYGOverworldBiomes.cragGardens());
    public static class_5321<class_1959> CYPRESS_SWAMPLANDS = BYGBiomes.createBiome("cypress_swamplands", BYGOverworldBiomes.cypressSwamplands());
    public static class_5321<class_1959> DEAD_SEA = BYGBiomes.createBiome("dead_sea", BYGOverworldBiomes.deadSea());
    public static class_5321<class_1959> DACITE_RIDGES = BYGBiomes.createBiome("dacite_ridges", BYGOverworldBiomes.daciteRidges());
    public static class_5321<class_1959> WINDSWEPT_DUNES = BYGBiomes.createBiome("windswept_dunes", BYGOverworldBiomes.windsweptDunes());
    public static class_5321<class_1959> EBONY_WOODS = BYGBiomes.createBiome("ebony_woods", BYGOverworldBiomes.ebonyWoods());
    public static class_5321<class_1959> FORGOTTEN_FOREST = BYGBiomes.createBiome("forgotten_forest", BYGOverworldBiomes.forgottenForest());
    public static class_5321<class_1959> GROVE = BYGBiomes.createBiome("temperate_grove", BYGOverworldBiomes.temperateGrove(false));
    public static class_5321<class_1959> GUIANA_SHIELD = BYGBiomes.createBiome("guiana_shield", BYGOverworldBiomes.guianaShield());
    public static class_5321<class_1959> JACARANDA_FOREST = BYGBiomes.createBiome("jacaranda_forest", BYGOverworldBiomes.jacarandaForest());
    public static class_5321<class_1959> MAPLE_TAIGA = BYGBiomes.createBiome("maple_taiga", BYGOverworldBiomes.mapleTaiga());
    public static class_5321<class_1959> COCONINO_MEADOW = BYGBiomes.createBiome("coconino_meadow", BYGOverworldBiomes.coconinoMeadow(false, false));
    public static class_5321<class_1959> MOJAVE_DESERT = BYGBiomes.createBiome("mojave_desert", BYGOverworldBiomes.mojaveDesert());
    public static class_5321<class_1959> ORCHARD = BYGBiomes.createBiome("orchard", BYGOverworldBiomes.orchard());
    public static class_5321<class_1959> PRAIRIE = BYGBiomes.createBiome("prairie", BYGOverworldBiomes.prairie());
    public static class_5321<class_1959> RED_OAK_FOREST = BYGBiomes.createBiome("red_oak_forest", BYGOverworldBiomes.redOakForest());
    public static class_5321<class_1959> ROSE_FIELDS = BYGBiomes.createBiome("rose_fields", BYGOverworldBiomes.roseFields());
    public static class_5321<class_1959> AUTUMNAL_FOREST = BYGBiomes.createBiome("autumnal_forest", BYGOverworldBiomes.autumnalForest());
    public static class_5321<class_1959> AUTUMNAL_TAIGA = BYGBiomes.createBiome("autumnal_taiga", BYGOverworldBiomes.autumnalTaiga(false));
    public static class_5321<class_1959> SHATTERED_GLACIER = BYGBiomes.createBiome("shattered_glacier", BYGOverworldBiomes.shatteredGlacier());
    public static class_5321<class_1959> FIRECRACKER_SHRUBLAND = BYGBiomes.createBiome("firecracker_shrubland", BYGOverworldBiomes.firecrackerShrubland());
    public static class_5321<class_1959> SIERRA_BADLANDS = BYGBiomes.createBiome("sierra_badlands", BYGOverworldBiomes.sierraBadlands());
    public static class_5321<class_1959> SKYRIS_VALE = BYGBiomes.createBiome("skyris_vale", BYGOverworldBiomes.skyrisVale());
    public static class_5321<class_1959> REDWOOD_THICKET = BYGBiomes.createBiome("redwood_thicket", BYGOverworldBiomes.redwoodThicket());
    public static class_5321<class_1959> FROSTED_TAIGA = BYGBiomes.createBiome("frosted_taiga", BYGOverworldBiomes.frostedTaiga(true, false));
    public static class_5321<class_1959> FROSTED_CONIFEROUS_FOREST = BYGBiomes.createBiome("frosted_coniferous_forest", BYGOverworldBiomes.coniferousForest(true));
    public static class_5321<class_1959> FRAGMENT_FOREST = BYGBiomes.createBiome("fragment_forest", BYGOverworldBiomes.fragmentForest());
    public static class_5321<class_1959> TROPICAL_RAINFOREST = BYGBiomes.createBiome("tropical_rainforest", BYGOverworldBiomes.tropicalRainforest());
    public static class_5321<class_1959> TWILIGHT_MEADOW = BYGBiomes.createBiome("twilight_meadow", BYGOverworldBiomes.twilightMeadow());
    public static class_5321<class_1959> WEEPING_WITCH_FOREST = BYGBiomes.createBiome("weeping_witch_forest", BYGOverworldBiomes.weepingWitchForest());
    public static class_5321<class_1959> TEMPERATE_RAINFOREST = BYGBiomes.createBiome("temperate_rainforest", BYGOverworldBiomes.temperateRainForest());
    public static class_5321<class_1959> ZELKOVA_FOREST = BYGBiomes.createBiome("zelkova_forest", BYGOverworldBiomes.zelkovaForest());
    public static class_5321<class_1959> BRIMSTONE_CAVERNS = BYGBiomes.createBiome("brimstone_caverns", BYGNetherBiomes.brimstoneCaverns());
    public static class_5321<class_1959> CRIMSON_GARDENS = BYGBiomes.createBiome("crimson_gardens", BYGNetherBiomes.crimsonGardens());
    public static class_5321<class_1959> EMBUR_BOG = BYGBiomes.createBiome("embur_bog", BYGNetherBiomes.emburBog());
    public static class_5321<class_1959> GLOWSTONE_GARDENS = BYGBiomes.createBiome("glowstone_gardens", BYGNetherBiomes.glowstoneGardens());
    public static class_5321<class_1959> MAGMA_WASTES = BYGBiomes.createBiome("magma_wastes", BYGNetherBiomes.magmaWastes());
    public static class_5321<class_1959> SUBZERO_HYPOGEAL = BYGBiomes.createBiome("subzero_hypogeal", BYGNetherBiomes.subzeroHypogeal());
    public static class_5321<class_1959> SYTHIAN_TORRIDS = BYGBiomes.createBiome("sythian_torrids", BYGNetherBiomes.sythianTorrids());
    public static class_5321<class_1959> WARPED_DESERT = BYGBiomes.createBiome("warped_desert", BYGNetherBiomes.warpedDesert());
    public static class_5321<class_1959> WAILING_GARTH = BYGBiomes.createBiome("wailing_garth", BYGNetherBiomes.wailingGarth());
    public static class_5321<class_1959> ARISIAN_UNDERGROWTH = BYGBiomes.createBiome("arisian_undergrowth", BYGNetherBiomes.arisianUndergrowth());
    public static class_5321<class_1959> WEEPING_MIRE = BYGBiomes.createBiome("weeping_mire", BYGNetherBiomes.weepingMire());
    public static class_5321<class_1959> QUARTZ_DESERT = BYGBiomes.createBiome("quartz_desert", BYGNetherBiomes.quartzDesert());
    public static class_5321<class_1959> IVIS_FIELDS = BYGBiomes.createBiome("ivis_fields", BYGEndBiomes.ivisFields());
    public static class_5321<class_1959> NIGHTSHADE_FOREST = BYGBiomes.createBiome("nightshade_forest", BYGEndBiomes.nightshadeForest());
    public static class_5321<class_1959> ETHEREAL_ISLANDS = BYGBiomes.createBiome("ethereal_islands", BYGEndBiomes.etherealIslands());
    public static class_5321<class_1959> VISCAL_ISLES = BYGBiomes.createBiome("viscal_isles", BYGEndBiomes.viscalIsles());
    public static class_5321<class_1959> BULBIS_GARDENS = BYGBiomes.createBiome("bulbis_gardens", BYGEndBiomes.bulbisGardens());
    public static class_5321<class_1959> SHULKREN_FOREST = BYGBiomes.createBiome("shulkren_forest", BYGEndBiomes.shulkrenForest());
    public static class_5321<class_1959> CRYPTIC_WASTES = BYGBiomes.createBiome("cryptic_wastes", BYGEndBiomes.crypticWastes());
    public static class_5321<class_1959> IMPARIUS_GROVE = BYGBiomes.createBiome("imparius_grove", BYGEndBiomes.impariusGrove());

    public static class_5321<class_1959> createBiome(String id, class_1959 biome) {
        class_2960 bygID = BYG.createLocation(id);
        if (class_5458.field_25933.method_10235().contains(bygID)) {
            throw new IllegalStateException("Biome ID: \"" + bygID.toString() + "\" already exists in the Biome registry!");
        }
        BIOMES.add(new RegistryObject<class_1959>(biome, id));
        return class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)bygID);
    }

    public static void bootStrap(Consumer<Collection<RegistryObject<class_1959>>> registryStrategy) {
        registryStrategy.accept(BIOMES);
    }

    public static Collection<RegistryObject<class_1959>> bootStrap() {
        return BIOMES;
    }

    public static void addBYGFeaturesToBiomes(class_1959 biome, class_5321<class_1959> biomeKey) {
        class_2960 locationKey = biomeKey.method_29177();
        if (biome.method_8688() != class_1959.class_1961.field_9366 && biome.method_8688() != class_1959.class_1961.field_9360 && biome.method_8688() != class_1959.class_1961.field_9371) {
            if (locationKey.equals((Object)class_1972.field_22076.method_29177())) {
                // empty if block
            }
            if (biome.method_8688() != class_1959.class_1961.field_9363 || biome.method_8712() > 0.15f) {
                // empty if block
            }
            if (biome.method_8688() == class_1959.class_1961.field_9366 || biome.method_8688() == class_1959.class_1961.field_9360 || biome.method_8688() != class_1959.class_1961.field_9371) {
                // empty if block
            }
        }
    }

    public static void addFeatureToBiomeFirst(class_1959 biome, class_2975<?, ?> configuredFeature) {
        BYGBiomes.convertImmutableFeatures(biome);
        List<List<Supplier<class_2975<?, ?>>>> biomeFeatures = ((BiomeGenerationSettingsAccess)biome.method_30970()).getFeatures();
        List<Supplier<class_2975<?, ?>>> suppliers = biomeFeatures.get(class_2893.class_2895.field_13174.ordinal());
        ArrayList suppliersCopy = new ArrayList(suppliers);
        suppliers.clear();
        suppliers.add(() -> configuredFeature);
        suppliers.addAll(suppliersCopy);
    }

    public static void addFeatureToBiome(class_1959 biome, class_2893.class_2895 feature, class_2975<?, ?> configuredFeature) {
        BYGBiomes.convertImmutableFeatures(biome);
        List<List<Supplier<class_2975<?, ?>>>> biomeFeatures = ((BiomeGenerationSettingsAccess)biome.method_30970()).getFeatures();
        while (biomeFeatures.size() <= feature.ordinal()) {
            biomeFeatures.add(Lists.newArrayList());
        }
        biomeFeatures.get(feature.ordinal()).add(() -> configuredFeature);
    }

    private static void convertImmutableFeatures(class_1959 biome) {
        List<List<Supplier<class_2975<?, ?>>>> features = ((BiomeGenerationSettingsAccess)biome.method_30970()).getFeatures();
        if (features instanceof ImmutableList) {
            ((BiomeGenerationSettingsAccess)biome.method_30970()).setFeatures(features.stream().map(Lists::newArrayList).collect(Collectors.toList()));
        }
    }
}

