/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import potionstudios.byg.common.BYGCarvableBlocks;
import potionstudios.byg.common.BYGCompostables;
import potionstudios.byg.common.BYGFlammables;
import potionstudios.byg.common.BYGFlattenables;
import potionstudios.byg.common.BYGHoeables;
import potionstudios.byg.common.BYGStrippables;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.entity.villager.BYGVillagerType;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.mixin.access.BlockEntityTypeAccess;
import potionstudios.byg.mixin.access.DeltaFeatureAccess;
import potionstudios.byg.util.CommonSetupLoad;
import potionstudios.byg.util.MLBlockTags;
import potionstudios.byg.util.ModLoaderContext;

public class BYG {
    public static final String MOD_ID = "byg";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final boolean BIOMES = true;
    public static final boolean WARN_EXPERIMENTAL = true;
    public static final int EXPERIMENTAL_WARNING_VERSION = 3;
    public static boolean ENABLE_OVERWORLD_TREES = true;
    public static boolean ENABLE_CACTI = true;
    public static boolean ENABLE_NYLIUM_FUNGI = true;
    public static boolean ENABLE_NETHER_MUSHROOMS = true;
    public static Path CONFIG_PATH = null;
    public static String MOD_LOADER_TAG_TARGET = null;
    public static ModLoaderContext MODLOADER_DATA = null;

    public static void init(Path path, String modloaderTagTarget) {
        CONFIG_PATH = path;
        MOD_LOADER_TAG_TARGET = modloaderTagTarget;
        MLBlockTags.bootStrap();
    }

    public static void commonLoad() {
        LOGGER.debug("BYG: \"Common Setup\" Event Starting...");
        CommonSetupLoad.ENTRIES.forEach(CommonSetupLoad::load);
        try {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
            Files.write(CONFIG_PATH.resolve("README.txt"), "For information on how BYG configs work, you can find that here: https://github.com/AOCAWOL/BYG/wiki/Configs".getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        EndBiomesConfig.getConfig(true);
        NetherBiomesConfig.getConfig(true);
        LOGGER.info("BYG: \"Common Setup\" Event Complete!");
    }

    public static void threadSafeCommonLoad() {
        BYGVillagerType.setVillagerForBYGBiomes();
        BlockEntityTypeAccess builderAccess = (BlockEntityTypeAccess)class_2591.field_17380;
        ObjectOpenHashSet validBlocks = new ObjectOpenHashSet(builderAccess.getValidBlocks());
        validBlocks.add(BYGBlocks.CRYPTIC_CAMPFIRE);
        validBlocks.add(BYGBlocks.BORIC_CAMPFIRE);
        builderAccess.setValidBlocks((Set<class_2248>)validBlocks);
        DeltaFeatureAccess.setCANNOT_REPLACE((ImmutableList<class_2248>)new ImmutableList.Builder().addAll(DeltaFeatureAccess.getCANNOT_REPLACE()).add((Object)class_2246.field_10335).add((Object)class_2246.field_10306).add((Object)class_2246.field_10503).add((Object)class_2246.field_10431).add((Object)BYGBlocks.RAINBOW_EUCALYPTUS_LOG).add((Object)BYGBlocks.RAINBOW_EUCALYPTUS_LEAVES).add((Object)BYGBlocks.EMBUR_GEL_BLOCK).add((Object)BYGBlocks.EMBUR_GEL_BRANCH).add((Object)BYGBlocks.EMBUR_GEL_VINES).add((Object)BYGBlocks.EMBUR_GEL_VINES_PLANT).add((Object)class_2246.field_10597).build());
    }

    public static void clientLoad() {
        LOGGER.debug("BYG: \"Client Setup\" Event Starting...");
        LOGGER.info("BYG: \"Client Setup\" Event Complete!");
    }

    public static void threadSafeLoadFinish() {
        LOGGER.debug("BYG: \"Load Complete Event\" Starting...");
        BYGCompostables.compostablesBYG();
        BYGHoeables.tillablesBYG();
        BYGFlammables.flammablesBYG();
        BYGStrippables.strippableLogsBYG();
        BYGCarvableBlocks.addCarverBlocks();
        BYGFlattenables.addFlattenables();
        LOGGER.info("BYG: \"Load Complete\" Event Complete!");
    }

    public static class_2960 createLocation(String path) {
        return new class_2960(MOD_ID, path);
    }
}

