/*
 * Decompiled with CFR 0.152.
 */
package ninjaphenix.container_library.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_768;
import ninjaphenix.container_library.api.client.function.ScreenSize;
import ninjaphenix.container_library.api.client.gui.AbstractScreen;
import ninjaphenix.container_library.api.client.gui.TexturedRect;
import ninjaphenix.container_library.api.inventory.AbstractHandler;
import org.jetbrains.annotations.NotNull;

public final class SingleScreen
extends AbstractScreen {
    private final Set<TexturedRect> blankArea = new HashSet<TexturedRect>();
    private final class_2960 textureLocation;
    private final int textureWidth;
    private final int textureHeight;
    private final int blankSlots;

    public SingleScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        this.textureLocation = new class_2960("ninjaphenix_container_lib", "textures/gui/container/shared_" + this.inventoryWidth + "_" + this.inventoryHeight + ".png");
        this.textureWidth = switch (this.inventoryWidth) {
            case 9 -> {
                if (this.inventoryHeight == 3) {
                    yield 176;
                }
                yield 208;
            }
            case 12 -> 256;
            case 15 -> 320;
            case 18 -> 368;
            default -> throw new IllegalStateException("Unexpected value: " + this.inventoryWidth);
        };
        this.textureHeight = switch (this.inventoryHeight) {
            case 3 -> 192;
            case 6 -> 240;
            case 9 -> 304;
            case 12 -> 352;
            case 15 -> 416;
            default -> throw new IllegalStateException("Unexpected value: " + this.inventoryHeight);
        };
        this.blankSlots = this.inventoryWidth * this.inventoryHeight - this.totalSlots;
        this.field_2792 = 7 + 18 * this.inventoryWidth + 7;
        this.field_2779 = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.blankSlots > 0) {
            this.blankArea.clear();
            int rows = class_3532.method_15346((int)this.blankSlots, (int)this.inventoryWidth);
            int remainder = this.blankSlots - this.inventoryWidth * rows;
            int yTop = this.field_2800 + 17 + (this.inventoryHeight - 1) * 18;
            int xLeft = this.field_2776 + 7;
            for (int i = 0; i < rows; ++i) {
                this.blankArea.add(new TexturedRect(xLeft, yTop, this.inventoryWidth * 18, 18, 7, this.field_2779, this.textureWidth, this.textureHeight));
                yTop -= 18;
            }
            if (remainder > 0) {
                int xRight = this.field_2776 + 7 + this.inventoryWidth * 18;
                int width = remainder * 18;
                this.blankArea.add(new TexturedRect(xRight - width, yTop, width, 18, 7, this.field_2779, this.textureWidth, this.textureHeight));
            }
        }
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.field_2792 - 176) / 2)) || mouseX > (double)(left + this.field_2792 - outsideRegion))) {
            return true;
        }
        return super.method_2381(mouseX, mouseY, left, top, button);
    }

    protected void method_2389(class_4587 stack, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.textureLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_332.method_25290((class_4587)stack, (int)this.field_2776, (int)this.field_2800, (float)0.0f, (float)0.0f, (int)this.field_2792, (int)this.field_2779, (int)this.textureWidth, (int)this.textureHeight);
        this.blankArea.forEach(image -> image.render(stack));
    }

    protected void method_2388(class_4587 stack, int mouseX, int mouseY) {
        this.field_22793.method_30883(stack, this.field_22785, 8.0f, 6.0f, 0x404040);
        this.field_22793.method_30883(stack, this.field_29347, 8.0f, (float)(this.field_2779 - 96 + 2), 0x404040);
    }

    private void initializeSlots(class_1661 playerInventory) {
        int y;
        for (int i = 0; i < ((AbstractHandler)this.field_2797).getInventory().method_5439(); ++i) {
            int x = i % this.inventoryWidth;
            y = (i - x) / this.inventoryWidth;
            ((AbstractHandler)this.field_2797).addClientSlot(new class_1735(((AbstractHandler)this.field_2797).getInventory(), i, x * 18 + 8, y * 18 + 18));
        }
        int left = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int top = 32 + this.inventoryHeight * 18;
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.field_2797).addClientSlot(new class_1735((class_1263)playerInventory, y * 9 + x + 9, left + 18 * x, top + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.field_2797).addClientSlot(new class_1735((class_1263)playerInventory, x, left + 18 * x, top + 58));
        }
    }

    @Override
    @NotNull
    public List<class_768> getExclusionZones() {
        return Collections.emptyList();
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        int width;
        if (slots <= 81) {
            width = 9;
        } else if (slots <= 108) {
            width = 12;
        } else if (slots <= 135) {
            width = 15;
        } else if (slots <= 270) {
            width = 18;
        } else {
            return null;
        }
        int height = slots <= 27 ? 3 : (slots <= 54 ? 6 : (slots <= 162 ? 9 : (slots <= 216 ? 12 : 15)));
        return ScreenSize.of(width, height);
    }
}

