/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ContainerScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.mixin.SlotAccessor;
import net.blay09.mods.trashslot.PlatformBindings;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.TrashSlotSaveState;
import net.blay09.mods.trashslot.api.IGuiContainerLayout;
import net.blay09.mods.trashslot.client.ContainerSettings;
import net.blay09.mods.trashslot.client.LayoutManager;
import net.blay09.mods.trashslot.client.ModKeyMappings;
import net.blay09.mods.trashslot.client.TrashSlotSlot;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.blay09.mods.trashslot.client.gui.TrashSlotComponent;
import net.blay09.mods.trashslot.config.TrashSlotConfig;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5348;
import net.minecraft.class_746;

public class TrashSlotGuiHandler {
    private static final TrashSlotSlot trashSlot = new TrashSlotSlot();
    private static TrashSlotComponent trashSlotComponent;
    private static ContainerSettings currentContainerSettings;
    private static boolean ignoreMouseUp;
    private static boolean sentMissingMessage;
    private static long missingMessageTime;
    private static boolean isLeftMouseDown;

    public static void initialize() {
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, TrashSlotGuiHandler::onScreenInit);
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, TrashSlotGuiHandler::onMouseRelease);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, TrashSlotGuiHandler::onMouseClick);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Post.class, TrashSlotGuiHandler::onKeyPress);
        Balm.getEvents().onEvent(ContainerScreenDrawEvent.Background.class, TrashSlotGuiHandler::onBackgroundDrawn);
        Balm.getEvents().onEvent(ContainerScreenDrawEvent.Background.class, TrashSlotGuiHandler::onScreenDrawn);
    }

    private static void onScreenInit(ScreenInitEvent.Post event) {
        if (event.getScreen() instanceof class_481) {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
            return;
        }
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            if (!TrashSlot.isServerSideInstalled && !sentMissingMessage) {
                TrashSlot.logger.info("TrashSlot is not installed on the server and thus will be unavailable.");
                missingMessageTime = System.currentTimeMillis();
                sentMissingMessage = true;
                return;
            }
            if (screen instanceof class_490 && class_310.method_1551().field_1724.method_31549().field_7477) {
                return;
            }
            IGuiContainerLayout layout = LayoutManager.getLayout(screen);
            currentContainerSettings = TrashSlotSaveState.getSettings(screen, layout);
            trashSlotComponent = currentContainerSettings != ContainerSettings.NONE ? new TrashSlotComponent(screen, layout, currentContainerSettings, trashSlot) : null;
        } else {
            currentContainerSettings = ContainerSettings.NONE;
            trashSlotComponent = null;
        }
    }

    private static void onMouseRelease(ScreenMouseEvent.Release.Pre event) {
        if (event.getButton() == 0) {
            isLeftMouseDown = false;
        }
        if (ignoreMouseUp) {
            event.setCanceled(true);
            ignoreMouseUp = false;
        }
    }

    private static void onMouseClick(ScreenMouseEvent.Click.Pre event) {
        DeletionProvider deletionProvider;
        if (event.getButton() == 0) {
            isLeftMouseDown = true;
        }
        if ((deletionProvider = TrashSlotConfig.getDeletionProvider()) == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        int mouseButton = event.getButton();
        if (TrashSlotGuiHandler.runKeyBindings(event.getScreen(), class_3675.class_307.field_1672, mouseButton, 0)) {
            event.setCanceled(true);
            return;
        }
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_465) {
            double mouseY;
            class_465 screen = (class_465)class_4372;
            double mouseX = event.getMouseX();
            if (((AbstractContainerScreenAccessor)screen).callIsHovering((class_1735)trashSlot, mouseX, mouseY = event.getMouseY())) {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    boolean isRightClick;
                    class_1799 mouseItem = screen.method_17577().method_34255();
                    boolean bl = isRightClick = mouseButton == 1;
                    if (mouseItem.method_7960()) {
                        deletionProvider.undeleteLast((class_1657)player, trashSlot, isRightClick);
                    } else {
                        deletionProvider.deleteMouseItem((class_1657)player, mouseItem, trashSlot, isRightClick);
                    }
                    event.setCanceled(true);
                    ignoreMouseUp = true;
                }
            } else if (trashSlotComponent.isInside((int)mouseX, (int)mouseY)) {
                event.setCanceled(true);
                ignoreMouseUp = true;
            }
        }
    }

    private static void onKeyPress(ScreenKeyEvent.Press.Post event) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return;
        }
        int keyCode = event.getKey();
        int scanCode = event.getScanCode();
        class_3675.class_306 input = class_3675.method_15985((int)keyCode, (int)scanCode);
        if (TrashSlotGuiHandler.runKeyBindings(event.getScreen(), input.method_1442(), keyCode, scanCode)) {
            event.setCanceled(true);
        }
    }

    private static boolean runKeyBindings(class_437 screen, class_3675.class_307 type, int keyCode, int scanCode) {
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null) {
            return false;
        }
        if (currentContainerSettings.isEnabled()) {
            class_746 entityPlayer;
            boolean isDelete = BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindDelete, type, keyCode, scanCode);
            boolean isDeleteAll = BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindDeleteAll, type, keyCode, scanCode);
            if (isDelete && isDeleteAll && !PlatformBindings.INSTANCE.supportsKeyModifiers()) {
                isDelete = !class_437.method_25442();
                isDeleteAll = class_437.method_25442();
            }
            if ((isDelete || isDeleteAll) && (entityPlayer = class_310.method_1551().field_1724) != null && screen instanceof class_465) {
                class_465 containerScreen = (class_465)screen;
                class_1735 mouseSlot = ((AbstractContainerScreenAccessor)containerScreen).getHoveredSlot();
                if (mouseSlot != null && mouseSlot.method_7681()) {
                    deletionProvider.deleteContainerItem(containerScreen.method_17577(), mouseSlot.field_7874, isDeleteAll, trashSlot);
                } else {
                    double mouseY;
                    class_1041 mainWindow = class_310.method_1551().method_22683();
                    double rawMouseX = class_310.method_1551().field_1729.method_1603();
                    double rawMouseY = class_310.method_1551().field_1729.method_1604();
                    double mouseX = rawMouseX * (double)mainWindow.method_4486() / (double)mainWindow.method_4489();
                    if (((AbstractContainerScreenAccessor)containerScreen).callIsHovering((class_1735)trashSlot, mouseX, mouseY = rawMouseY * (double)mainWindow.method_4502() / (double)mainWindow.method_4506())) {
                        deletionProvider.emptyTrashSlot(trashSlot);
                    }
                }
                return true;
            }
        }
        if (screen instanceof class_465 && currentContainerSettings != ContainerSettings.NONE && BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBindToggleSlot, type, keyCode, scanCode)) {
            currentContainerSettings.setEnabled(!currentContainerSettings.isEnabled());
            TrashSlotSaveState.save();
            return true;
        }
        return false;
    }

    public static void onBackgroundDrawn(ContainerScreenDrawEvent.Background event) {
        class_4587 poseStack = event.getPoseStack();
        DeletionProvider deletionProvider = TrashSlotConfig.getDeletionProvider();
        if (deletionProvider == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        class_437 class_4372 = event.getScreen();
        if (class_4372 instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            if (trashSlotComponent != null) {
                trashSlotComponent.update(event.getMouseX(), event.getMouseY());
                trashSlotComponent.drawBackground(poseStack);
                if (((AbstractContainerScreenAccessor)screen).callIsHovering((class_1735)trashSlot, (double)event.getMouseX(), (double)event.getMouseY())) {
                    poseStack.method_22903();
                    poseStack.method_22904((double)((AbstractContainerScreenAccessor)screen).getLeftPos(), (double)((AbstractContainerScreenAccessor)screen).getTopPos(), 0.0);
                    class_465.method_33285((class_4587)poseStack, (int)TrashSlotGuiHandler.trashSlot.field_7873, (int)TrashSlotGuiHandler.trashSlot.field_7872, (int)screen.method_25305());
                    poseStack.method_22909();
                }
            }
        }
    }

    public static void onScreenDrawn(ContainerScreenDrawEvent.Background event) {
        DeletionProvider deletionProvider;
        class_437 class_4372;
        class_4587 poseStack = event.getPoseStack();
        if (missingMessageTime != 0L && System.currentTimeMillis() - missingMessageTime < 3000L && (class_4372 = event.getScreen()) instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            class_2588 noHabloEspanol = new class_2588("trashslot.serverNotInstalled");
            noHabloEspanol.method_27692(class_124.field_1061);
            screen.method_30901(poseStack, (List)Lists.newArrayList((Object[])new class_2561[]{noHabloEspanol}), ((AbstractContainerScreenAccessor)screen).getLeftPos() + ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2 - class_310.method_1551().field_1772.method_27525((class_5348)noHabloEspanol) / 2, 25);
        }
        if ((deletionProvider = TrashSlotConfig.getDeletionProvider()) == null || !currentContainerSettings.isEnabled()) {
            return;
        }
        class_437 class_4373 = event.getScreen();
        if (class_4373 instanceof class_465) {
            class_465 screen = (class_465)class_4373;
            if (trashSlotComponent != null) {
                TrashSlotSlot trashSlot = TrashSlotGuiHandler.trashSlot;
                SlotAccessor slotAccessor = (SlotAccessor)trashSlot;
                slotAccessor.setX(trashSlot.field_7873 + ((AbstractContainerScreenAccessor)screen).getLeftPos());
                slotAccessor.setY(trashSlot.field_7872 + ((AbstractContainerScreenAccessor)screen).getTopPos());
                ((AbstractContainerScreenAccessor)screen).callRenderSlot(poseStack, (class_1735)trashSlot);
                slotAccessor.setX(trashSlot.field_7873 - ((AbstractContainerScreenAccessor)screen).getLeftPos());
                slotAccessor.setY(trashSlot.field_7872 - ((AbstractContainerScreenAccessor)screen).getTopPos());
                boolean isMouseSlot = ((AbstractContainerScreenAccessor)screen).callIsHovering((class_1735)trashSlot, (double)event.getMouseX(), (double)event.getMouseY());
                if (isMouseSlot && screen.method_17577().method_34255().method_7960() && trashSlot.method_7681()) {
                    screen.method_30901(poseStack, screen.method_25408(trashSlot.method_7677()), event.getMouseX(), event.getMouseY());
                }
            }
        }
    }

    public static TrashSlotComponent getTrashSlotComponent() {
        return trashSlotComponent;
    }

    public static TrashSlotSlot getTrashSlot() {
        return trashSlot;
    }

    public static boolean isLeftMouseDown() {
        return isLeftMouseDown;
    }

    static {
        currentContainerSettings = ContainerSettings.NONE;
    }
}

