/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.config.ModMenuConfigManager;
import com.terraformersmc.modmenu.event.ModMenuEventHandler;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.fabric.FabricDummyParentMod;
import com.terraformersmc.modmenu.util.mod.fabric.FabricMod;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModMenu
implements ClientModInitializer {
    public static final String MOD_ID = "modmenu";
    public static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu");
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    public static final Map<String, Mod> MODS = new HashMap<String, Mod>();
    public static final Map<String, Mod> ROOT_MODS = new HashMap<String, Mod>();
    public static final LinkedListMultimap<Mod, Mod> PARENT_MAP = LinkedListMultimap.create();
    private static ImmutableMap<String, ConfigScreenFactory<?>> configScreenFactories = ImmutableMap.of();
    private static List<Supplier<Map<String, ConfigScreenFactory<?>>>> dynamicScreenFactories = new ArrayList();
    private static int cachedDisplayedModCount = -1;

    public static class_437 getConfigScreen(String modid, class_437 menuScreen) {
        ConfigScreenFactory<?> factory = (ConfigScreenFactory<?>)configScreenFactories.get((Object)modid);
        if (factory != null) {
            return factory.create(menuScreen);
        }
        for (Supplier<Map<String, ConfigScreenFactory<?>>> dynamicFactoriesSupplier : dynamicScreenFactories) {
            factory = dynamicFactoriesSupplier.get().get(modid);
            if (factory == null) continue;
            return factory.create(menuScreen);
        }
        return null;
    }

    public void onInitializeClient() {
        ModMenuConfigManager.initializeConfig();
        HashMap factories = new HashMap();
        FabricLoader.getInstance().getEntrypointContainers(MOD_ID, ModMenuApi.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                ModMenuApi api = (ModMenuApi)entrypoint.getEntrypoint();
                factories.put(modId, api.getModConfigScreenFactory());
                dynamicScreenFactories.add(api::getProvidedConfigScreenFactories);
            }
            catch (Throwable e) {
                LOGGER.error("Mod {} provides a broken implementation of ModMenuApi", (Object)modId, (Object)e);
            }
        });
        configScreenFactories = ImmutableMap.copyOf(factories);
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            if (ModMenuConfig.HIDDEN_MODS.getValue().contains(modContainer.getMetadata().getId())) continue;
            Mod mod = new FabricMod(modContainer);
            MODS.put(((FabricMod)mod).getId(), mod);
        }
        HashMap<String, Mod> dummyParents = new HashMap<String, Mod>();
        for (Mod mod : MODS.values()) {
            String parentId = mod.getParent();
            if (parentId != null) {
                Mod parent = MODS.getOrDefault(parentId, (Mod)dummyParents.get(parentId));
                if (parent == null && mod instanceof FabricMod) {
                    parent = new FabricDummyParentMod((FabricMod)mod, parentId);
                    dummyParents.put(parentId, parent);
                }
                PARENT_MAP.put((Object)parent, (Object)mod);
                continue;
            }
            ROOT_MODS.put(mod.getId(), mod);
        }
        MODS.putAll(dummyParents);
        ModMenuEventHandler.register();
    }

    public static void clearModCountCache() {
        cachedDisplayedModCount = -1;
    }

    public static String getDisplayedModCount() {
        if (cachedDisplayedModCount == -1) {
            cachedDisplayedModCount = Math.toIntExact(MODS.values().stream().filter(mod -> !(!ModMenuConfig.COUNT_CHILDREN.getValue() && mod.getParent() != null || !ModMenuConfig.COUNT_LIBRARIES.getValue() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY) || !ModMenuConfig.COUNT_HIDDEN_MODS.getValue() && ModMenuConfig.HIDDEN_MODS.getValue().contains(mod.getId()))).count());
        }
        return NumberFormat.getInstance().format(cachedDisplayedModCount);
    }

    public static class_2561 createModsButtonText() {
        class_2588 modsText = new class_2588("modmenu.title");
        if (ModMenuConfig.MOD_COUNT_LOCATION.getValue().isOnModsButton() && ModMenuConfig.MODS_BUTTON_STYLE.getValue() != ModMenuConfig.ModsButtonStyle.ICON) {
            String count = ModMenu.getDisplayedModCount();
            if (ModMenuConfig.MODS_BUTTON_STYLE.getValue() == ModMenuConfig.ModsButtonStyle.SHRINK) {
                modsText.method_10852((class_2561)new class_2585(" ")).method_10852((class_2561)new class_2588("modmenu.loaded.short", new Object[]{count}));
            } else {
                Object key;
                String specificKey = "modmenu.loaded." + count;
                Object object = key = class_1074.method_4663((String)specificKey) ? specificKey : "modmenu.loaded";
                if (ModMenuConfig.EASTER_EGGS.getValue() && class_1074.method_4663((String)(specificKey + ".secret"))) {
                    key = specificKey + ".secret";
                }
                modsText.method_10852((class_2561)new class_2585(" ")).method_10852((class_2561)new class_2588((String)key, new Object[]{count}));
            }
        }
        return modsText;
    }
}

