/*
 * Decompiled with CFR 0.152.
 */
package maybemoredata.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import maybemoredata.data.Condition;
import maybemoredata.mixin.LootManagerAccessor;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5350;
import net.minecraft.class_60;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConditionalLootManager
extends class_60 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = class_5270.method_27862().create();
    private final class_5350 manager;

    public ConditionalLootManager(class_5350 manager) {
        super(manager.method_29468());
        this.manager = manager;
    }

    public void method_20712(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        HashMap<class_2960, JsonElement> valid = new HashMap<class_2960, JsonElement>();
        map.forEach((identifier, jsonElement) -> {
            JsonObject obj;
            Condition condition;
            if (jsonElement instanceof JsonObject && (condition = (Condition)GSON.fromJson((obj = (JsonObject)jsonElement).get("condition"), Condition.class)).verify()) {
                valid.put((class_2960)identifier, obj.get("loot_table"));
            }
        });
        Map<class_2960, class_52> existing = ((LootManagerAccessor)this.manager.method_29469()).getTable();
        ImmutableMap<class_2960, class_52> parsed = this.parse(valid);
        ((LootManagerAccessor)this.manager.method_29469()).setTable((Map<class_2960, class_52>)ImmutableMap.builder().putAll(existing).putAll(parsed).build());
    }

    public ImmutableMap<class_2960, class_52> parse(Map<class_2960, JsonElement> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 identifier = entry.getKey();
            try {
                class_52 lootTable = (class_52)GSON.fromJson(entry.getValue(), class_52.class);
                builder.put((Object)identifier, (Object)lootTable);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error("Parsing error loading conditional loot table {}", (Object)identifier, (Object)exception);
            }
        }
        ImmutableMap tables = builder.build();
        LOGGER.info("Loaded {} conditional loot tables", (Object)tables.size());
        return tables;
    }
}

