/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config.screen.items.lists;

import java.util.ArrayList;
import java.util.List;
import net.kyrptonaught.kyrptconfig.config.screen.NotSuckyButton;
import net.kyrptonaught.kyrptconfig.config.screen.items.ConfigItem;
import net.kyrptonaught.kyrptconfig.config.screen.items.SubItem;
import net.kyrptonaught.kyrptconfig.config.screen.items.lists.entries.ListStringEntry;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class StringList
extends SubItem<List<String>> {
    protected NotSuckyButton addButton;
    protected NotSuckyButton clearButton;

    public StringList(class_2561 name, List<String> value, List<String> defaultValue) {
        this(name, value, defaultValue, true);
    }

    public StringList(class_2561 name, List<String> value, List<String> defaultValue, Boolean autoPop) {
        super(name, false);
        this.value = value;
        this.defaultValue = defaultValue;
        if (autoPop.booleanValue()) {
            this.populateFromList();
        }
        this.addButton = new NotSuckyButton(0, 0, 35, 20, (class_2561)new class_2588("key.kyrptconfig.config.add"), widget -> this.addConfigItem(this.createNewEntry("")));
        this.clearButton = new NotSuckyButton(0, 0, 35, 20, (class_2561)new class_2588("key.kyrptconfig.config.clear"), widget -> this.setValue((List<String>)new ArrayList<String>()));
        this.useDefaultResetBTN();
    }

    public StringList setExpanded(boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    @Override
    public void setValue(List<String> value) {
        super.setValue(value);
        this.configs.forEach(configItem -> {
            if (configItem instanceof ListStringEntry) {
                ListStringEntry stringListEntry = (ListStringEntry)configItem;
                stringListEntry.setDeleted(true);
            }
        });
        this.populateFromList();
    }

    public void populateFromList() {
        for (String s : (List)this.value) {
            this.addConfigItem(this.createNewEntry(s));
        }
    }

    public ListStringEntry createNewEntry(String string) {
        return new ListStringEntry(string);
    }

    public List<String> getNewValues() {
        ArrayList<String> newValues = new ArrayList<String>();
        this.configs.forEach(configItem -> {
            ListStringEntry stringListEntry;
            String result;
            if (configItem instanceof ListStringEntry && (result = (stringListEntry = (ListStringEntry)configItem).getValue()) != null) {
                newValues.add(result);
            }
        });
        return newValues;
    }

    @Override
    public boolean isValueDefault() {
        return this.getNewValues().equals(this.defaultValue);
    }

    @Override
    protected void runSaveConsumer(List<String> value) {
        super.runSaveConsumer(this.getNewValues());
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        if (this.expanded && (this.addButton.method_25402(mouseX, mouseY, button) || this.clearButton.method_25402(mouseX, mouseY, button)) || this.resetButton.method_25402(mouseX, mouseY, button)) {
            return;
        }
        super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void render(class_4587 matrices, int x, int y, int mouseX, int mouseY, float delta) {
        super.render(matrices, x, y, mouseX, mouseY, delta);
        class_310.method_1551().field_1772.method_1729(matrices, this.expanded ? "-" : "+", (float)(x - 10), (float)(y + 5), 0xFFFFFF);
        this.subStart = y;
        if (this.expanded) {
            this.clearButton.field_22761 = y;
            this.clearButton.field_22760 = this.resetButton.field_22760 - this.clearButton.method_25368() / 2 - 20;
            this.clearButton.method_25394(matrices, mouseX, mouseY, delta);
            this.addButton.field_22761 = y;
            this.addButton.field_22760 = this.clearButton.field_22760 - this.addButton.method_25368() / 2 - 20;
            this.addButton.method_25394(matrices, mouseX, mouseY, delta);
            int runningY = this.subStart + 23;
            for (ConfigItem item : this.configs) {
                item.render(matrices, 30, runningY, mouseX, mouseY, delta);
                runningY += item.getSize() + 3;
            }
        }
    }
}

