/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import net.kyrptonaught.kyrptconfig.config.AbstractConfigFile;
import net.kyrptonaught.kyrptconfig.config.ConfigWDefaults;

public class ConfigStorage {
    private final File saveFile;
    public AbstractConfigFile config;
    private final AbstractConfigFile defaultConfig;

    public ConfigStorage(File fileName, AbstractConfigFile defaultConfig) {
        this.saveFile = fileName;
        this.defaultConfig = defaultConfig;
    }

    public void save(String MOD_ID, Jankson JANKSON) {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.saveFile, false), StandardCharsets.UTF_8);){
            if (!this.saveFile.exists()) {
                this.saveFile.createNewFile();
            }
            if (this.config instanceof ConfigWDefaults) {
                ((ConfigWDefaults)this.config).beforeSave();
            }
            String json = JANKSON.toJson((Object)this.config).toJson(true, true, 0);
            out.write(json);
        }
        catch (Exception e) {
            System.out.println(MOD_ID + " Failed to save " + this.saveFile.getName());
        }
    }

    public AbstractConfigFile load(String MOD_ID, Jankson JANKSON) {
        if (!this.saveFile.exists() || !this.saveFile.canRead()) {
            System.out.println(MOD_ID + " Config not found! Creating one.");
            this.config = this.defaultConfig;
        }
        boolean failed = false;
        try {
            JsonObject configJson = JANKSON.load(this.saveFile);
            String regularized = configJson.toJson(false, false, 0);
            this.config = (AbstractConfigFile)JANKSON.fromJson(regularized, this.defaultConfig.getClass());
            if (this.config instanceof ConfigWDefaults) {
                ((ConfigWDefaults)this.config).DEFAULTS = this.defaultConfig;
                ((ConfigWDefaults)this.config).afterLoad();
            }
        }
        catch (Exception e) {
            failed = true;
        }
        if (failed || this.config == null) {
            System.out.println(MOD_ID + " Failed to load config! Overwriting with default config.");
            this.config = this.defaultConfig;
        }
        return this.config;
    }
}

