/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.kyrptconfig.config;

import blue.endless.jankson.Jankson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.kyrptonaught.kyrptconfig.config.AbstractConfigFile;
import net.kyrptonaught.kyrptconfig.config.ConfigStorage;
import net.kyrptonaught.kyrptconfig.keybinding.CustomKeyBinding;

public class ConfigManager {
    private final Jankson JANKSON;
    private final HashMap<String, ConfigStorage> configs = new HashMap();
    protected File dir;
    protected String MOD_ID;

    private ConfigManager(String mod_id) {
        this.MOD_ID = mod_id;
        this.dir = FabricLoader.getInstance().getConfigDirectory();
        this.JANKSON = Jankson.builder().registerSerializer(CustomKeyBinding.class, CustomKeyBinding::saveKeybinding).registerDeserializer(String.class, CustomKeyBinding.class, CustomKeyBinding::loadKeybinding).build();
    }

    public AbstractConfigFile getConfig(String name) {
        if (!((String)name).endsWith(".json5")) {
            name = (String)name + ".json5";
        }
        return this.configs.get((Object)name).config;
    }

    public void registerFile(String name, AbstractConfigFile defaultConfig) {
        if (!((String)name).endsWith(".json5")) {
            name = (String)name + ".json5";
        }
        this.configs.put((String)name, new ConfigStorage(new File(this.dir, (String)name), defaultConfig));
    }

    public void save() {
        this.configs.values().forEach(configStorage -> configStorage.save(this.MOD_ID, this.JANKSON));
    }

    public void load() {
        this.configs.values().forEach(configStorage -> configStorage.load(this.MOD_ID, this.JANKSON));
        this.save();
    }

    public static class MultiConfigManager
    extends ConfigManager {
        public MultiConfigManager(String mod_id) {
            super(mod_id);
            this.dir = new File(FabricLoader.getInstance().getConfigDirectory() + "/" + this.MOD_ID);
            if (!Files.exists(this.dir.toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectories(this.dir.toPath(), new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static class SingleConfigManager
    extends ConfigManager {
        public SingleConfigManager(String mod_id, AbstractConfigFile defaultConfig) {
            super(mod_id);
            this.dir = FabricLoader.getInstance().getConfigDirectory();
            this.registerFile(mod_id + "config", defaultConfig);
        }

        public AbstractConfigFile getConfig() {
            return this.getConfig(this.MOD_ID + "config");
        }
    }
}

