/*
 * Decompiled with CFR 0.152.
 */
package me.steven.wirelessnetworks.network;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.steven.wirelessnetworks.network.Network;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.server.MinecraftServer;

public class NetworkState
extends class_18 {
    public static final String KEY = "wireless_networks";
    private final Map<String, Network> networks = new HashMap<String, Network>();

    public Optional<Network> getNetworkHandler(String id) {
        if (!this.networks.containsKey(id)) {
            return Optional.empty();
        }
        return Optional.of(this.networks.get(id));
    }

    public Network getOrCreateNetworkHandler(String id, UUID uuid) {
        return this.networks.computeIfAbsent(id, n -> new Network(id, uuid));
    }

    public Network delete(String id) {
        return this.networks.remove(id);
    }

    public void put(String id, Network network) {
        this.networks.put(id, network);
    }

    public Map<String, Network> getNetworks() {
        return ImmutableMap.copyOf(this.networks);
    }

    public static NetworkState fromNbt(class_2487 tag) {
        NetworkState state = new NetworkState();
        class_2499 list = tag.method_10554("Networks", 10);
        list.forEach(networkTag -> {
            Network network = Network.fromTag((class_2487)networkTag);
            state.networks.put(network.getId(), network);
        });
        return state;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 list = new class_2499();
        this.networks.forEach((id, network) -> list.add((Object)network.toTag()));
        tag.method_10566("Networks", (class_2520)list);
        return tag;
    }

    public static NetworkState getOrCreate(MinecraftServer server) {
        return (NetworkState)server.method_30002().method_17983().method_17924(NetworkState::fromNbt, NetworkState::new, KEY);
    }
}

