/*
 * Decompiled with CFR 0.152.
 */
package me.steven.wirelessnetworks.network;

import java.util.UUID;
import me.steven.wirelessnetworks.network.NetworkState;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import team.reborn.energy.api.EnergyStorage;

public class Network
extends SnapshotParticipant<Long>
implements EnergyStorage {
    public static final long DEFAULT_MAX_ENERGY = 1000000L;
    private String id;
    private boolean isProtected;
    private final UUID owner;
    private long energy;
    private long energyCapacity = 1000000L;
    private long maxInput = 1000000L;
    private long maxOutput = 1000000L;

    private Network(String id, boolean isProtected, UUID owner, long energy, long energyCapacity, long maxInput, long maxOutput) {
        this.id = id;
        this.isProtected = isProtected;
        this.owner = owner;
        this.energy = energy;
        this.energyCapacity = energyCapacity;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
    }

    public Network(String id, UUID owner) {
        this.id = id;
        this.owner = owner;
    }

    public String getId() {
        return this.id;
    }

    public long getAmount() {
        return this.energy;
    }

    public long getCapacity() {
        return this.energyCapacity;
    }

    public void setEnergyCapacity(long energyCapacity) {
        this.energyCapacity = energyCapacity;
        this.energy = Math.min(this.energy, energyCapacity);
    }

    public boolean supportsInsertion() {
        return this.maxInput > 0L;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long inserted = Math.min(this.maxInput, Math.min(maxAmount, this.energyCapacity - this.energy));
        if (inserted > 0L) {
            this.updateSnapshots(transaction);
            this.energy += inserted;
            return inserted;
        }
        return 0L;
    }

    public long getMaxInput() {
        return this.maxInput;
    }

    public void setMaxInput(long maxInput) {
        this.maxInput = Math.min(maxInput, this.energyCapacity);
    }

    public boolean supportsExtraction() {
        return this.maxOutput > 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        long extracted = Math.min(this.maxOutput, Math.min(maxAmount, this.energy));
        if (extracted > 0L) {
            this.updateSnapshots(transaction);
            this.energy -= extracted;
            return extracted;
        }
        return 0L;
    }

    public long getMaxOutput() {
        return this.maxOutput;
    }

    public void setMaxOutput(long maxOutput) {
        this.maxOutput = Math.min(maxOutput, this.energyCapacity);
    }

    public void markProtected(NetworkState state) {
        if (!this.isProtected) {
            this.isProtected = true;
            state.delete(this.id);
            this.id = this.owner.toString() + ":" + this.id;
            state.put(this.id, this);
        }
    }

    public void markPublic(NetworkState state) {
        if (this.isProtected) {
            this.isProtected = false;
            state.delete(this.id);
            this.id = this.id.substring(this.owner.toString().length() + 1);
            state.put(this.id, this);
        }
    }

    protected Long createSnapshot() {
        return this.energy;
    }

    protected void readSnapshot(Long snapshot) {
        this.energy = snapshot;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean canInteract(class_1657 player) {
        return player.method_31549().field_7477 || !this.isProtected || this.owner.equals(player.method_5667());
    }

    public boolean canModify(class_1657 player) {
        return player.method_31549().field_7477 || this.owner.equals(player.method_5667());
    }

    public void writeScreenData(class_2540 buf) {
        buf.method_10814(this.id);
        buf.writeLong(this.energyCapacity);
        buf.writeLong(this.maxInput);
        buf.writeLong(this.maxOutput);
        buf.writeBoolean(this.isProtected);
        buf.method_10797(this.owner);
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10544("energy", this.energy);
        tag.method_10544("energyCapacity", this.energyCapacity);
        tag.method_10582("id", this.id);
        tag.method_25927("owner", this.owner);
        tag.method_10556("protected", this.isProtected);
        tag.method_10544("maxInput", this.maxInput);
        tag.method_10544("maxOutput", this.maxOutput);
        return tag;
    }

    public static Network fromTag(class_2487 tag) {
        long energy = tag.method_10537("energy");
        long energyCapacity = tag.method_10537("energyCapacity");
        String id = tag.method_10558("id");
        long maxInput = tag.method_10537("maxInput");
        long maxOutput = tag.method_10537("maxOutput");
        boolean isProtected = tag.method_10577("protected");
        UUID playerUuid = tag.method_25926("owner");
        return new Network(id, isProtected, playerUuid, energy, energyCapacity, maxInput, maxOutput);
    }
}

