/*
 * Decompiled with CFR 0.152.
 */
package me.steven.wirelessnetworks.gui;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import me.steven.wirelessnetworks.PacketHelper;
import me.steven.wirelessnetworks.WirelessNetworks;
import me.steven.wirelessnetworks.blockentity.NetworkNodeBlockEntity;
import me.steven.wirelessnetworks.gui.widgets.WConfigScreenListPanel;
import me.steven.wirelessnetworks.gui.widgets.WNetworkListEntry;
import me.steven.wirelessnetworks.gui.widgets.WNoBGButton;
import me.steven.wirelessnetworks.gui.widgets.WWarning;
import me.steven.wirelessnetworks.utils.Utils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1661;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class NetworkNodeScreen
extends SyncedGuiDescription {
    private static final class_2960 TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/select_network_screen.png");
    private static final class_2960 ADD_TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/icon_add.png");
    private static final class_2960 DELETE_TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/icon_delete.png");
    private static final class_2960 EDIT_TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/icon_edit.png");
    private static final class_2960 INPUT_TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/icon_input.png");
    private static final class_2960 OUTPUT_TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/icon_output.png");
    @Environment(value=EnvType.CLIENT)
    public final WWarning warning = new WWarning();

    public NetworkNodeScreen(class_2338 pos, boolean input, List<String> networks, int syncId, class_1661 playerInventory) {
        super(WirelessNetworks.NODE_SCREEN_TYPE, syncId, playerInventory);
        final boolean[] i = new boolean[]{input};
        final AtomicInteger confirm = new AtomicInteger();
        final WNoBGButton deleteNetwork = new WNoBGButton(){

            public void addTooltip(TooltipBuilder tooltip) {
                if (confirm.get() == 1) {
                    tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.delete.confirm")});
                } else {
                    tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.delete")});
                }
            }
        };
        WGridPanel panel = new WGridPanel(){

            public InputResult onMouseMove(int x, int y) {
                super.onMouseMove(x, y);
                if (!deleteNetwork.isWithinBounds(x, y)) {
                    confirm.set(0);
                    return InputResult.PROCESSED;
                }
                return InputResult.IGNORED;
            }
        };
        this.rootPanel = panel;
        panel.add((WWidget)this.warning, 0, 0);
        this.warning.setLocation(0, -5);
        WLabel title = new WLabel((class_2561)new class_2588("block.wirelessnetworks.node_block"), -1);
        panel.add((WWidget)title, 0, 1);
        WLabel label = new WLabel((class_2561)new class_2588("gui.wirelessnetworks.network.select"), -1);
        class_2586 blockEntity = this.world.method_8321(pos);
        String[] selectedNetworkId = new String[]{null};
        if (blockEntity instanceof NetworkNodeBlockEntity) {
            selectedNetworkId[0] = ((NetworkNodeBlockEntity)blockEntity).getNetworkId();
            if (selectedNetworkId[0] != null && networks.contains(selectedNetworkId[0])) {
                label.setText((class_2561)new class_2585(Utils.getDisplayId(selectedNetworkId[0])));
            }
        }
        panel.add((WWidget)label, 0, 2);
        UUID uuid = playerInventory.field_7546.method_5667();
        WConfigScreenListPanel list = new WConfigScreenListPanel(networks, () -> new WNetworkListEntry(uuid, this.world), (networkId, entry) -> {
            entry.setId((String)networkId);
            entry.setText((class_2561)new class_2585(Utils.getDisplayId(networkId)));
            entry.setClickAction(() -> {
                label.setText((class_2561)new class_2585(Utils.getDisplayId(networkId)));
                class_2540 buf = PacketByteBufs.create();
                buf.method_10807(pos);
                buf.method_10814(networkId);
                selectedNetworkId[0] = networkId;
                ClientPlayNetworking.send((class_2960)PacketHelper.SELECT_NETWORK, (class_2540)buf);
            });
            entry.setIsSelected(() -> networkId.equals(selectedNetworkId[0]));
            entry.setSize(73, 15);
        });
        list.setListItemHeight(20);
        panel.add((WWidget)list, 0, 3);
        list.setLocation(0, 48);
        list.setSize(92, 119);
        WNoBGButton createButton = new WNoBGButton(){

            public void addTooltip(TooltipBuilder tooltip) {
                tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.create")});
            }
        };
        createButton.setOnClick(() -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10807(pos);
            buf.writeBoolean(true);
            ClientPlayNetworking.send((class_2960)PacketHelper.OPEN_CONFIGURE_SCREEN, (class_2540)buf);
        });
        panel.add((WWidget)createButton, 5, 10);
        createButton.setLocation(99, 174);
        createButton.setSize(8, 8);
        createButton.setIcon(ADD_TEXTURE_ID);
        WNoBGButton configureButton = new WNoBGButton(){

            public void addTooltip(TooltipBuilder tooltip) {
                tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.edit")});
            }
        };
        configureButton.setOnClick(() -> {
            if (selectedNetworkId[0] != null) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10807(pos);
                buf.writeBoolean(false);
                buf.method_10814(selectedNetworkId[0]);
                ClientPlayNetworking.send((class_2960)PacketHelper.OPEN_CONFIGURE_SCREEN, (class_2540)buf);
            }
        });
        panel.add((WWidget)configureButton, 4, 10);
        configureButton.setLocation(81, 174);
        configureButton.setSize(8, 8);
        configureButton.setIcon(EDIT_TEXTURE_ID);
        deleteNetwork.setOnClick(() -> {
            if (selectedNetworkId[0] != null) {
                if (confirm.get() == 0) {
                    confirm.set(1);
                } else if (confirm.get() == 1 && class_437.method_25442()) {
                    class_2540 buf = PacketByteBufs.create();
                    buf.method_10814(selectedNetworkId[0]);
                    buf.method_10807(pos);
                    ClientPlayNetworking.send((class_2960)PacketHelper.DELETE_NETWORK, (class_2540)buf);
                    selectedNetworkId[0] = null;
                    confirm.set(0);
                }
            }
        });
        panel.add((WWidget)deleteNetwork, 3, 10);
        deleteNetwork.setLocation(63, 174);
        deleteNetwork.setSize(8, 8);
        deleteNetwork.setIcon(DELETE_TEXTURE_ID);
        WNoBGButton modeBtn = new WNoBGButton(){

            public void addTooltip(TooltipBuilder tooltip) {
                tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.input." + i[0])});
            }
        };
        modeBtn.setLabel((class_2561)new class_2588("gui.wirelessnetworks.network.input." + input));
        modeBtn.setOnClick(() -> {
            i[0] = !i[0];
            class_2540 buf = PacketByteBufs.create();
            buf.method_10807(pos);
            buf.writeBoolean(i[0]);
            ClientPlayNetworking.send((class_2960)PacketHelper.MODE_PACKET, (class_2540)buf);
            modeBtn.setIcon(this.getTexture(i[0]));
        });
        panel.add((WWidget)modeBtn, 3, 6);
        modeBtn.setLocation(45, 174);
        modeBtn.setSize(8, 8);
        modeBtn.setIcon(this.getTexture(i[0]));
        panel.validate((GuiDescription)this);
    }

    private class_2960 getTexture(boolean input) {
        if (input) {
            return INPUT_TEXTURE_ID;
        }
        return OUTPUT_TEXTURE_ID;
    }

    public void addPainters() {
        super.addPainters();
        this.rootPanel.setBackgroundPainter((matrices, x, y, panel) -> ScreenDrawing.texturedRect((class_4587)matrices, (int)(x - 8), (int)(y - 8 + 18), (int)124, (int)180, (class_2960)TEXTURE_ID, (int)-1));
    }
}

