/*
 * Decompiled with CFR 0.152.
 */
package me.steven.wirelessnetworks.gui;

import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.widget.TooltipBuilder;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.regex.Pattern;
import me.steven.wirelessnetworks.PacketHelper;
import me.steven.wirelessnetworks.WirelessNetworks;
import me.steven.wirelessnetworks.gui.widgets.WFixedToggleButton;
import me.steven.wirelessnetworks.gui.widgets.WNoBGButton;
import me.steven.wirelessnetworks.gui.widgets.WNoBGTextField;
import me.steven.wirelessnetworks.gui.widgets.WWarning;
import me.steven.wirelessnetworks.utils.Utils;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1661;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class NetworkConfigureScreen
extends SyncedGuiDescription {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[0-9]+$");
    private static final class_2960 TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/configure_network_screen.png");
    private static final class_2960 SAVE_TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/icon_save.png");
    private static final class_2960 PRIVATE_TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/icon_private.png");
    private static final class_2960 PUBLIC_TEXTURE_ID = new class_2960("wirelessnetworks", "textures/gui/icon_public.png");
    public final WWarning warning = new WWarning();
    private WTextField networkIdField = null;

    public NetworkConfigureScreen(class_2338 pos, @Nullable String networkId, UUID owner, boolean isProtected, long energyCapacity, long maxInput, long maxOutput, int syncId, class_1661 playerInventory) {
        super(WirelessNetworks.CONFIGURE_SCREEN_TYPE, syncId, playerInventory);
        WGridPanel panel = new WGridPanel();
        this.rootPanel = panel;
        panel.add((WWidget)this.warning, 0, 0);
        this.warning.setLocation(0, -18);
        if (networkId == null) {
            this.networkIdField = new WNoBGTextField();
            this.networkIdField.setSuggestion((class_2561)new class_2588("gui.wirelessnetworks.network.suggestion"));
            panel.add((WWidget)this.networkIdField, 0, 0);
            this.networkIdField.setMaxLength(10);
            this.networkIdField.setSize(80, 18);
        } else {
            WLabel label = new WLabel(Utils.getDisplayId(networkId), -1);
            panel.add((WWidget)label, 0, 0);
            label.setLocation(4, 7);
        }
        WWidget energyCapacityTooltip = new WWidget(){

            public void addTooltip(TooltipBuilder tooltip) {
                tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.store")});
            }
        };
        panel.add(energyCapacityTooltip, 1, 3);
        energyCapacityTooltip.setSize(20, 20);
        energyCapacityTooltip.setLocation(0, 56);
        WNoBGTextField energyCapacityField = new WNoBGTextField();
        energyCapacityField.setText(String.valueOf((int)energyCapacity));
        energyCapacityField.setTextPredicate(Utils::isInt);
        panel.add((WWidget)energyCapacityField, 1, 3);
        energyCapacityField.setSize(65, 20);
        energyCapacityField.setLocation(22, 56);
        WWidget maxInputTooltip = new WWidget(){

            public void addTooltip(TooltipBuilder tooltip) {
                tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.receive")});
            }
        };
        panel.add(maxInputTooltip, 1, 1);
        maxInputTooltip.setSize(20, 20);
        maxInputTooltip.setLocation(0, 19);
        WNoBGTextField maxInputField = new WNoBGTextField();
        maxInputField.setText(String.valueOf((int)maxInput));
        maxInputField.setTextPredicate(Utils::isInt);
        panel.add((WWidget)maxInputField, 1, 1);
        maxInputField.setSize(65, 20);
        maxInputField.setLocation(22, 19);
        WWidget maxOutputTooltip = new WWidget(){

            public void addTooltip(TooltipBuilder tooltip) {
                tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.send")});
            }
        };
        panel.add(maxOutputTooltip, 1, 2);
        maxOutputTooltip.setSize(20, 20);
        maxOutputTooltip.setLocation(0, 38);
        WNoBGTextField maxOutputField = new WNoBGTextField();
        maxOutputField.setText(String.valueOf((int)maxOutput));
        maxOutputField.setTextPredicate(Utils::isInt);
        panel.add((WWidget)maxOutputField, 1, 2);
        maxOutputField.setSize(65, 20);
        maxOutputField.setLocation(22, 38);
        WFixedToggleButton isProtectedToggle = new WFixedToggleButton(){

            public void addTooltip(TooltipBuilder tooltip) {
                if (this.getToggle()) {
                    tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.public")});
                } else {
                    tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.private")});
                }
            }
        };
        isProtectedToggle.setToggle(isProtected);
        panel.add((WWidget)isProtectedToggle, 2, 4);
        isProtectedToggle.setSize(8, 8);
        isProtectedToggle.setLocation(63, 85);
        isProtectedToggle.setOffImage(new Texture(PUBLIC_TEXTURE_ID));
        isProtectedToggle.setOnImage(new Texture(PRIVATE_TEXTURE_ID));
        WNoBGButton save = new WNoBGButton(){

            public void addTooltip(TooltipBuilder tooltip) {
                tooltip.add(new class_2561[]{new class_2588("gui.wirelessnetworks.network.save")});
            }
        };
        save.setLabel((class_2561)new class_2588("gui.wirelessnetworks.network.save"));
        save.setOnClick(() -> {
            OptionalLong input = this.validate(maxInputField, new class_2588("wirelessnetworks.input"));
            OptionalLong output = this.validate(maxOutputField, new class_2588("wirelessnetworks.output"));
            OptionalLong capacity = this.validate(energyCapacityField, new class_2588("wirelessnetworks.capacity"));
            if (!(capacity.isPresent() && input.isPresent() && output.isPresent())) {
                return;
            }
            class_2540 buf = PacketByteBufs.create();
            buf.method_10807(pos);
            buf.writeBoolean(networkId == null);
            buf.method_10814(this.networkIdField != null ? Utils.sanitizeId(this.networkIdField.getText().trim()) : networkId);
            buf.writeLong(capacity.getAsLong());
            buf.writeLong(input.getAsLong());
            buf.writeLong(output.getAsLong());
            buf.writeBoolean(isProtectedToggle.getToggle());
            ClientPlayNetworking.send((class_2960)PacketHelper.UPDATE_NETWORK, (class_2540)buf);
        });
        panel.add((WWidget)save, 3, 6);
        save.setLocation(81, 85);
        save.setSize(8, 8);
        save.setIcon(SAVE_TEXTURE_ID);
        panel.validate((GuiDescription)this);
        if (this.networkIdField != null) {
            this.networkIdField.requestFocus();
        }
    }

    private OptionalLong validate(WTextField field, class_2588 title) {
        String text = field.getText();
        if (!NUMBER_PATTERN.matcher(text).matches()) {
            this.warning.text = new class_2588("warning.wirelessnetworks.network.invalid.numbers.only", new Object[]{title});
            this.warning.ticksRemaining = 400;
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Long.parseLong(text));
        }
        catch (NumberFormatException e) {
            this.warning.text = new class_2588("warning.wirelessnetworks.network.invalid", new Object[]{title});
            this.warning.ticksRemaining = 400;
            return OptionalLong.empty();
        }
    }

    public void addPainters() {
        super.addPainters();
        this.rootPanel.setBackgroundPainter((matrices, x, y, panel) -> ScreenDrawing.texturedRect((class_4587)matrices, (int)(x - 8), (int)y, (int)106, (int)100, (class_2960)TEXTURE_ID, (int)-1));
    }
}

