/*
 * Decompiled with CFR 0.152.
 */
package me.steven.wirelessnetworks.blockentity;

import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.steven.wirelessnetworks.WirelessNetworks;
import me.steven.wirelessnetworks.gui.NetworkNodeScreen;
import me.steven.wirelessnetworks.network.Network;
import me.steven.wirelessnetworks.network.NetworkState;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class NetworkNodeBlockEntity
extends class_2586
implements class_3908,
class_1275,
ExtendedScreenHandlerFactory {
    private String networkId = null;
    private boolean input = false;
    public EnumSet<class_2350> validDirections = EnumSet.allOf(class_2350.class);

    public NetworkNodeBlockEntity(class_2338 pos, class_2680 state) {
        super(WirelessNetworks.NODE_BLOCK_ENTITY_TYPE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, NetworkNodeBlockEntity blockEntity) {
        if (blockEntity.isOutput()) {
            for (class_2350 dir : class_2350.values()) {
                EnergyStorage sourceIo;
                if (!blockEntity.validDirections.contains(dir) || (sourceIo = (EnergyStorage)EnergyStorage.SIDED.find(world, pos, (Object)dir)) == null) continue;
                EnergyStorage targetIo = (EnergyStorage)EnergyStorage.SIDED.find(world, pos.method_10093(dir), (Object)dir.method_10153());
                if (targetIo == null) {
                    blockEntity.validDirections.remove(dir);
                    continue;
                }
                if (!sourceIo.supportsExtraction() || !targetIo.supportsInsertion()) continue;
                EnergyStorageUtil.move((EnergyStorage)sourceIo, (EnergyStorage)targetIo, (long)Long.MAX_VALUE, null);
            }
        }
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(String networkId) {
        this.networkId = networkId;
    }

    public Optional<Network> getNetwork() {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        return NetworkState.getOrCreate(((class_3218)this.field_11863).method_8503()).getNetworkHandler(this.networkId);
    }

    public void setMode(boolean input) {
        this.input = input;
    }

    public boolean isInput() {
        return this.input;
    }

    public boolean isOutput() {
        return !this.input;
    }

    public class_2561 method_5477() {
        return new class_2588("block.wirelessnetworks.node_block");
    }

    public class_2561 method_5476() {
        return new class_2588("block.wirelessnetworks.node_block");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        List<String> keys = NetworkState.getOrCreate(((class_3218)this.field_11863).method_8503()).getNetworks().entrySet().stream().filter(entry -> ((Network)((Object)((Object)entry.getValue()))).canInteract(player)).map(Map.Entry::getKey).collect(Collectors.toList());
        return new NetworkNodeScreen(this.field_11867, this.input, keys, syncId, inv);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
        buf.writeBoolean(this.input);
        Set<String> keys = NetworkState.getOrCreate(((class_3218)this.field_11863).method_8503()).getNetworks().entrySet().stream().filter(entry -> ((Network)((Object)((Object)entry.getValue()))).canInteract((class_1657)player)).map(Map.Entry::getKey).collect(Collectors.toSet());
        buf.writeInt(keys.size());
        keys.forEach(arg_0 -> ((class_2540)buf).method_10814(arg_0));
    }

    public void method_11007(class_2487 tag) {
        if (this.networkId != null) {
            tag.method_10582("NetworkID", this.networkId);
        }
        tag.method_10556("Input", this.input);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10545("NetworkID")) {
            this.networkId = tag.method_10558("NetworkID");
        }
        this.input = tag.method_10577("Input");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.method_11007(nbt);
        return nbt;
    }

    public void sync() {
        Preconditions.checkNotNull((Object)this.field_11863);
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            throw new IllegalStateException("Cannot call sync() on the logical client! Did you check world.isClient first?");
        }
        class_3218 serverWorld = (class_3218)class_19372;
        serverWorld.method_14178().method_14128(this.method_11016());
    }
}

