/*
 * Decompiled with CFR 0.152.
 */
package me.steven.wirelessnetworks;

import java.util.Optional;
import me.steven.wirelessnetworks.blockentity.NetworkNodeBlockEntity;
import me.steven.wirelessnetworks.gui.NetworkConfigureScreen;
import me.steven.wirelessnetworks.gui.NetworkConfigureScreenFactory;
import me.steven.wirelessnetworks.gui.NetworkNodeScreen;
import me.steven.wirelessnetworks.network.Network;
import me.steven.wirelessnetworks.network.NetworkState;
import me.steven.wirelessnetworks.utils.Utils;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

public class PacketHelper {
    public static final class_2960 OPEN_CONFIGURE_SCREEN = new class_2960("wirelessnetworks", "open_configure_screen");
    public static final class_2960 UPDATE_NETWORK = new class_2960("wirelessnetworks", "update_network");
    public static final class_2960 SELECT_NETWORK = new class_2960("wirelessnetworks", "select_network");
    public static final class_2960 DELETE_NETWORK = new class_2960("wirelessnetworks", "delete_network");
    public static final class_2960 WARNING_PACKET = new class_2960("wirelessnetworks", "warning_packet");
    public static final class_2960 MODE_PACKET = new class_2960("wirelessnetworks", "mode_packet");

    public static void registerServer() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OPEN_CONFIGURE_SCREEN, (server, player, networkHandler, buf, sender) -> {
            class_2338 blockPos = buf.method_10811();
            boolean isNewNetwork = buf.readBoolean();
            String networkId = isNewNetwork ? null : buf.method_10800(Short.MAX_VALUE);
            server.execute(() -> {
                Network network;
                if (isNewNetwork) {
                    network = null;
                } else {
                    Optional<Network> optional = NetworkState.getOrCreate(server).getNetworkHandler(networkId);
                    if (!optional.isPresent()) {
                        PacketHelper.sendWarning("warning.wirelessnetworks.network.doesnt.exist", player);
                        return;
                    }
                    network = optional.get();
                }
                if (network == null || network.canModify((class_1657)player)) {
                    player.method_17355((class_3908)new NetworkConfigureScreenFactory(blockPos, network, player));
                } else {
                    PacketHelper.sendWarning("warning.wirelessnetworks.network.modify.dont.own", player);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)UPDATE_NETWORK, (server, player, networkHandler, buf, sender) -> {
            class_2338 pos = buf.method_10811();
            boolean isCreating = buf.readBoolean();
            String networkId = buf.method_10800(Short.MAX_VALUE);
            long capacity = buf.readLong();
            long maxInput = buf.readLong();
            long maxOutput = buf.readLong();
            boolean isProtected = buf.readBoolean();
            server.execute(() -> {
                Network network;
                NetworkState state = NetworkState.getOrCreate(server);
                if (networkId.isEmpty()) {
                    PacketHelper.sendWarning("warning.wirelessnetworks.network.id.empty", player);
                    return;
                }
                Optional<Network> optional = state.getNetworkHandler(networkId);
                if (isCreating) {
                    if (optional.isPresent()) {
                        PacketHelper.sendWarning("warning.wirelessnetworks.network.doesnt.exist", player);
                        return;
                    }
                    if (Utils.getDisplayId(networkId).length() > 10) {
                        PacketHelper.sendWarning("warning.wirelessnetworks.network.id.characters", player);
                        return;
                    }
                    if (Utils.getDisplayId(networkId).trim().isEmpty()) {
                        PacketHelper.sendWarning("warning.wirelessnetworks.network.id.empty", player);
                        return;
                    }
                    network = state.getOrCreateNetworkHandler(networkId, player.method_5667());
                } else {
                    if (!optional.isPresent()) {
                        PacketHelper.sendWarning("warning.wirelessnetworks.network.doesnt.exist", player);
                        return;
                    }
                    network = optional.get();
                }
                if (!network.canModify((class_1657)player)) {
                    PacketHelper.sendWarning("warning.wirelessnetworks.network.modify.dont.own", player);
                    return;
                }
                network.setEnergyCapacity(capacity);
                network.setMaxInput(maxInput);
                network.setMaxOutput(maxOutput);
                if (isProtected && !network.isProtected()) {
                    network.markProtected(state);
                } else if (!isProtected && network.isProtected()) {
                    network.markPublic(state);
                }
                state.method_80();
                class_2586 blockEntity = player.field_6002.method_8321(pos);
                if (blockEntity instanceof NetworkNodeBlockEntity) {
                    player.method_17355((class_3908)((NetworkNodeBlockEntity)blockEntity));
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SELECT_NETWORK, (server, player, networkHandler, buf, sender) -> {
            class_2338 pos = buf.method_10811();
            String networkId = buf.method_10800(Short.MAX_VALUE);
            server.execute(() -> {
                NetworkState state = NetworkState.getOrCreate(server);
                Optional<Network> optional = state.getNetworkHandler(networkId);
                if (!optional.isPresent()) {
                    PacketHelper.sendWarning("warning.wirelessnetworks.network.doesnt.exist", player);
                    return;
                }
                if (!optional.get().canInteract((class_1657)player)) {
                    PacketHelper.sendWarning("warning.wirelessnetworks.network.misc", player);
                    return;
                }
                class_2586 blockEntity = player.field_6002.method_8321(pos);
                if (blockEntity instanceof NetworkNodeBlockEntity) {
                    ((NetworkNodeBlockEntity)blockEntity).setNetworkId(networkId);
                    blockEntity.method_5431();
                    ((NetworkNodeBlockEntity)blockEntity).sync();
                    blockEntity.method_10997().method_8408(pos, blockEntity.method_11010().method_26204());
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)DELETE_NETWORK, (server, player, networkHandler, buf, sender) -> {
            String networkId = buf.method_10800(Short.MAX_VALUE);
            class_2338 pos = buf.method_10811();
            server.execute(() -> {
                NetworkState state = NetworkState.getOrCreate(server);
                Optional<Network> optional = state.getNetworkHandler(networkId);
                if (!optional.isPresent()) {
                    PacketHelper.sendWarning("warning.wirelessnetworks.network.doesnt.exist", player);
                    return;
                }
                if (!optional.get().canModify((class_1657)player)) {
                    PacketHelper.sendWarning("warning.wirelessnetworks.network.modify.dont.own", player);
                    return;
                }
                state.delete(networkId);
                state.method_80();
                class_2586 blockEntity = player.field_6002.method_8321(pos);
                if (blockEntity instanceof NetworkNodeBlockEntity) {
                    player.method_17355((class_3908)((NetworkNodeBlockEntity)blockEntity));
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MODE_PACKET, (server, player, networkHandler, buf, sender) -> {
            class_2338 pos = buf.method_10811();
            boolean input = buf.readBoolean();
            server.execute(() -> {
                class_2586 blockEntity = player.field_6002.method_8321(pos);
                if (blockEntity instanceof NetworkNodeBlockEntity) {
                    NetworkNodeBlockEntity node = (NetworkNodeBlockEntity)blockEntity;
                    node.setMode(input);
                    node.method_5431();
                }
            });
        });
    }

    public static void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)WARNING_PACKET, (client, networkHandler, buf, packetSender) -> {
            String warning = buf.method_19772();
            client.execute(() -> {
                class_1703 currentScreenHandler = client.field_1724.field_7512;
                if (currentScreenHandler instanceof NetworkNodeScreen) {
                    ((NetworkNodeScreen)currentScreenHandler).warning.text = new class_2588(warning);
                    ((NetworkNodeScreen)currentScreenHandler).warning.ticksRemaining = 400;
                } else if (currentScreenHandler instanceof NetworkConfigureScreen) {
                    ((NetworkConfigureScreen)currentScreenHandler).warning.text = new class_2588(warning);
                    ((NetworkConfigureScreen)currentScreenHandler).warning.ticksRemaining = 400;
                }
            });
        });
    }

    private static void sendWarning(String warning, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(warning);
        ServerPlayNetworking.send((class_3222)player, (class_2960)WARNING_PACKET, (class_2540)buf);
    }
}

