/*
 * Decompiled with CFR 0.152.
 */
package artifality.util;

import artifality.extension.Artifact;
import artifality.item.base.TieredItem;
import artifality.list.ArtifactRarity;
import dev.emi.trinkets.api.Trinket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class TooltipAppender {
    protected TooltipAppender() {
    }

    public static void append(class_1799 stack, List<class_2561> tooltip) {
        class_1792 item = stack.method_7909();
        if (!TooltipAppender.getTooltip(class_2378.field_11142.method_10221((Object)item).method_12832()).isEmpty() && TooltipAppender.shiftPressed(tooltip, item)) {
            if (item instanceof TieredItem) {
                TooltipAppender.appendTier(stack, tooltip);
            }
            TooltipAppender.appendItemTooltip(stack, tooltip);
        } else if (item instanceof class_1772 && !FabricLoader.getInstance().isModLoaded("enchdesc")) {
            TooltipAppender.appendEnchantmentTooltip(stack, tooltip);
        }
    }

    private static boolean shiftPressed(List<class_2561> tooltip, class_1792 item) {
        if (!class_437.method_25442()) {
            if (item instanceof Artifact) {
                Artifact artifact = (Artifact)item;
                ArtifactRarity rarity = artifact.getSettings().getRarity();
                tooltip.add((class_2561)new class_2585(TooltipAppender.ofKey(rarity.getName())).method_10862(class_2583.field_24360.method_36139(rarity.getColor().getRGB())));
            }
            if (!(item instanceof class_1772) || !FabricLoader.getInstance().isModLoaded("enchdesc")) {
                tooltip.add((class_2561)new class_2585(""));
                tooltip.add((class_2561)new class_2585(TooltipAppender.ofKey("press_shift")).method_27692(class_124.field_1080));
            }
            if (item instanceof Trinket) {
                tooltip.add((class_2561)new class_2585(""));
            }
            return false;
        }
        return true;
    }

    private static void appendTier(class_1799 stack, List<class_2561> tooltip) {
        class_2585 tierString = new class_2585(TooltipAppender.ofKey("tier").replaceAll("%", Integer.toString(TieredItem.getCurrentTier(stack))));
        switch (TieredItem.getCurrentTier(stack)) {
            default: {
                tooltip.add((class_2561)tierString);
                break;
            }
            case 2: {
                tooltip.add((class_2561)tierString.method_27692(class_124.field_1060));
                break;
            }
            case 3: {
                tooltip.add((class_2561)tierString.method_27692(class_124.field_1076));
            }
        }
    }

    private static void appendItemTooltip(class_1799 stack, List<class_2561> tooltip) {
        tooltip.add((class_2561)new class_2585(""));
        for (String line : TooltipAppender.getTooltip(class_2378.field_11142.method_10221((Object)stack.method_7909()).method_12832())) {
            tooltip.add((class_2561)new class_2585(line.trim().replaceAll("&", "\u00a7")).method_27692(class_124.field_1080));
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof Artifact) {
            Artifact item = (Artifact)class_17922;
            item.appendTooltipInfo(stack, tooltip);
        }
        if (stack.method_7909() instanceof Trinket) {
            tooltip.add((class_2561)new class_2585(""));
        }
    }

    private static void appendEnchantmentTooltip(class_1799 stack, List<class_2561> tooltip) {
        class_2499 enchantments = class_1772.method_7806((class_1799)stack);
        for (int i = 0; i < enchantments.size(); ++i) {
            class_2487 nbtCompound = enchantments.method_10602(i);
            class_2378.field_11160.method_17966(class_2960.method_12829((String)nbtCompound.method_10558("id"))).ifPresent(enchantment -> {
                if (!enchantment.method_8184().contains("artifality")) {
                    return;
                }
                if (!TooltipAppender.shiftPressed(tooltip, stack.method_7909())) {
                    return;
                }
                tooltip.add((class_2561)new class_2585(""));
                for (String line : TooltipAppender.getTooltip(Objects.requireNonNull(class_2378.field_11160.method_10221(enchantment)).method_12832())) {
                    tooltip.add((class_2561)new class_2585(line.trim().replaceAll("&", "\u00a7")).method_27692(class_124.field_1080));
                }
                if (enchantment.method_8183() > 1) {
                    tooltip.add((class_2561)new class_2585(""));
                    tooltip.add((class_2561)new class_2585(TooltipAppender.ofKey("max_level").replaceAll("%", Integer.toString(enchantment.method_8183()))).method_27692(class_124.field_1077));
                }
            });
        }
    }

    public static ArrayList<String> getTooltip(String id) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i <= 10; ++i) {
            if (!class_2477.method_10517().method_4678("tip." + id + "." + i)) continue;
            strings.add(class_2477.method_10517().method_4679("tip." + id + "." + i));
        }
        return strings;
    }

    public static String ofKey(String name) {
        return class_2477.method_10517().method_4679("misc.artifality." + name).replaceAll("&", "\u00a7");
    }
}

