/*
 * Decompiled with CFR 0.152.
 */
package artifality.block;

import artifality.block.base.BaseBlock;
import artifality.extension.Artifact;
import artifality.extension.ArtifactChances;
import artifality.list.ArtifactRarity;
import artifality.registry.ArtifalityItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class CrateBlock
extends BaseBlock
implements class_3737 {
    public static final class_265 SHAPE = CrateBlock.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final ArrayList<class_1792> CRYSTALS = new ArrayList<class_1792>(List.of(ArtifalityItems.INCREMENTAL_CRYSTAL, ArtifalityItems.LUNAR_CRYSTAL, ArtifalityItems.LIFE_CRYSTAL));
    private final ArrayList<class_1792> commonArtifacts = new ArrayList();
    private final ArrayList<class_1792> rareArtifacts = new ArrayList();
    private final ArrayList<class_1792> legendaryArtifacts = new ArrayList();
    private final ArtifactRarity rarity;

    public CrateBlock(class_4970.class_2251 settings, ArtifactRarity rarity) {
        super(settings);
        this.rarity = rarity;
        ArtifalityItems.ITEMS.forEach((id, item) -> {
            if (item instanceof Artifact) {
                Artifact artifact = (Artifact)item;
                ArtifactRarity artifactRarity = artifact.getSettings().getRarity();
                switch (artifactRarity) {
                    case COMMON: {
                        this.commonArtifacts.add((class_1792)item);
                        break;
                    }
                    case RARE: {
                        this.rareArtifacts.add((class_1792)item);
                        break;
                    }
                    case LEGENDARY: {
                        this.legendaryArtifacts.add((class_1792)item);
                    }
                }
            }
        });
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void method_9556(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 stack) {
        super.method_9556(world, player, pos, state, blockEntity, stack);
        if (!class_1890.method_8222((class_1799)player.method_5998(class_1268.field_5808)).containsKey(class_1893.field_9099)) {
            this.dropCrateLoot(world, player, pos);
        } else {
            CrateBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)this.method_8389().method_7854());
        }
    }

    public void dropCrateLoot(class_1937 world, class_1657 player, class_2338 pos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.method_9583(serverWorld, pos, 5);
            this.method_9583(serverWorld, pos, 5 + world.field_9229.nextInt(6));
            this.method_9583(serverWorld, pos, 5 + world.field_9229.nextInt(11));
        }
        if (Math.random() < 0.5) {
            CrateBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)CRYSTALS.get(world.field_9229.nextInt(CRYSTALS.size())), world.field_9229.nextInt(5) + 1));
        }
        if (player instanceof ArtifactChances) {
            ArtifactChances extension = (ArtifactChances)player;
            this.dropArtifact(extension, world, pos);
            this.incrementAmplifiers(player, extension);
        }
    }

    public void incrementAmplifiers(class_1657 player, ArtifactChances extension) {
        int common = extension.artifality$getCommonAmplifier();
        int rare = extension.artifality$getRareAmplifier();
        int legendary = extension.artifality$getLegendaryAmplifier();
        switch (this.rarity) {
            case RARE: {
                common += 5;
                rare += 10;
                legendary += 3;
                break;
            }
            case LEGENDARY: {
                common += 5;
                rare += 5;
                legendary += 10;
                break;
            }
            default: {
                common += 10;
                rare += 5;
                legendary += 3;
            }
        }
        extension.artifality$setCommonAmplifier(common);
        extension.artifality$setRareAmplifier(rare);
        extension.artifality$setLegendaryAmplifier(legendary);
    }

    public void dropArtifact(ArtifactChances extension, class_1937 world, class_2338 pos) {
        int common = extension.artifality$getCommonAmplifier();
        int rare = extension.artifality$getRareAmplifier();
        int legendary = extension.artifality$getLegendaryAmplifier();
        if (Math.random() < (double)legendary / 100.0) {
            CrateBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)this.legendaryArtifacts.get(world.field_9229.nextInt(this.legendaryArtifacts.size()))));
            extension.artifality$setLegendaryAmplifier(0);
        }
        if (Math.random() < (double)rare / 100.0) {
            CrateBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)this.rareArtifacts.get(world.field_9229.nextInt(this.rareArtifacts.size()))));
            extension.artifality$setRareAmplifier(0);
        }
        if (Math.random() < (double)common / 100.0) {
            CrateBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)this.commonArtifacts.get(world.field_9229.nextInt(this.commonArtifacts.size()))));
            extension.artifality$setCommonAmplifier(0);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        return (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15767((class_3494)class_3486.field_15517) && fluidState.method_15761() == 8));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }
}

