/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal;

import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.PlayerAbilityEnableCallback;
import io.github.ladysnake.pal.PlayerAbilityUpdatedCallback;
import io.github.ladysnake.pal.impl.PalInternals;
import io.github.ladysnake.pal.impl.VanillaAbilityTracker;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class SimpleAbilityTracker
implements AbilityTracker {
    protected final class_1657 player;
    protected final SortedSet<AbilitySource> abilitySources = new TreeSet<AbilitySource>();
    protected final PlayerAbility ability;

    public SimpleAbilityTracker(PlayerAbility ability, class_1657 player) {
        this.ability = ability;
        this.player = player;
    }

    @Override
    public void addSource(AbilitySource abilitySource) {
        boolean wasEmpty = this.abilitySources.isEmpty();
        if (this.abilitySources.add(abilitySource) && wasEmpty && ((PlayerAbilityEnableCallback)PlayerAbilityEnableCallback.EVENT.invoker()).allow(this.player, this.ability, abilitySource)) {
            this.updateState(true);
            this.sync();
        }
    }

    @Override
    public void removeSource(AbilitySource abilitySource) {
        if (this.abilitySources.remove(abilitySource) && this.abilitySources.isEmpty()) {
            this.updateState(false);
            this.sync();
        }
    }

    @Override
    public boolean isGrantedBy(AbilitySource abilitySource) {
        return this.abilitySources.contains(abilitySource);
    }

    @Override
    public AbilitySource getActiveSource() {
        return this.abilitySources.last();
    }

    @Override
    public void refresh(boolean syncVanilla) {
        this.updateState(this.shouldBeEnabled());
        if (syncVanilla || !(this instanceof VanillaAbilityTracker)) {
            this.sync();
        }
    }

    protected boolean shouldBeEnabled() {
        for (AbilitySource abilitySource : this.abilitySources) {
            if (!((PlayerAbilityEnableCallback)PlayerAbilityEnableCallback.EVENT.invoker()).allow(this.player, this.ability, abilitySource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void save(class_2487 tag) {
        class_2499 list = new class_2499();
        for (AbilitySource abilitySource : this.abilitySources) {
            list.add((Object)class_2519.method_23256((String)abilitySource.getId().toString()));
        }
        tag.method_10566("ability_sources", (class_2520)list);
    }

    @Override
    public void load(class_2487 tag) {
        class_2499 list = tag.method_10554("ability_sources", 8);
        for (int i = 0; i < list.size(); ++i) {
            AbilitySource source = PalInternals.getSource(class_2960.method_12829((String)list.method_10608(i)));
            if (source != null) {
                this.addSource(source);
                continue;
            }
            PalInternals.LOGGER.warn("Unknown ability source {} attached to {} for {}", (Object)list.method_10608(i), (Object)this.player, (Object)this.ability);
        }
    }

    protected void updateState(boolean enabled) {
        ((PlayerAbilityUpdatedCallback)PlayerAbilityUpdatedCallback.event(this.ability).invoker()).onAbilityUpdated(this.player, enabled);
    }

    protected void sync() {
    }

    @Override
    public boolean isEnabled() {
        return !this.abilitySources.isEmpty();
    }
}

