/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc;

import com.google.gson.Gson;
import dev.wuffs.bcc.BCC;
import dev.wuffs.bcc.ModConfig;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    static Path configFile = FabricLoader.getInstance().getConfigDir().resolve("bcc.json");

    public static boolean create() {
        BCC.getLogger().warn("Config file not found, creating default config");
        try {
            Files.write(configFile, new Gson().toJson((Object)new ModConfig()).getBytes(), StandardOpenOption.CREATE);
            return true;
        }
        catch (IOException e) {
            BCC.getLogger().error("Failed to create config file", (Throwable)e);
            return false;
        }
    }

    public static ModConfig load() {
        boolean didCreate;
        if (!Files.exists(configFile, new LinkOption[0]) && !(didCreate = Config.create())) {
            return null;
        }
        try {
            BCC.getLogger().info("Loading config file");
            return (ModConfig)new Gson().fromJson((Reader)Files.newBufferedReader(configFile), ModConfig.class);
        }
        catch (IOException e) {
            BCC.getLogger().error("Failed to read config file", (Throwable)e);
            return null;
        }
    }
}

